Name:           jenkins-jobs
Version:        1.7.6
%if 0%{?opensuse_bs}
Release:        1.<CI_CNT>.<B_CNT>
%else
Release:        1
%endif
License:        Intel Proprietary
Summary:        Build job configurations for jenkins
Url:            http://www.tizen.org
Group:          Development/Tools/Building
Source:         %{name}-%{version}.tar.gz
Requires:       jenkins-scripts >= 1.0-0.dev
Requires:       %{name}-common = %{version}
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildArch:      noarch

%define destdir /var/lib/jenkins/jobs

%description
Jenkins build job configurations.

%package common
Summary:    Common files for all jobs
Group:      Development/Tools/Building

%description common
Common part of Jenkins jobss for all instances

%package tzs
Summary:    Jobs for tzs customer appliance
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description tzs
Jenkins jobs for tzs customer appliance instance

%package tools-testing
Summary:    Jenkins jobs for tools-testing customer appliance instance
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description tools-testing
Jenkins jobs for tools-testing customer appliance instance

%package abs
Summary:    Jenkins jobs for separage ABS system
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description abs
Jenkins jobs for separate ABS system

%package gbs
Summary:    Jenkins jobs for separage GBS system
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description gbs
Jenkins jobs for separate GBS system

%package pmb
Summary:    Jenkins jobs for separate pmb system
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description pmb
Jenkins jobs for separate pmb system

%prep
%setup -q

%build

%install
install -d %{buildroot}%{destdir}
cp -rf jobs/* %{buildroot}%{destdir}/

%pre
/usr/bin/getent group jenkins >/dev/null || /usr/sbin/groupadd -r jenkins &>/dev/null || :
/usr/bin/getent passwd jenkins >/dev/null || /usr/sbin/useradd -g jenkins -s /bin/bash -r -c "Jenkins Continuous Build server" \
    -d /var/lib/jenkins jenkins &>/dev/null || :

%post common
if [ ! -d /var/lib/jenkins/userContent ]; then
  mkdir -p /var/lib/jenkins/userContent
fi
ln -sf %{destdir}/configuration /var/lib/jenkins/userContent/

%postun common
if [ ${1:-0} -eq 0 ]; then
  if [ -L /var/lib/jenkins/userContent/configuration ]; then
    rm -f /var/lib/jenkins/userContent/configuration
  fi
fi

%files
%defattr(-,jenkins,jenkins)
%dir /var/lib/jenkins
%dir %{destdir}
%dir %{destdir}/pre-release-gerrit/
%config %{destdir}/pre-release-gerrit/config.xml
%dir %{destdir}/pre-release-github/
%config %{destdir}/pre-release-github/config.xml
%dir %{destdir}/image-creator/
%config %{destdir}/image-creator/config.xml
%dir %{destdir}/image-tester/
%config %{destdir}/image-tester/config.xml
%dir %{destdir}/post-image-creation/
%config %{destdir}/post-image-creation/config.xml
%dir %{destdir}/requests/
%config %{destdir}/requests/config.xml
%dir %{destdir}/pre-release-create/
%config %{destdir}/pre-release-create/config.xml
%dir %{destdir}/pre-release-cleanup/
%config %{destdir}/pre-release-cleanup/config.xml
%dir %{destdir}/obs-event-dispatcher/
%config %{destdir}/obs-event-dispatcher/config.xml
%dir %{destdir}/load-repo-conf/
%config %{destdir}/load-repo-conf/config.xml
%dir %{destdir}/buildlogs/
%config %{destdir}/buildlogs/config.xml
%dir %{destdir}/make_dep_graph/
%config %{destdir}/make_dep_graph/config.xml
%dir %{destdir}/snapdiff-sync/
%config %{destdir}/snapdiff-sync/config.xml
%dir %{destdir}/release-snapshot/
%config %{destdir}/release-snapshot/config.xml
%dir %{destdir}/test-results-publisher/
%config %{destdir}/test-results-publisher/config.xml
%dir %{destdir}/monitor_scm_meta_git/
%config %{destdir}/monitor_scm_meta_git/config.xml
%dir %{destdir}/re/
%config %{destdir}/re/config.xml
%dir %{destdir}/rpm-build-log/
%config %{destdir}/rpm-build-log/config.xml
%dir %{destdir}/sync-obs/
%config %{destdir}/sync-obs/config.xml
%dir %{destdir}/purge-old-directories/
%config %{destdir}/purge-old-directories/config.xml
%dir %{destdir}/logs-collector/
%config %{destdir}/logs-collector/config.xml
%dir %{destdir}/check_scm_meta_git/
%config %{destdir}/check_scm_meta_git/config.xml
%dir %{destdir}/ref-snapshot-info-update/
%config %{destdir}/ref-snapshot-info-update/config.xml
%dir %{destdir}/ref-create-project-obs/
%config %{destdir}/ref-create-project-obs/config.xml
%dir %{destdir}/ref-copy-project-obs/
%config %{destdir}/ref-copy-project-obs/config.xml
%dir %{destdir}/ref-remote-create-project-obs/
%config %{destdir}/ref-remote-create-project-obs/config.xml
%dir %{destdir}/ref-import-rpm-obs/
%config %{destdir}/ref-import-rpm-obs/config.xml
%dir %{destdir}/ref-remote-import-rpm-obs/
%config %{destdir}/ref-remote-import-rpm-obs/config.xml
%dir %{destdir}/ref-purge-project-obs/
%config %{destdir}/ref-purge-project-obs/config.xml
%dir %{destdir}/ref-precheck-project-obs/
%config %{destdir}/ref-precheck-project-obs/config.xml
%dir %{destdir}/BUILD-MONITOR/
%config %{destdir}/BUILD-MONITOR/config.xml
%dir %{destdir}/BUILD-MONITOR-TRBS-UPDATE-BUILD-LOG/
%config %{destdir}/BUILD-MONITOR-TRBS-UPDATE-BUILD-LOG/config.xml
%dir %{destdir}/update-nuget/
%config %{destdir}/update-nuget/config.xml
%dir %{destdir}/add_git_tag/
%config %{destdir}/add_git_tag/config.xml
%dir %{destdir}/repa/
%config %{destdir}/repa/config.xml
%dir %{destdir}/TRBS_test_result_receiver/
%config %{destdir}/TRBS_test_result_receiver/config.xml
%dir %{destdir}/update_scm_meta_git_for_dashboard/
%config %{destdir}/update_scm_meta_git_for_dashboard/config.xml
%dir %{destdir}/update_git_obs_mapping_for_dashboard/
%config %{destdir}/update_git_obs_mapping_for_dashboard/config.xml
%dir %{destdir}/litmus_jira_issue_receiver/
%config %{destdir}/litmus_jira_issue_receiver/config.xml
%dir %{destdir}/litmus_tct_file_receiver/
%config %{destdir}/litmus_tct_file_receiver/config.xml
%dir %{destdir}/pre-release-image-creator/
%config %{destdir}/pre-release-image-creator/config.xml
%dir %{destdir}/update_local_git_for_dashboard/
%config %{destdir}/update_local_git_for_dashboard/config.xml
%dir %{destdir}/test-trigger-info-update/
%config %{destdir}/test-trigger-info-update/config.xml
%dir %{destdir}/test-trigger-automation/
%config %{destdir}/test-trigger-automation/config.xml
%dir %{destdir}/add_dotnet_launching_performance_test/
%config %{destdir}/add_dotnet_launching_performance_test/config.xml
%dir %{destdir}/Release/
%config %{destdir}/Release/config.xml
%dir %{destdir}/Pre-release/
%config %{destdir}/Pre-release/config.xml
%dir %{destdir}/create-sdkrootstrap/
%config %{destdir}/create-sdkrootstrap/config.xml
%dir %{destdir}/find-incorrect-filenames/
%config %{destdir}/find-incorrect-filenames/config.xml
%dir %{destdir}/rsync_download/
%config %{destdir}/rsync_download/config.xml
%dir %{destdir}/sync_repo/
%config %{destdir}/sync_repo/config.xml
%dir %{destdir}/update-public-git/
%config %{destdir}/update-public-git/config.xml
%dir %{destdir}/pre-release-gerrit-group/
%config %{destdir}/pre-release-gerrit-group/config.xml
%dir %{destdir}/pre-release-request/
%config %{destdir}/pre-release-request/config.xml
%dir %{destdir}/ondemand_slave_control/
%config %{destdir}/ondemand_slave_control/config.xml
%dir %{destdir}/ondemand_slave_imager_checker/
%config %{destdir}/ondemand_slave_imager_checker/config.xml
%dir %{destdir}/submit-request-git-sync/
%config %{destdir}/submit-request-git-sync/config.xml
%dir %{destdir}/repa_auto_reject/
%config %{destdir}/repa_auto_reject/config.xml
%dir %{destdir}/notify-buildstatus
%config %{destdir}/notify-buildstatus/config.xml
%dir %{destdir}/obs_worker_scailing
%config %{destdir}/obs_worker_scailing/config.xml
%dir %{destdir}/project_manager
%config %{destdir}/project_manager/config.xml
%dir %{destdir}/update_abs_rbs_for_dashboard
%config %{destdir}/update_abs_rbs_for_dashboard/config.xml
%dir %{destdir}/IMPORTRPM_OBS_SYNC/
%config %{destdir}/IMPORTRPM_OBS_SYNC/config.xml
%dir %{destdir}/trigger_for_sync_repo/
%config %{destdir}/trigger_for_sync_repo/config.xml
%dir %{destdir}/TRIGGER_OBS_SYNC/
%config %{destdir}/TRIGGER_OBS_SYNC/config.xml
%dir %{destdir}/Sync-MCD2SPIN-Git/
%config %{destdir}/Sync-MCD2SPIN-Git/config.xml
%dir %{destdir}/create-snapdiff-sync/
%config %{destdir}/create-snapdiff-sync/config.xml
%dir %{destdir}/create-snapshot-devel/
%config %{destdir}/create-snapshot-devel/config.xml
%dir %{destdir}/ref-copy-project-obs-sync-mapping/
%config %{destdir}/ref-copy-project-obs-sync-mapping/config.xml
%dir %{destdir}/repa-auto-reject/
%config %{destdir}/repa-auto-reject/config.xml
%dir %{destdir}/rsync_download_switch/
%config %{destdir}/rsync_download_switch/config.xml
%dir %{destdir}/submit-request-sync/
%config %{destdir}/submit-request-sync/config.xml
%dir %{destdir}/update-git-ref-mapping/
%config %{destdir}/update-git-ref-mapping/config.xml
%dir %{destdir}/validate-scm-meta-resources/
%config %{destdir}/validate-scm-meta-resources/config.xml
%dir %{destdir}/pre-release-base-verification/
%config %{destdir}/pre-release-base-verification/config.xml
%dir %{destdir}/pre-release-base-verification-link-profile/
%config %{destdir}/pre-release-base-verification-link-profile/config.xml
%dir %{destdir}/base_verification_dispatcher/
%config %{destdir}/base_verification_dispatcher/config.xml

%files common
%defattr(-,jenkins,jenkins)
%dir /var/lib/jenkins
%dir %{destdir}
%config(noreplace) %{destdir}/configuration
%dir %{destdir}/submit-obs/
%config %{destdir}/submit-obs/config.xml
%dir %{destdir}/mail_sender/
%config %{destdir}/mail_sender/config.xml
%dir %{destdir}/update-local-git/
%config %{destdir}/update-local-git/config.xml
%dir %{destdir}/create-snapshot
%config %{destdir}/create-snapshot/config.xml
%dir %{destdir}/create-snapshot-latest-link
%config %{destdir}/create-snapshot-latest-link/config.xml

%files tzs
%defattr(-,jenkins,jenkins)
%dir /var/lib/jenkins
%dir %{destdir}
%dir %{destdir}/submit
%config %{destdir}/submit/config.xml

%files tools-testing
%defattr(-,jenkins,jenkins)
%dir /var/lib/jenkins
%dir %{destdir}
%dir %{destdir}/Services-obs-service-gbs/
%config %{destdir}/Services-obs-service-gbs/config.xml
%dir %{destdir}/Services-obs-service-git-buildpackage/
%config %{destdir}/Services-obs-service-git-buildpackage/config.xml
%dir %{destdir}/Services-python-snapdiff/
%config %{destdir}/Services-python-snapdiff/config.xml
%dir %{destdir}/Tools-bmap-tools/
%config %{destdir}/Tools-bmap-tools/config.xml
%dir %{destdir}/Tools-git-buildpackage/
%config %{destdir}/Tools-git-buildpackage/config.xml
%dir %{destdir}/Tools-repa/
%config %{destdir}/Tools-repa/config.xml
%dir %{destdir}/purge-tools-services-tester-projects/
%config %{destdir}/purge-tools-services-tester-projects/config.xml

%files abs
%defattr(-,jenkins,jenkins)
%dir /var/lib/jenkins
%dir %{destdir}/abs-build/
%config %{destdir}/abs-build/config.xml
%dir %{destdir}/abs-build-check/
%config %{destdir}/abs-build-check/config.xml
%dir %{destdir}/abs-update-request/
%config %{destdir}/abs-update-request/config.xml

%files gbs
%defattr(-,jenkins,jenkins)
%dir /var/lib/jenkins
%dir %{destdir}/gbs_build_dispatcher/
%config %{destdir}/gbs_build_dispatcher/config.xml
%dir %{destdir}/gbs-dashboard-build/
%config %{destdir}/gbs-dashboard-build/config.xml
%dir %{destdir}/gbsdbbuild-create-snapshot/
%config %{destdir}/gbsdbbuild-create-snapshot/config.xml
%dir %{destdir}/gbsdbbuild-one-repoarch-build/
%config %{destdir}/gbsdbbuild-one-repoarch-build/config.xml
%dir %{destdir}/gbsdbbuild-update-meta/
%config %{destdir}/gbsdbbuild-update-meta/config.xml
%dir %{destdir}/gbsfullbuild-buildlogs/
%config %{destdir}/gbsfullbuild-buildlogs/config.xml
%dir %{destdir}/gbsfullbuild-create-snapshot/
%config %{destdir}/gbsfullbuild-create-snapshot/config.xml
%dir %{destdir}/gbsfullbuild-image-creator/
%config %{destdir}/gbsfullbuild-image-creator/config.xml
%dir %{destdir}/gbs-ref-fullbuild/
%config %{destdir}/gbs-ref-fullbuild/config.xml
%dir %{destdir}/generate_gbs_full_build_script/
%config %{destdir}/generate_gbs_full_build_script/config.xml
%dir %{destdir}/update-gbs-meta/
%config %{destdir}/update-gbs-meta/config.xml
%dir %{destdir}/BUILD-MONITOR-GBS/
%config %{destdir}/BUILD-MONITOR-GBS/config.xml

%files pmb
%defattr(-,jenkins,jenkins)
%dir /var/lib/jenkins
%dir %{destdir}/Tool_Prereview_Test_Sender/
%config %{destdir}/Tool_Prereview_Test_Sender/config.xml
%dir %{destdir}/Tool_Prereview_Test_Receiver/
%config %{destdir}/Tool_Prereview_Test_Receiver/config.xml
%dir %{destdir}/Tool_history_update/
%config %{destdir}/Tool_history_update/config.xml


%changelog

