#!/usr/bin/env python

#
# Copyright (C) 2017 Samsung Electronics. Co,. Ltd.
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; version 2
#    of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

import sys
import os
import json
import pprint

sys.path.insert(1, os.path.join(sys.path[0], '..'))

from common.buildmonitor_db import do_query, get_value_from_query_data, do_many_query, connect_db, disconnect_db, get_multi_values_from_query_data
from common.buildmonitor_extention import BuildMonitorExtention

def dtr_target_lookup_insert_fun(TOTAL_INFO, arg_name):
    connect_db()

    # Insert values
    query = "INSERT INTO dtr_target_lookup (test_info, tizen_version, tizen_environ, tizen_target, test_date, tizen_release_version) \
                   VALUES(%s, %s, %s, %s, %s, %s)"

    query_var_list = []
    for target_lookup_DB_values in TOTAL_INFO['target_lookup_data']['lookup_DB_values']:
        query_var_list.append( target_lookup_DB_values )

    pprint.pprint(query_var_list)
    do_many_query(query, query_var_list)
    pprint.pprint(do_many_query)

    total_results = {}
    total_results[arg_name] = []

    # Load latest value
    query = "SELECT id, test_info FROM dtr_target_lookup ORDER BY id DESC LIMIT %s"
    query_data = (len(TOTAL_INFO['smoke_menu_data']['var_list']), )


    rows = get_multi_values_from_query_data(query, query_data)
    for value in rows:
        total_results[arg_name].append(list(value))

    total_results[arg_name].reverse()

    disconnect_db()

    return total_results


def dtr_smoke_comment_insert_fun(TOTAL_INFO, arg_name):
    connect_db()

    # Insert values
    query = "INSERT INTO dtr_smoke_comment_result (test_case, comments) VALUES(%s, %s)"

    query_var_list = []
    for sample_DB_values in TOTAL_INFO['smoke_comment_data']['smoke_comment_DB_values']:
        query_var_list.append( sample_DB_values )

    pprint.pprint(query_var_list)
    do_many_query(query, query_var_list)
    pprint.pprint(do_many_query)

    # Load values
    total_results = {}
    total_results[arg_name] = []

    query = "SELECT id, test_case FROM dtr_smoke_comment_result ORDER BY id DESC LIMIT %s"
    query_data = (len(TOTAL_INFO['smoke_value_data']['test_case']), )

    rows = get_multi_values_from_query_data(query, query_data)
    for value in rows:
        total_results[arg_name].append(list(value))

    total_results[arg_name].reverse()

    disconnect_db()

    return total_results


def dtr_smoke_result_insert_fun(TOTAL_INFO, LOOKUP_INFO, SMOKE_CASE_INFO, arg_name):
    connect_db()

    total_results = {}
    total_results['var_list'] = []
    total_results['test_case'] = []
    total_results['smoke_result_list'] = []
    total_results[arg_name] = []

    for menus in TOTAL_INFO['smoke_menu_data']['var_list']:
        total_results['var_list'].append(menus)


    for test_case in TOTAL_INFO['smoke_result_data']['test_cases']:
        total_results['test_case'].append(test_case)

    case_list = []
    for test_case in TOTAL_INFO['smoke_result_data']['test_cases']:
        case_list.append(test_case)

    result_list = []
    for case in case_list:
        total_results['smoke_result_list'].append(TOTAL_INFO['smoke_result_data'][case])

    for case_idx, test_case_value in enumerate(total_results['test_case']): #22
        tmp_value = total_results['smoke_result_list'][case_idx]
        for value_idx, result_value in enumerate(tmp_value): #15
            total_results[arg_name].append((result_value, test_case_value, int(SMOKE_CASE_INFO['DB_smoke_comment_table'][case_idx][0]), int(LOOKUP_INFO['DB_lookup_table'][value_idx][0])))


#    pprint.pprint(total_results[arg_name])

    query = "INSERT INTO dtr_smoke_envorin_result (result, test_case, smoke_comment_id , target_lookup_id) VALUES(%s, %s, %s, %s)"
    query_var_list = []


    for sample_DB_values in total_results[arg_name]:
        query_var_list.append( sample_DB_values )

    pprint.pprint(query_var_list)
    do_many_query(query, query_var_list)
    pprint.pprint(do_many_query)

    disconnect_db()

def dtr_tbt_insert_fun(TOTAL_INFO):
    connect_db()

    query = "INSERT INTO dtr_tbt_result (test_date, tizen_version, environment, target_name, tbt_test_date, packages, grand_total, pass, fail, fns, nt, comment) \
                    VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)"

    query_var_list = []
    for tbt_DB_values in TOTAL_INFO['tbt_result_data']['tbt_DB_values']:
        query_var_list.append( tbt_DB_values )

    pprint.pprint(query_var_list)
    do_many_query(query, query_var_list)
    pprint.pprint(do_many_query)

    disconnect_db()


def dtr_sample_insert_fun(TOTAL_INFO):
    connect_db()

    query = "INSERT INTO dtr_sample_app_result (test_date, num, profile, target_name, tizen_version, \
                    sample_app_test_date, app_type, app_category, apps, apps_result, emul_install, emul_run, device_install, device_run, comment) \
                    VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)"

    query_var_list = []
    for sample_DB_values in TOTAL_INFO['sample_result_data']['sample_DB_values']:
        query_var_list.append( sample_DB_values )

    pprint.pprint(query_var_list)
    do_many_query(query, query_var_list)

    disconnect_db()


def dtr_unresovled_insert_fun(TOTAL_INFO):
    connect_db()

    query = "INSERT INTO dtr_unresolved_jira (test_date, issue_date, jira_key, issue_title) \
                    VALUES(%s, %s, %s, %s)"

    query_var_list = []
    for sample_DB_values in TOTAL_INFO['unresolved_result_data']['unresolved_DB_values']:
        query_var_list.append( sample_DB_values )

    pprint.pprint(query_var_list)
    do_many_query(query, query_var_list)
    pprint.pprint(do_many_query)

    disconnect_db()


def main(TOTAL_INFO):

    target_lookup_dict  = {}
    smoke_comment_dict  = {}

    ## 1. Lookup table data
    target_lookup_dict = dtr_target_lookup_insert_fun(TOTAL_INFO, "DB_lookup_table")

    ## 2. Smoke test suite & comment data
    smoke_comment_dict = dtr_smoke_comment_insert_fun(TOTAL_INFO, "DB_smoke_comment_table")
    dtr_smoke_result_insert_fun(TOTAL_INFO, target_lookup_dict, smoke_comment_dict, "DB_smoke_result")

    ## 3. TBT table
    dtr_tbt_insert_fun(TOTAL_INFO)

    ## 4. Sample table
    dtr_sample_insert_fun(TOTAL_INFO)

    ## 5. unresovled table
    dtr_unresovled_insert_fun(TOTAL_INFO)

    return 0
