#!/usr/bin/python
#-*-coding:utf-8-*-

import os
import sys
import shutil
import subprocess
import json
import pprint
import time
import datetime
import base64
import MySQLdb
import MySQLdb.cursors


def unicode_to_str(obj):
    """convert unicode object to str"""

    if isinstance(obj, list):
        return [unicode_to_str(element) for element in obj]
    elif isinstance(obj, dict):
        return {unicode_to_str(key) : unicode_to_str(value) for key, value \
                in obj.iteritems()}
    elif isinstance(obj, unicode):
        return obj.encode('utf-8')
    else:
        return obj



if __name__ == "__main__":


    CONFIG = {
        'file_base'  : 'config.base',
        'BASE'              : {},
        'file_mysql' : 'config.mysql.receiver',
        'MYSQL'             : {} }


    RAW    = {}
    MYSQL  = { 'query'    : {},
               'fetchall' : {} }
    RESULT = {}



    print '=====[ LITMUS File receiving...]=====\n'


    if os.path.isfile( CONFIG['file_base'] ):

        f = open( CONFIG['file_base'], 'r')
        CONFIG['BASE'] = json.loads(f.read())
        f.close()
        print '[CONFIG] base - load config file.\n'

    else:

        CONFIG['BASE']['location'] = 'external'
        print '[CONFIG] base - load default.\n'





    if CONFIG['BASE']['location'] != 'internal':

        # load config data
        CONFIG['MYSQL']['host']     = os.getenv("BUILDMONITOR_IP")
        CONFIG['MYSQL']['user']     = os.getenv("BUILDMONITOR_USER")
        CONFIG['MYSQL']['password'] = os.getenv("BUILDMONITOR_PASS")
        CONFIG['MYSQL']['database'] = os.getenv("BUILDMONITOR_NAME")
        print '[CONFIG] mysql - load getenv.\n'

    else:

        if not os.path.isfile( CONFIG['file_mysql'] ):
            sys.exit("[ERROR] %s was not found!\n" % CONFIG['file_mysql'])

        f = open( CONFIG['file_mysql'], 'r')
        CONFIG['MYSQL'] = json.loads(f.read())
        f.close()
        print '[CONFIG] mysql - load config file.\n'





    # load received data
    if CONFIG['BASE']['location'] != 'internal':

        trbs_data = os.getenv('file0')

        if trbs_data:
            f = open( 'file0', 'r')
            RAW = unicode_to_str(json.loads(f.read()))
            f.close()
        else:
            sys.exit( "[Error] TRBS_DATA is empty!\n" )

        print '[RAW] load TRBS_DATA.\n'

    else:
        RAW = {}
        RAW['info'] = { 'sr'           : '',
                        'snapshot_num' : 0 }




    # Connect MySQL
    MYSQL['connection'] = MySQLdb.connect( host  =CONFIG['MYSQL']['host'],
                                           user  =CONFIG['MYSQL']['user'],
                                           passwd=CONFIG['MYSQL']['password'],
                                           db    =CONFIG['MYSQL']['database'],
                                           cursorclass=MySQLdb.cursors.DictCursor)
    MYSQL['cursor'] = MYSQL['connection'].cursor()
    print '[INFO] connect MySQL'



    for table, value in RAW.items():

        if type( value ) == list:

            print "\n"
            print "[INFO] " + table + " amount is", len( value )

            for item in value:

                try:

                    for k, v in item.items():
                        if type(v) == str:
                            item[k] = v.replace("'", '"')
                            item[k] = item[k].rstrip('\\')
                            print "[INFO] item[k] : ", item[k]

                    columns_string = "(`" + "`,`".join(item.keys())+"`)"
                    values_string  = "('"  + "','".join(map(str, item.values())) + "')"
                    sql = "INSERT INTO %s %s VALUES %s" % (table, columns_string, values_string)
                    #print "[INFO] sql : ", sql
                    MYSQL['cursor'].execute( sql )
                    MYSQL['connection'].commit()

                    if 'Id' in item.keys():
                        print "[Write] "+table+" id =", item['Id']
                    else:
                        print "[Write] "+table+" id =", item['id']

                except MySQLdb.IntegrityError:
                    #if 'Id' in item.keys():
                    #   print "[WARNING] Duplicate "+table+" id =", item['Id']
                    #else:
                    #   print "[WARNING] Duplicate "+table+" id =", item['id']
                    print "[ERROR]", sql


    MYSQL['cursor'].close()
    MYSQL['connection'].close()


    exit()
