#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4
#
# Copyright (C) 2010, 2011, 2012, 2013, 2014 Intel, Inc.
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; version 2
#    of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
#
"""
This code is called by jenkins jobs triggered by OBS events.
"""

import os
import sys
import base64

from common.buildtrigger import trigger_info
from common.iris_rest_client import IrisRestClient


def main():
    """Script entry point."""

    print '---[JOB STARTED: %s ]-------------------------'

    content = trigger_info(os.getenv("TRIGGER_INFO"))
    pub_enabled = os.getenv("IRIS_PUB_ENABLED", "0") != "0"
    if pub_enabled:
        rest = IrisRestClient(
            os.getenv("IRIS_SERVER"),
            os.getenv("IRIS_USERNAME"),
            base64.b64decode(os.getenv('IRIS_PASSWORDX', '')))
        rest.publish_event("package_built", {
                 "project": content.get('project'),
                 "repo": content.get('repository'),
                 "name": content.get('package'),
                 "arch": content.get('arch'),
                 "status": content.get('event_type'),
                 "repo_server": os.getenv('OBS_URL_EXTERNAL'),
               })

    return 0

if __name__ == '__main__':
    sys.exit(main())
