#!/usr/bin/env python

import sys
import os
import json
import shutil
import subprocess
import json
import pprint
import time
import datetime
import base64
import MySQLdb
import MySQLdb.cursors
import requests
import re

sys.path.insert(1, os.path.join(sys.path[0], '..'))

from bs4 import BeautifulSoup
from common.buildmonitor_db import do_query, get_value_from_query_data, do_many_query
from common.buildmonitor_extention import BuildMonitorExtention



def unicode_to_str(obj):
    """convert unicode object to str"""

    if isinstance(obj, list):
        return [unicode_to_str(element) for element in obj]
    elif isinstance(obj, dict):
        return {unicode_to_str(key) : unicode_to_str(value) for key, value in obj.iteritems()}
    elif isinstance(obj, unicode):
        return obj.encode('utf-8')
    else:
        return obj


class TOOLS_HISTORY_DB(BuildMonitorExtention):

    def __init__(self):
        BuildMonitorExtention.__init__(self)

    def update_tools_release_history(self, option):
        """write DB // tools_release_history table"""

        print option

        project = option[1]
        release_id = option[2]

        table = "tools_release_version"

        ## get release_date
        url = "http://download.tizen.org/tools/archive/"
        release_url = url + release_id
        ##release_date = datetime.datetime.now()
        f = requests.get(url, timeout=30)
        if f.status_code != 200:
            return ("%s url error" % (url))

        soup = BeautifulSoup(f.text, 'html.parser')
        #print soup

        find_version = release_id+"/"

        response = requests.get(url, timeout=30)

        for line in response.iter_lines():

            line = str(line.rstrip())

            regex = re.compile(r'[0-9]{1,2}[-][A-Za-z]{0,3}[-][0-9]{4}.[0-9]{2}[:][0-9]{2}')
            if find_version in line:

                release_date_list = regex.findall(line)

                if len(release_date_list) >0:

                    release_date_temp = release_date_list[0]
                    print "release_date_temp : " , release_date_temp

                    day_temp = release_date_temp.split(" ")[0]
                    time_temp = release_date_temp.split(" ")[1]

                    print day_temp, time_temp
                    day = day_temp.split("-")[0]
                    month = day_temp.split("-")[1]
                    year = day_temp.split("-")[2]

                    hour = time_temp.split(":")[0]
                    min = time_temp.split(":")[1]
                    if int(hour) > 12:
                        hour = str(int(hour) - 12)
                        noon = "PM"
                    else:
                        noon = "AM"

                    a = month + " " + day + " " + year + " " + hour + ":" + min + noon
                    #a = "Jun 1 2005 1:33PM"
                    release_date = datetime.datetime.strptime(a,"%b %d %Y %I:%M%p")
                    print (a, release_date)

                    break
        try:
            query = "SELECT id FROM %s "% (table, ) +"WHERE project = %s AND release_id = %s"
            query_data = (project,release_id)
            commit_id = get_value_from_query_data(query, query_data)
            print "commit_id : ", commit_id

            columns_string = "(`project`,`release_id`,`release_url`, `release_distro`, `release_date`)"
            #print columns_string

            ## get distro list form download URL
            f = requests.get(release_url, timeout=30)
            if f.status_code != 200:
                return ("%s url error" % (release_url))

            soup = BeautifulSoup(f.text, 'html.parser')
            print soup
            distro_list = ["CentOS","Debian","Fedora","Ubuntu","openSUSE"]
            release_distro_temp = []
            current_distro = ""
            release_distro = ""
            for element in soup.findAll('a'):
                distro = str(element.get_text())
                distro_temp = distro.split('_')[0]
                if distro_temp in distro_list:
                    if current_distro != distro_temp:
                        if not current_distro:
                            release_distro += distro
                        else:
                            release_distro += " \n" + distro
                        current_distro = distro_temp
                    else:
                        release_distro += " ," + distro.split('_')[1]
            release_distro += " \n"
            print release_distro


            if commit_id > 0: #update
                query = "UPDATE %s SET release_date = \"%s\" WHERE release_id = " % (table, release_date) + "%s" 
                query_data = (release_id,)
                print "update query_data", query_data
                do_query(query, query_data)

            else: #insert
                query = "INSERT INTO %s %s VALUES " % (table, columns_string) + "(%s, %s, %s, %s, %s)"
                query_data = (project,release_id,release_url,release_distro,release_date)
                print "insert query_data", query_data
                do_query(query, query_data)

        except MySQLdb.IntegrityError as error:
            #print "[ERROR]", sql
            print ("[ERROR] msg {}".format(error))

        return release_date


    def update_each_tool_history(self, option, release_date):
        """write DB // tools_release_history table"""

        print option
        release_version = option[2]

        table = "tool_release_status"

    # tools , release_version, release_note, tool_version;

        tools_list = ["GBS","MIC","REPA","BMAP-TOOLS"]

        url = "http://download.tizen.org/tools/archive/" + release_version + "/"
        f = requests.get(url, timeout=30)
        if f.status_code != 200:
            return ("%s url error" % (url))

        soup = BeautifulSoup(f.text, 'html.parser')

        for tools in tools_list:
            ## get _release_note
            print 'Get Release note : ' , tools

            file_name = "RELEASE_NOTES_" + tools + ".txt"
            release_note = "http://download.tizen.org/tools/archive/" + release_version + "/" + file_name

            result=str(soup.findAll('a', attrs={'href': re.compile(file_name)}))
            print result

            if file_name not in result:
                print 'Can not Find : ' , file_name
                continue
            else:
                response = requests.get(release_note, timeout=30)
                if response.status_code != 200:
                    continue

                ## get tool_version
                print 'Get tool version from release note : ' , tools
                for line in response.iter_lines():
                    line = str(line.rstrip())

                    regex = re.compile(r'[0-9]{1,3}[.][0-9]{0,3}.[0-9]{0,3}')
                    tool_version_list = regex.findall(line)
                    #print line, tool_version
                    if len(tool_version_list) >0 and "Release" in line:
                        print line, tool_version_list[0].replace(" ", "")

                        tool_version = tool_version_list[0].replace(" ", "")
                        break

                try:
                    query = "SELECT id FROM %s "% (table, ) +"WHERE tools = %s AND tool_version = %s"
                    query_data = (tools,tool_version)
                    commit_id = get_value_from_query_data(query, query_data)
                    print "commit_id : ", commit_id

                    columns_string = "(`tools`,`release_version`,`release_note`,`tool_version`,`release_date`)"
                    print columns_string

                    if commit_id > 0: #update 
                        query = "UPDATE %s SET release_version = \"%s\" WHERE tool_version = " % (table, release_version, ) + "%s" 
                        query_data = (tool_version,)
                        print "update query_data", query_data
                        #do_query(query, query_data)

                    else: #insert
                        query = "INSERT INTO %s %s VALUES " % (table, columns_string) + "(%s, %s, %s, %s, %s)"
                        query_data = (tools,release_version,release_note,tool_version, release_date)
                        print "insert query_data", query_data
                        do_query(query, query_data)

                except MySQLdb.IntegrityError as error:
                    #print "[ERROR]", sql
                    print ("[ERROR] msg {}".format(error))


def main(option):
    """The main body"""
    destination = option[3]
    update_latest_release = option[4]

    tools_history_db = TOOLS_HISTORY_DB()

    if "download.tizen.org" in destination and "YES" in update_latest_release:
        # update / insert tools history DB table
        print "update tools release history"
        release_date = tools_history_db.update_tools_release_history(option)
        if type(release_date) == datetime.datetime:
            tools_history_db.update_each_tool_history(option, release_date)
        else:
            print release_date

if __name__ == '__main__':
    sys.exit(main(sys.argv))
