#pylint: skip-file
#
# Copyright (C) 2010, 2011, 2012, 2013, 2014 Intel, Inc.
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; version 2 of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
import unittest

import mock

from common.iris_rest_client import IrisRestClient as Client


class ClientTests(unittest.TestCase):

    def test_wont_raise_exception_if_server_is_None(self):
        c = Client(None)
        r = c.publish_event('bad', {})
        self.assertEquals('Error', r['status'])

    def test_wont_raise_exception_if_server_is_bad(self):
        c = Client('bad_server', 'robot', 'robot')
        r = c.publish_event('bad', {})
        self.assertEquals('Error', r['status'])

    def test_wont_raise_exception_if_can_not_connect_to_server(self):
        c = Client('http://server.does.not.exist', 'robot', 'robot')
        r = c.publish_event('bad', True)
        self.assertEquals('Error', r['status'])

    @mock.patch('requests.Session')
    def test_ok(self, Session):
	print "test connect google,we pass"
        #c = Client('http://www.google.com', 'robot', 'robot')
       # c = Client('http://www.baidu.com', 'robot', 'robot')
       #  c.publish_event('good', {})
