#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4
#
# Copyright (C) 2010, 2011, 2012, 2013, 2014 Intel, Inc.
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; version 2
#    of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
"""This script will pull latest change to local when remote ref updated..
"""

import os
import sys

sys.path.insert(1, os.path.join(sys.path[0], '..'))

from common.gerrit import get_gerrit_event, GerritEnv
from common.git import clone_gitproject

def main():
    """The main body"""

    print '---[JOB STARTED]----------------------------------------'

    events = get_gerrit_event('TRBS_')

    gerrit_env = GerritEnv('TRBS_')

    # clone gerrit project to local git cache dir
    clone_gitproject(events['project'], '%s' % \
            os.path.join(gerrit_env.gitcache, events['project']),
            bare=True, \
            gerrit_hostname=gerrit_env.hostname, \
            gerrit_username=gerrit_env.username, \
            gerrit_sshport=gerrit_env.sshport)

if __name__ == '__main__':
    sys.exit(main())
