#!/usr/bin/env python
# -*- coding: UTF-8 -*-
# vim: sw=4 ts=4 expandtab ai

import os
from setuptools import setup, find_packages

README = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup (
    name = "gerrithooks-plugins",
    version = "0.1.0",
    packages = ['gerrithooks_plugins'],
    package_dir={"gerrithooks_plugins": "plugins"},
    license = "GPLv2",
    description = "Collection of plugins for Gerrit hooks",
    long_description = README,
    # url = "http://",
    author = "Alexander Kanevskiy",
    author_email = "alexander.kanevskiy@intel.com",
    keywords = "gerrit hooks",
    install_requires = ['gerritrest'],
    platforms="Python 2.7",
    entry_points={
        'gerrithooks': [
        'patchset-created = gerrithooks_plugins.add_reviewers:patchset_created',
        ],
    },
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Environment :: Plugins",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved :: GNU General Public License v2 (GPLv2)",
        "Operating System :: POSIX :: Linux",
        "Operating System :: MacOS :: MacOS X",
        "Programming Language :: Python :: 2.7",
        "Topic :: Software Development :: Version Control",
        "Topic :: System :: Systems Administration",
        "Topic :: Utilities",
        ]
    )

