Name:           jenkins-plugins
Version:        1.7
%if 0%{?opensuse_bs}
Release:        0.dev.<CI_CNT>.<B_CNT>
%else
Release:        0
%endif
License:        MIT
Summary:        Jenkins plugins
Url:            https://otctools.jf.intel.com/pm/projects/jenkins
Group:          Development/Tools/Building
BuildArch:      noarch
Source:         %{name}-%{version}.tar.gz

%define destdir /var/lib/jenkins/plugins

%description
Jenkins plugins used in backend services for Tizen

%prep
%setup -q

%build

%install
mkdir -p %{buildroot}%{destdir}
cp plugins/* %{buildroot}%{destdir}/

%pretrans
# Plugin pinning support for version 1.x
pinned_list="credentials junit mailer matrix-project script-security ssh-credentials subversion"
for pl in $pinned_list; do
  if [ -d /var/lib/jenkins/plugins/$pl ]; then
    rm -rf /var/lib/jenkins/plugins/$pl/*
  fi
  if [ -f /var/lib/jenkins/plugins/$pl.jpi ]; then
    mv /var/lib/jenkins/plugins/$pl.jpi /var/lib/jenkins/plugins/$pl.bak
  fi
  if [ ! -f /var/lib/jenkins/plugins/$pl.jpi.pinned ]; then
    touch /var/lib/jenkins/plugins/$pl.jpi.pinned
  fi
done
exit 0

%pre
/usr/bin/getent group jenkins >/dev/null || /usr/sbin/groupadd -r jenkins &>/dev/null || :
/usr/bin/getent passwd jenkins >/dev/null || /usr/sbin/useradd -g jenkins -s /bin/bash -r -c "Jenkins Continuous Build server" \
    -d /var/lib/jenkins jenkins &>/dev/null || :

%post
[ -s /etc/sysconfig/jenkins ] && chown -R jenkins:jenkins %{destdir}
exit 0

%files
%defattr(-,jenkins,jenkins)
%dir /var/lib/jenkins/
%dir %{destdir}
%{destdir}/*.jpi
%{destdir}/*.jpi.pinned
%changelog
