#!/usr/bin/env python
#
# Copyright (C) 2016 Samsung
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; version 2
#    of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
"""Parse different data based on git show command"""

import os

def git_diff_parse(obj_list):
    diff_file = ".diff.tmp"
    os.system('git show > %s' % diff_file)

    with open('%s' % diff_file, 'r') as diff_list:
        before_info = []
        after_info = []

        diff_status = False

        for lines in diff_list:
            line = lines.rstrip().split(' ')

            if line[0] == 'diff':
                if len(before_info):
                    obj_list.append(before_info[:])
                    before_info = []
                if len(after_info):
                    obj_list.append(after_info[:])
                    after_info = []

                before_info.append('-')
                before_info.append("a/".join(line[2].split('a/')[1:len(line[2])]))
                after_info.append('+')
                after_info.append("b/".join(line[3].split('b/')[1:len(line[3])]))

                diff_status = False

            elif line[0] == 'index':
                indexes = line[1].split('..')

                before_info.append(indexes[0])
                after_info.append(indexes[1])

            elif line[0] == '@@':
                if len(after_info) > 3 or len(before_info) > 3:
                    obj_list.append(before_info[:])
                    obj_list.append(after_info[:])

                    before_info = [before_info[0], before_info[1], before_info[2]]
                    after_info = [after_info[0], after_info[1], after_info[2]]

                diff_status = True

                before_info.append("-".join(line[1].split('-')[1:len(line[1])]))
                after_info.append("+".join(line[2].split('+')[1:len(line[2])]))

            else:
                if diff_status:
                    if lines[0] == '-':
                        before_info.append(lines.strip())

                    elif lines[0] == '+':
                        after_info.append(lines.strip())

                    else:
                        before_info.append(lines.strip())
                        after_info.append(lines.strip())

        if len(before_info):
            obj_list.append(before_info[:])

        if len(after_info):
            obj_list.append(after_info[:])

    os.system('rm -f "%s"' % diff_file)
