#!/usr/bin/python -tt
# vim: ai ts=4 sts=4 et sw=4
#
# Copyright (C) 2010, 2011, 2012, 2013, 2014 Intel, Inc.
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; version 2 of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
"""UPload _service file to OBS
"""

import os
from gitbuildsys.errors import ObsError

class UploadError(Exception):
    """Local error handler
    """
    pass

def upload_obs_service(git_url, git_project, git_tag,
        git_revision, obs_project, build, package):
    """UPload _service file to OBS.Create package if doesn't exist.To replace
    make package in local"""
    if not build.exists(obs_project, package):
        try:
            build.create_package(obs_project, package)
        except ObsError, error:
            raise UploadError("Unable to create package %s/%s :%s" % \
                    (obs_project, package, error))
    # Upload _service file to the project for gbs source service
    print 'Upload service file'
    commit_message = 'uploaded by prerelease job to build %s/%s(%s)' % \
            (git_project, git_tag, git_revision)
    content = "<services><service name='gbs'>" \
            "<param name='revision'>%s</param>" \
            "<param name='url'>%s</param>" \
            "<param name='git-meta'>_git-meta</param>" \
            "<param name='error-pkg'>2</param>" \
            "</service></services>" % \
                (git_revision, os.path.join(git_url, git_project))
    fname = '_service'
    with open(fname, 'w') as servicef:
        servicef.write(content)
    try:
        build.commit_files(obs_project, package,
                [(fname, True)], commit_message)
    except ObsError, error:
        raise UploadError("Unable to upload _service to %s: %s" % \
                (obs_project, error))

# for devbase project
def upload_obs_service_gbp(git_url, git_project, git_tag,
        git_revision, obs_project, build, package):
    """UPload _service file to OBS.Create package if doesn't exist.To replace
    make package in local"""
    if not build.exists(obs_project, package):
        try:
            build.create_package(obs_project, package)
        except ObsError, error:
            raise UploadError("Unable to create package %s/%s :%s" % \
                    (obs_project, package, error))
    # Upload _service file to the project for gbs source service
    print 'Upload service file'
    commit_message = 'uploaded by prerelease job to build %s/%s(%s)' % \
            (git_project, git_tag, git_revision)
    content = "<services><service name='git-buildpackage'>" \
            "<param name='revision'>%s</param>" \
            "<param name='url'>%s</param>" \
            "<param name='git-meta'>_git-meta</param>" \
            "</service></services>" % \
                (git_revision, os.path.join(git_url, git_project))
    fname = '_service'
    with open(fname, 'w') as servicef:
        servicef.write(content)
    try:
        build.commit_files(obs_project, package,
                [(fname, True)], commit_message)
    except ObsError, error:
        raise UploadError("Unable to upload _service to %s: %s" % \
                (obs_project, error))

def upload_obs_files(git_project, git_tag, git_revision, \
                     obs_project, build, package, files):
    """UPload _service file to OBS.Create package if doesn't exist.To replace
    make package in local"""
    if not build.exists(obs_project, package):
        try:
            build.create_package(obs_project, package)
        except ObsError, error:
            raise UploadError("Unable to create package %s/%s :%s" % \
                    (obs_project, package, error))
    print 'Commit files'
    commit_message = 'uploaded by prerelease job to build %s/%s(%s)' % \
            (git_project, git_tag, git_revision)
    try:
        if files is not None:
            format_files = []
            for _f in files:
                print '+++ %s' % _f
                format_files.append((_f, True))
            print "Uploading files: %s" % format_files
            print 'obs_project=%s, package=%s' % (obs_project, package)
            build.commit_files(obs_project, package,
                               format_files, commit_message)
    except ObsError, error:
        raise UploadError("Unable to upload files to %s: %s" % \
                (obs_project, error))

