#!/usr/bin/env python
#
# Copyright (C) 2016 Samsung
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; version 2
#    of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
"""This job will clone scm/meta/git project, and update it to gerrit system"""

import sys
import os
from common.gerrit import Gerrit, get_gerrit_event
from common.git import fetch_change
from common.check_scm_meta_git import check_patchset_is_valid
from common.apply_scm_meta_git import apply_to_system

GERRIT_PROJECT = os.getenv('GERRIT_PROJECT')
WORKSPACE = os.getenv('WORKSPACE')
GERRIT_HOSTNAME = os.getenv('GERRIT_HOSTNAME')
GERRIT_USERNAME = os.getenv('GERRIT_USERNAME')
GERRIT_SSHPORT = os.getenv('GERRIT_SSHPORT')
GERRIT_SILENT_MODE = int(os.getenv('GERRIT_SILENT_MODE'))

#meta_file_list = ['domains', 'git-trees', 'branches']
meta_file_list = ['domains', 'git-trees']
readme_file = 'README.txt'
scripts_path  = os.path.dirname(os.path.abspath(__file__)) + '/scripts'

def check_scm_meta_git(gerrit, events):
    ret = check_patchset_is_valid(meta_file_list, readme_file, scripts_path, gerrit.port, gerrit.username, gerrit.host)
    if ret:
        gerrit.review(commit = events['patchset_revision'], message = str(ret), verified = -1)
        return 1
    else:
        gerrit.review(commit = events['patchset_revision'], message = "SCM syntax & semantic check OK.", verified = 1)
        return 0

def update_system(gerrit, events):
    ret = apply_to_system(meta_file_list, readme_file, scripts_path, gerrit.port, gerrit.username, gerrit.host)
    if ret:
        gerrit.review(commit = events['patchset_revision'], message = "There is something wrong. Contact to %s" % events['event_account_email'])
        return 1
    else:
        gerrit.review(commit = events['patchset_revision'], message = "Complete to apply to system.")
        return 0

def main():
    events = get_gerrit_event()
    print(events)

    #fecth and checkout change
    fetch_change(GERRIT_PROJECT, WORKSPACE, events['refspec'])

    gerrit = Gerrit(GERRIT_HOSTNAME, GERRIT_USERNAME, GERRIT_SSHPORT, GERRIT_SILENT_MODE)

    if events['event_type'] == 'patchset-created':
#        return check_scm_meta_git(gerrit, events)
        gerrit.review(commit = events['patchset_revision'], message = "Read Only. Request using Jira System.(SO in bugs.tizen.org)", verified = -1)
    elif events['event_type'] == 'change-merged':
        return update_system(gerrit, events)
    else:
        return 1

if __name__ == '__main__':
    sys.exit(main())
