#!/usr/bin/env python

import sys
import os
import tempfile
import atexit
import shutil
import urllib2
import gzip
import re
from common.git import Git, clone_gitproject
from common.gerrit import Gerrit, get_gerrit_event, GerritError, is_ref_deleted
from common.buildtrigger import trigger_info, trigger_next

# prepare related global variables
workspace = os.getenv('WORKSPACE')
basic_url= os.getenv('URL_PUBLIC_REPO_BASE') + '/snapshots/tizen/'
public_basic_url = 'http://download.tizen.org/snapshots/tizen/'
daily_release_url= os.getenv('URL_PUBLIC_REPO_BASE') + '/releases/daily/tizen/'
public_daily_release_url = 'http://download.tizen.org/releases/daily/tizen/'
gbs_meta_default_profile = os.getenv('GBS_META_DEFAULT_PROFILE')
gbs_meta_support_tizen_ver = os.getenv('GBS_META_SUPPORT_TIZEN_VER')
#GIT_REF_MAPPING_BRANCH = 'sandbox/soong9/unified'
GIT_REF_MAPPING_BRANCH = 'master'

def __get_index_from_path_prj_arch(path_prj_arch):
    """ Get base repo url from obs project & repository"""
    print "-------__get_base_repo_url start-----------------"

    base_repo = {}
    obs_prj=path_prj_arch.split('##')[0]
    path_arch=path_prj_arch.split('##')[1]
    path_prj=obs_prj.replace('Tizen:','').replace(':','-').lower()

    if obs_prj.find(':ref:') != -1:
        ref_build_id=obs_prj.split(':ref:')[1]
        obs_prj=obs_prj.split(':ref:')[0]
        snapshot_id=obs_prj.replace('Tizen:','').replace(':','-').lower()
        temp_id = '/'+snapshot_id+'/tizen-'+snapshot_id+'_'+ref_build_id+'/repos/'+path_arch
    else:
        snapshot_id=path_prj
        temp_id = '/'+snapshot_id+'/latest/repos/'+path_arch

    url_candidates = []
    url_candidates.append(basic_url+temp_id)
    url_candidates.append(daily_release_url+temp_id)
    url_candidates.append(public_basic_url+temp_id)
    url_candidates.append(public_daily_release_url+temp_id)
    for url in url_candidates:
        try:
            urllib2.urlopen(url)
        except:
            continue
        else:
            base_url = url
            break

    print 'obs_prj: %s, snapshot_id: %s' %(obs_prj,snapshot_id)
    print 'path_prj: %s, path_arch: %s, base_url: %s' %(path_prj,path_arch,base_url)

    base_repo['repo_name']='repo.'+path_prj+'_'+path_arch
    base_repo['debug_repo_name']='repo.'+path_prj+'_'+path_arch+'_debug'
    base_repo['repo_url']=base_url+'/packages/'
    base_repo['debug_repo_url']=base_url+'/debug/'

    print 'base_repo: %s' %base_repo
    return base_repo


def _update_ref_bin_index(ref_binary):
    """ Update Reference Binary Index"""
    print "-----------------------------------------------------"
    print "Update Reference Binary Index"
    print "-----------------------------------------------------"

    ref_list = []

    # prepare separate temp directory for each build
    git_prj = 'scm/meta/obs'
    git_branch="master"
    tmpdir = tempfile.mkdtemp(prefix=workspace+'/')
    atexit.register(shutil.rmtree, tmpdir)
    prjdir = os.path.join(tmpdir, git_prj)

    # clone gerrit project to local dir
    if not clone_gitproject(git_prj, prjdir):
        print >> sys.stderr, 'Error cloning %s' %git_prj
        return 1
    mygit = Git(prjdir)
    mygit.checkout(git_branch)

    for obs_prj in ref_binary.keys():
        print '\nobs_prj: %s' %obs_prj

        if len(re.findall('\D', obs_prj.split(':')[1].replace('.',''))) != 0:
            t_ver = ''
            t_ver_path = '/'
            profile_array = obs_prj.split(':')[1:]
        else:
            t_ver = obs_prj.split(':')[1] + '-'
            t_ver_path = '/' + obs_prj.split(':')[1] + '/'
            profile_array = obs_prj.split(':')[2:]
        #find profile name
        i=0
        profile = ''
        while i < len(profile_array):
            profile += profile_array[i].lower() + '-'
            i += 1
        profile = profile.rstrip('-')

        print 'psk-test'
        print obs_prj
        print ref_binary
        ref_snapshot_number = ref_binary[obs_prj].split('ref:')[1]
        if ref_snapshot_number == 'latest':
            ref_snapshot_url = basic_url + t_ver + profile + "/" + ref_snapshot_number + "/"
        else:
            ref_snapshot_url = basic_url + t_ver + profile + "/" + "tizen-" + t_ver + profile + "_" + ref_snapshot_number + "/"
            try:
                urllib2.urlopen(ref_snapshot_url)
            except:
                ref_snapshot_url = daily_release_url + t_ver + profile + "/" + "tizen-" + t_ver + profile + "_" + ref_snapshot_number + "/"
        
        repository = []
        path_prj_list= {}
        obs_meta_file = prjdir + '/' + obs_prj + '/_meta'
        lines = open(obs_meta_file).readlines()
        for line in lines:
            if line.find('repository name=') != -1:
                repo_tmp=line.split('"')[1]
                repository.append(repo_tmp)
                path_prj_list[repo_tmp] = []
            if line.find('path project=') != -1:
                path_prj_arch = line.split('"')[1]+'##'+line.split('"')[3]
                path_prj_list[repo_tmp].append(path_prj_arch)
                
        ref_list.append({'profile':profile})
        ref_list[-1]['t_ver']=t_ver
        ref_list[-1]['t_ver_path']=t_ver_path
        ref_list[-1]['ref_snapshot_number'] = ref_snapshot_number
        ref_list[-1]['ref_snapshot_url'] = ref_snapshot_url
        ref_list[-1]['repository'] = repository
        ref_list[-1]['path_prj_list'] = path_prj_list

    print 'reference list %s' %ref_list
    return ref_list


def _update_base_prj_index():
    """ Update Tizen Base Project Index"""
    print "-----------------------------------------------------"
    print "Update Tizen Base Project Index"
    print "-----------------------------------------------------"

    base_prj_list = []

    # prepare separate temp directory for each build
    git_prj = 'scm/meta/obs'
    git_branch="master"
    tmpdir = tempfile.mkdtemp(prefix=workspace+'/')
    atexit.register(shutil.rmtree, tmpdir)
    prjdir = os.path.join(tmpdir, git_prj)

    # clone gerrit project to local dir
    if not clone_gitproject(git_prj, prjdir):
        print >> sys.stderr, 'Error cloning %s' %git_prj
        return 1
    mygit = Git(prjdir)
    mygit.checkout(git_branch)

    latest_t_ver = gbs_meta_support_tizen_ver.split(' ')[0]
    for ver in gbs_meta_support_tizen_ver.split(' '):
        if ver > latest_t_ver:
            latest_t_ver = ver

    for base_ver in gbs_meta_support_tizen_ver.split(' '):
        if base_ver == latest_t_ver:
            obs_prj = 'Tizen:Base'
            t_ver = ''
            git_branch = 'tizen'
        else:
            obs_prj = 'Tizen:'+base_ver+':Base'
            t_ver = base_ver+'-'
            git_branch = 'tizen_'+base_ver


        repository = []
        obs_meta_file = prjdir + '/' + obs_prj + '/_meta'
        lines = open(obs_meta_file).readlines()
        for line in lines:
            if line.find('repository name=') != -1:
                repo_tmp=line.split('"')[1]
                repository.append(repo_tmp)

        base_prj_list.append({'base_ver':base_ver})
        base_prj_list[-1]['t_ver']=t_ver
        base_prj_list[-1]['repository'] = repository
        base_prj_list[-1]['git_branch'] = git_branch

    print 'base_prj_list = %s' %base_prj_list
    return base_prj_list


def _update_build_conf(ref_list,commit_msg,is_staging):
    """ Update scm/meta/build-config after ref.binary update"""
    print "-----------------------------------------------------"
    print "Update scm/meta/build-config after ref.binary update"
    print "-----------------------------------------------------"

    # prepare separate temp directory for each build
    git_prj = 'scm/meta/build-config'
    git_branch="tizen"+is_staging

    tmpdir = tempfile.mkdtemp(prefix=workspace+'/')
    atexit.register(shutil.rmtree, tmpdir)
    prjdir = os.path.join(tmpdir, git_prj)

    # clone gerrit project to local dir
    if not clone_gitproject(git_prj, prjdir):
        print >> sys.stderr, 'Error cloning %s' %git_prj
        return 1
    mygit = Git(prjdir)
    mygit.checkout(git_branch)

    # Update build.conf file 
    for ref_profile in ref_list:
        if not os.path.exists(prjdir + ref_profile['t_ver_path'] + ref_profile['profile']):
            print 'No dir exists for %s. Create it' %(ref_profile['t_ver_path'] + ref_profile['profile'])
            os.makedirs(prjdir + ref_profile['t_ver_path'] + ref_profile['profile'])

        for repository in ref_profile['repository']:
            repo_build_conf_file = prjdir + ref_profile['t_ver_path'] + ref_profile['profile'] + '/' + repository + '_build.conf'
            repodata_url = ref_profile['ref_snapshot_url'] + "repos/" + repository + "/packages/repodata/"
            print 'profile: %s, repository:%s' %(ref_profile['profile'], repository)
            print 'repodata_url : %s' %repodata_url
            # fine url of build.conf.gz file
            res = urllib2.urlopen(repodata_url)
            for line in res.read().split('a href="'):
                if line.find('build.conf.gz') != -1:
                    build_conf_file=line.split('"')[0]
            build_conf_url = repodata_url + build_conf_file
            print 'build_conf_url: %s' %build_conf_url
            # download xxxx.build.conf.gz file -> decompress -> save it to repo_build.conf inside scm/meta/build-config git
            tmp_build_conf_file = tmpdir + '/tmp_build.conf.gz'
            f = open(tmp_build_conf_file,'wb')
            res2 = urllib2.urlopen(build_conf_url)
            f.write(res2.read())
            f.close()
            with gzip.GzipFile(tmp_build_conf_file, 'rb') as inF:
                with file(repo_build_conf_file, 'wb') as outF:
                    s = inF.read()
                    outF.write(s.encode('utf-8'))

    if mygit.is_clean()[0] == 0:
        print '%s, branch %s has some changes' %(git_prj,git_branch)
        mygit.add_files(prjdir)
        mygit.commit_all(commit_msg)
        mygit.push(repo = 'origin', src = git_branch)
    else:
        print '%s, branch %s has nothing to commit' %(git_prj,git_branch)


def _update_gbs_conf(ref_list,commit_msg,is_staging,is_fullbuild):
    """ Update scm/meta/gbs-config after ref.binary update"""
    print "-----------------------------------------------------"
    print "Update scm/meta/gbs-config after ref.binary update"
    print "-----------------------------------------------------"

    # prepare separate temp directory for each build
    git_prj = 'scm/meta/gbs-config'
    if is_staging == '_staging' and is_fullbuild == 'false':
        git_branch="tizen_ref"
    else:
        git_branch="tizen"+is_staging

    tmpdir = tempfile.mkdtemp(prefix=workspace+'/')
    atexit.register(shutil.rmtree, tmpdir)
    prjdir = os.path.join(tmpdir, git_prj)

    # clone gerrit project to local dir
    if not clone_gitproject(git_prj, prjdir):
        print >> sys.stderr, 'Error cloning %s' %git_prj
        return 1
    mygit = Git(prjdir)
    mygit.checkout(git_branch)

    # clone gerrit project to local dir
    if not clone_gitproject(git_prj, prjdir):
        print >> sys.stderr, 'Error cloning %s' %git_prj
        return 1
    mygit = Git(prjdir)
    mygit.checkout(git_branch)

    gbs_conf_file = prjdir+'/gbs.conf'
    default_profile = ref_list[0]['profile']
    default_repo = ref_list[0]['repository'][0]
    default_t_ver = ref_list[0]['t_ver']

    #[general] section
    gbs_conf_text = '[general]\nfallback_to_native = true\nprofile = profile.'+default_t_ver+default_profile+'_'+default_repo+'\n\n\n'

    #Profile section
    gbs_conf_text += '#########################################################\n################## Profile Section ##################\n#########################################################\n\n'

    path_prj_arch_overall_list = []
    for ref_profile in ref_list:
        profile = ref_profile['profile']
        t_ver = ref_profile['t_ver']
        t_ver_path = ref_profile['t_ver_path']
        gbs_conf_text = gbs_conf_text + '############# '+ t_ver+profile+' #############\n'
        for repository in ref_profile['repository']:
            gbs_conf_text += '[profile.'+t_ver+profile+'_'+repository+']\n'
            if is_fullbuild == 'true':
                gbs_conf_text += 'buildconf=./scm/meta/build-config'\
                                  +t_ver_path+profile+'/'+repository+'_build.conf\n'
            gbs_conf_text += 'repos = '
            for path_prj_arch in ref_profile['path_prj_list'][repository]:
                path_prj_arch_overall_list.append(path_prj_arch)
                base_repo = __get_index_from_path_prj_arch(path_prj_arch)
                gbs_conf_text += base_repo['repo_name']+','+base_repo['debug_repo_name']+','
                if is_fullbuild == 'false':
                    gbs_conf_text += 'repo.'+t_ver+profile+'_'+repository+','
                    gbs_conf_text += 'repo.'+t_ver+profile+'_'+repository+'_debug,'
            gbs_conf_text = gbs_conf_text[:-1]

            gbs_conf_text += '\n\n'

    #repo section
    gbs_conf_text += '\n\n\n#########################################################\n################## Repo Section##################\n#########################################################\n'

    path_prj_arch_overall_list = list(set(path_prj_arch_overall_list))
    #base repo
    gbs_conf_text += '\n############# base #############\n'

    for path_prj_arch in path_prj_arch_overall_list:
        base_repo = __get_index_from_path_prj_arch(path_prj_arch)
        gbs_conf_text += '['+base_repo['repo_name']+']\n'
        gbs_conf_text += 'url = '+base_repo['repo_url']+'\n'
        gbs_conf_text += '['+base_repo['debug_repo_name']+']\n'
        gbs_conf_text += 'url = '+base_repo['debug_repo_url']+'\n\n'

    #profile repo
    for ref_profile in ref_list:
        profile = ref_profile['profile']
        t_ver = ref_profile['t_ver']
        ref_snapshot_url = ref_profile['ref_snapshot_url']

        gbs_conf_text += '\n############# '+ t_ver+profile+' #############\n'
        for repository in ref_profile['repository']:
            gbs_conf_text += '[repo.'+t_ver+profile+'_'+repository+']\n'
            gbs_conf_text += 'url = '+ref_snapshot_url+'repos/'+repository+'/packages/\n'
            gbs_conf_text += '[repo.'+t_ver+profile+'_'+repository+'_debug]\n'
            gbs_conf_text += 'url = '+ref_snapshot_url+'repos/'+repository+'/debug/\n\n'
    
    #write gbs_conf_text to default gbs_conf_file, which is scm/meta/gbs-config/gbs.conf
    print '==================================================\n=========== default gbs.conf file==========\n==================================================\n'
    print gbs_conf_text
    with open(gbs_conf_file,"wb") as f:
        f.write(gbs_conf_text)

    #Copy default gbs.conf file to each version/profile/repository_gbs.conf file and replace default profile
    for ref_profile in ref_list:
        profile = ref_profile['profile']
        t_ver = ref_profile['t_ver']
        t_ver_path = ref_profile['t_ver_path']

        if not os.path.exists(prjdir + t_ver_path + profile):
            print 'No dir exists for %s. Create it' %(t_ver_path + profile)
            os.makedirs(prjdir + t_ver_path + profile)

        for repository in ref_profile['repository']:
            file_path_name = prjdir + t_ver_path + profile + '/' + repository + '_gbs.conf'
            print 'filename and path: %s' %file_path_name
            shutil.copy(gbs_conf_file,file_path_name)
            old_profile='profile = profile.'+default_t_ver+default_profile+'_'+default_repo
            new_profile='profile = profile.'+t_ver+profile+'_'+repository
            print 'new_profile: %s' %new_profile
            with open(file_path_name,"rb") as f:
                newText = f.read().replace(old_profile,new_profile)
            with open(file_path_name,"wb") as f:
                f.write(newText)

    #git push if there are any changes
    if mygit.is_clean()[0] == 0:
        print '%s, branch %s has some changes' %(git_prj,git_branch)
        mygit.add_files(prjdir)
        mygit.commit_all(commit_msg)
        mygit.push(repo = 'origin', src = git_branch)
    else:
        print '%s, branch %s has nothing to commit' %(git_prj,git_branch)


def _update_scm_manifest(ref_list,base_prj_list,commit_msg,is_staging):
    """ Update scm/manifest after ref.binary update"""
    print "-----------------------------------------------------"
    print "\n\n\nUpdate scm/manifest after ref.binary update"
    print "-----------------------------------------------------"

    # prepare separate temp directory for each build
    git_prj = 'scm/manifest'

    for base_prj in base_prj_list:
        tmpdir = tempfile.mkdtemp(prefix=workspace+'/')
        atexit.register(shutil.rmtree, tmpdir)
        prjdir = os.path.join(tmpdir, git_prj)

        # clone gerrit project to local dir
        if not clone_gitproject(git_prj, prjdir):
            print >> sys.stderr, 'Error cloning %s' %git_prj
            return 1
        mygit = Git(prjdir)

        git_branch = base_prj['git_branch']+is_staging

        print 'git_prj: %s git_branch: %s' %(git_prj, git_branch)
        mygit.checkout(git_branch)

        #_remote.xml
        remote_file = prjdir + '/_remote.xml'
        gerrit_hostname = os.getenv('GERRIT_HOSTNAME_EXTERNAL')
        remote_text = '<?xml version="1.0" encoding="UTF-8"?>\n<manifest>\n  <remote name="tizen-gerrit"\n          fetch="ssh://'+gerrit_hostname+'/"\n          review="https://'+gerrit_hostname+'/gerrit"/>\n</manifest>'
        with open(remote_file,'wb') as f:
            f.write(remote_text)

        for ref_profile in ref_list:
            if ref_profile['t_ver'] == base_prj['t_ver']:
                profile = ref_profile['profile']
                t_ver = ref_profile['t_ver']
                t_ver_path = ref_profile['t_ver_path']
                ref_snapshot_number = ref_profile['ref_snapshot_number']
                ref_snapshot_url = ref_profile['ref_snapshot_url'] 

                profile_path = os.path.join(prjdir,profile)
                for repository in ref_profile['repository']:
                    if not os.path.exists(prjdir+'/'+profile+'/'+repository):
                        print 'No dir exists for %s. Create it' %(profile+'/'+repository)
                        os.makedirs(prjdir+'/'+profile+'/'+repository)

                    #projects.xml
                    projects_file = profile_path + '/' + repository + '/projects.xml'

                    manifest_url = ref_snapshot_url + '/builddata/manifest/'
                    res = urllib2.urlopen(manifest_url)
                    for index in res.read().split('a href="'):
                        if index.find(repository+'.xml') != -1:
                            manifest_file=index.split('">')[0]
                    manifest_file_url = manifest_url + manifest_file
                    print 'projects_file: %s' %projects_file
                    print 'manifest_file_url: %s' %manifest_file_url

                    with open(projects_file,'wb') as f:
                        res2 = urllib2.urlopen(manifest_file_url)
                        f.write(res2.read())

                    #metadata.xml
                    revision_branch='tizen'+is_staging
                    metadata_file = profile_path + '/' + repository + '/metadata.xml'
                    metadata_text = '<?xml version="1.0" encoding="UTF-8"?>\n<manifest>\n  <project name="scm/meta/build-config" path="scm/meta/build-config" groups="meta" revision="'+revision_branch+'"/>\n  <project name="scm/meta/gbs-config" path="scm/meta/gbs-config" groups="meta" revision="'+revision_branch+'">\n     <copyfile src="'
                    metadata_text += t_ver.replace('-','/')+profile+'/'+repository+'_gbs.conf" dest=".gbs.conf" />\n  </project>\n</manifest>'
                    print 'repository: %s' %repository
                    print 'metadata_text: \n%s' %metadata_text
                    with open(metadata_file,'wb') as f:
                        f.write(metadata_text)

                    #profile_repository.xml
                    manifest_xml_file = prjdir+'/'+profile+'_'+repository+'.xml'
                    manifest_text = '<?xml version="1.0" encoding="UTF-8"?>\n<manifest>\n  <include name="_remote.xml" />\n  <default revision="accepted/tizen_'
                    manifest_text += t_ver.replace('-','_')+profile
                    manifest_text += '"\n           remote="tizen-gerrit"\n           sync-j="4" />\n  <include name="'
                    manifest_text += profile+'/'+repository+'/metadata.xml" />\n  <include name="'
                    manifest_text += profile+'/'+repository+'/projects.xml" />\n</manifest>\n'
                    print 'repository: %s' %repository
                    print 'manifest_text: \n%s' %manifest_text

                    with open(manifest_xml_file,'wb') as f:
                        f.write(manifest_text)

        if mygit.is_clean()[0] == 0:
            print '%s, branch %s has some changes' %(git_prj,git_branch)
            mygit.add_files(prjdir)
            mygit.commit_all(commit_msg)
            mygit.push(repo = 'origin', src = git_branch)
        else:
            print '%s, branch %s has nothing to commit' %(git_prj,git_branch)


def prepare_ref_binary(git_ref_mapping_info):
    """ prepare_ref_binary_by_git"""
    print "----------prepare_ref_binary_by_git start--------"

    git_prj = git_ref_mapping_info['git_prj']
    git_branch = git_ref_mapping_info['git_branch']
    filename = 'git-ref-mapping.xml'
    tmpdir = tempfile.mkdtemp(prefix=workspace+'/')
    atexit.register(shutil.rmtree, tmpdir)
    prjdir = os.path.join(tmpdir, git_prj)

    # clone gerrit project to local dir
    if not clone_gitproject(git_prj, prjdir):
        print >> sys.stderr, 'Error cloning %s' %git_prj
        return 1
    mygit = Git(prjdir)
    mygit.checkout(git_branch)
    commit_msg=mygit.show(git_ref_mapping_info['newrev']).split('\n')[4].replace(" ","")
    commit_log=mygit.show(git_ref_mapping_info['newrev'])

    ref_binary = {}
    base_prj_list = {}
    build_profile_list = []
    build_profile_snapshot_id_list = []

    lines = open(prjdir+'/'+filename).readlines()
    for line in lines:
        if line.find('branch OBS_project') != -1:
            ref_binary[line.split('"')[1]] = line.split('"')[3]

    #Add default profile supported by gbs
    if gbs_meta_default_profile:
        for profile in gbs_meta_default_profile.split(' '):
            ref_binary[profile]=profile+':ref:latest'

    for line in commit_log.splitlines():
        if line.find('+') != -1 and line.find('branch OBS_project') != -1:
            obs_prj=line.split('"')[1]
            if obs_prj in build_profile_list:
                continue
            build_profile_list.append(obs_prj)
            snapshot_num=line.split('"')[3].split(':')[-1]
            snapshot_id=obs_prj.replace(':','-').lower()+'_'+snapshot_num
            build_profile_snapshot_id_list.append({'obs_prj':obs_prj,'snapshot_id':snapshot_id})

    print 'gbs fullbuild target profiles are :\n%s' %build_profile_snapshot_id_list

    return (ref_binary,commit_msg,build_profile_snapshot_id_list)


def main():
    """script entry point"""

    print '---[JOB STARTED]----------------------------------------'

    git_ref_mapping_info = {}
    #comment out because this job is triggered by gerrit event
    event = get_gerrit_event()
#    event = trigger_info(os.getenv("TRIGGER_INFO"))

    # prepare separate temp directory for each build

    # In case of this job is triggered by gerrit event, first submit meta files to staging branch
    # Otherwise, submit gbs meta files to original branch
    if 'project' in event and 'event_type' in event:
        print 'update-gbs-meta job is triggered by gerrit event'
        is_staging = '_staging'
        # Disable gbs ref fullbuild. To enable gbs ref fullbuild, remove below one line
        is_staging = ''
        if event['event_type'] != "ref-updated" or event['project'] != "scm/git-ref-mapping":
            # This is just a sanity check as ref-updated is the only event we
            # react on and it's configured in the job configuraion
            print >> sys.stderr, "Configuration error: This job can't process"\
                                 "project %s! Only scm/git-ref-mapping is allowed and " \
                                 "event %s! Only ref-updated events are allowed" \
                                 %(event['event_type'], event['project'])
            return 1
        git_ref_mapping_info['git_prj'] = event['project']
        git_ref_mapping_info['git_branch'] = event['refname']
        git_ref_mapping_info['newrev'] = event['newrev']
    else:
        print 'gbsdbbuild-update-meta job is triggered by other jenkins job\n\
               gbsdbbuild-create-snapshot'
        contents = trigger_info(os.getenv("TRIGGER_INFO"))
        is_staging = ''
        if contents['triggered_from'] != 'gbsdbbuild_create_snapshot':
            print 'Trigger error: gbsdbbuild-update-meta job is not triggered by gbsdbbuild-create-snapshot!!'
            return 1
        git_ref_mapping_info = contents['git_ref_mapping_info']

    (ref_binary,commit_msg,build_profile_snapshot_id_list) = prepare_ref_binary(git_ref_mapping_info)

    print "commit_msg='%s'" %commit_msg
    print 'Each reference snapshot numbers are like below'
    print ref_binary

    ref_list = _update_ref_bin_index(ref_binary)
    base_prj_list = _update_base_prj_index()
    _update_build_conf(ref_list,commit_msg,is_staging)
    _update_gbs_conf(ref_list,commit_msg,is_staging,is_fullbuild='true')
    # Update tizen_ref branch in case of _staging only
    # tizen_ref branch : can be used by Tizen developer
    # who want to do gbs building(not full build) with reference snapshot remote repo
    # scm/git-ref-mapping update -> scm/gbs-config _staging branch & tizen_ref branch update 
    if is_staging == '_staging':
        _update_gbs_conf(ref_list,commit_msg,is_staging,is_fullbuild='false')
    _update_scm_manifest(ref_list,base_prj_list,commit_msg,is_staging)

    if is_staging == '_staging':
        for build_profile_snapshot_id in build_profile_snapshot_id_list:
            trigger_next("gbs_build_dispatcher",\
                     {"menu" : "Ref Fullbuild",
                      "git_ref_mapping_info" : git_ref_mapping_info,
                      'build_profile_snapshot_id': build_profile_snapshot_id})
    
if __name__ == '__main__':
    sys.exit(main())
