#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4
#
# Copyright (C) 2010, 2011, 2012, 2013, 2014 Intel, Inc.
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; version 2
#    of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
"""This script will pull latest change to local when remote ref updated..
"""

import os
import sys

from common.gerrit import get_gerrit_event, GerritEnv
from common.git import clone_gitproject

def main():
    """The main body"""

    print '---[JOB STARTED]----------------------------------------'

    events = get_gerrit_event('PUBLIC_')

    gerrit_env = GerritEnv('PUBLIC_')

    # if project is PUBLIC MAPPING_PRJ, clone full respository, otherwise clone bare
    # ones.
    if events['project'] == os.getenv('MAPPING_PRJ'):
        clone_gitproject(events['project'], \
                os.path.join(gerrit_env.gitcache, events['project']), \
                gerrit_hostname=gerrit_env.hostname, \
                gerrit_username=gerrit_env.username, \
                gerrit_sshport=gerrit_env.sshport)

    if events['project'] == os.getenv('REF_MAPPING_PRJ'):
        clone_gitproject(events['project'], \
                os.path.join(gerrit_env.gitcache, events['project']), \
                gerrit_hostname=gerrit_env.hostname, \
                gerrit_username=gerrit_env.username, \
                gerrit_sshport=gerrit_env.sshport)

    # clone gerrit project to local git cache dir
    clone_gitproject(events['project'], '%s.git' % \
            os.path.join(gerrit_env.gitcache, events['project']),
            bare=True, \
            gerrit_hostname=gerrit_env.hostname, \
            gerrit_username=gerrit_env.username, \
            gerrit_sshport=gerrit_env.sshport)

if __name__ == '__main__':
    sys.exit(main())
