#!/bin/sh -eu
# copy jenkins job logs to long-term storage to survive jenkins logs deletion
#
jhome=/var/lib/jenkins
collectdir=$jhome/logs-collected
min_age='-mtime +1'
max_age_def='-mtime -3'
keep_age='-ctime +365'

# 1st run handles all older than min_age,
# next runs look at files min_age...max_age_def old
max_age=""
[ -d $collectdir ] && max_age=$max_age_def
mkdir -p $collectdir
# list logs older than 24h, to avoid new live files
#logfiles=`find $jhome/jobs -type f $min_age $max_age -name log`
logfiles=`find $jhome/jobs -type f -name log`
for logfile in $logfiles; do
  jobdir=`echo $logfile | sed 's/\/log$//'`
  shortname=`echo $jobdir | sed 's/^\/var\/lib\/jenkins\/jobs\///; s/configurations\/axis-label\///; s/\/builds\//\//; s/\//-/g'`
  # already existing stored log happens often, so check it first
  [ -f $collectdir/$shortname.*log.xz ] && continue
  # job dir gone away (by jenkins) may happen, but not often, so check it next
  [ ! -d $jobdir ] && continue
  jobid=`basename $jobdir`
  xz -v -c $logfile > $collectdir/$shortname.log.xz
done

# delete old compressed files.
# note: timelimit here should be larger than range of collector,
# otherwise collector copies same logfiles again.
find $collectdir -type f -name '*.log.xz' $keep_age -exec rm -f {} \;
