#
# spec file for jenkins-scripts
#

Name:           jenkins-scripts
Version:        1.11
%if 0%{?opensuse_bs}
Release:        1.<CI_CNT>.<B_CNT>
%else
Release:        1
%endif
License:        GPLv2
Summary:        An extendable backend scripts for jenkins
Url:            http://www.tizen.org
Group:          Development/Tools/Building
Source:         %{name}-%{version}.tar.gz
Requires:       %{name}-common = %{version}-%{release}
Requires:       %{name}-submitobs = %{version}-%{release}
Requires:       %{name}-tzs = %{version}-%{release}
Requires:       %{name}-dependsgraph = %{version}-%{release}
Requires:       %{name}-trbs = %{version}-%{release}
Requires:       %{name}-abs = %{version}-%{release}
Requires:       %{name}-groovyinit = %{version}-%{release}
Requires:       %{name}-pmb = %{version}-%{release}
Requires:       %{name}-dtr = %{version}-%{release}
BuildArch:      noarch

%define homedir /var/lib/jenkins
%define destdir %{homedir}/%{name}
%define destinitdir %{homedir}/init.groovy.d

%description
Jenkins build job will call this scripts when build job is triggered by
Gerrit/OBS event.

%package common
Summary:    Common API for all instances
Group:      Development/Tools/Building
Requires:   createrepo_c
Requires:   git-core
Requires:   tizen-gbp-rpm >= 20131017
Requires:   python-beautifulsoup4
Requires:   python-cheetah
Requires:   python-redis
Requires:   python-requests >= 2.0.1
Requires:   python-snapdiff
Requires:   python-yaml
Requires:   python-lxml
Requires:   python-mysql
Requires:   python-jenkinsapi
Requires:   python-urllib3
Requires:   python-xlrd
Requires:   gbs-api
 %if 0%{?suse_version} == 1320
Requires:   python-boto
%else
Requires:   python-boto3
%endif

%description common
Common part of jenkins scripts

%package tzs
Summary:    Scripts for tzs customer appliance
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description tzs
Jenkins scripts for tzs customer appliance instance

%package groovyinit
Summary:    Groovy init scripts for jenkins startup
Group:      Development/Tools/Building

%description groovyinit
Groovy init scripts for jenkins startup

%package dependsgraph
Summary:    Dependency graph generation tool
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description dependsgraph
Dependency graph generation tool

%package trbs
Summary:    Tizen Reference Build System scripts
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description trbs
Tizen Reference Build System scripts

%package abs
Summary:    App Build System scripts
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description abs
App Build System scripts

%package submitobs
Summary:    Temporary package to isolate job_submitobs
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description submitobs
Isolated job_submitobs to avoid package installation conflicts

%package pmb
Summary:    pmb scripts for Tools&Services development and test process
Group:      Development/Tools/Building
Requires:   %{name}-common = %{version}-%{release}

%description pmb
pmb scripts for Tools&Services development and test process

%package dtr
Summary:    dtr scripts for the view & services for Daily Test Result
Group:      Development/Tools/Building

%description dtr
dtr scripts for the view & services for Daily Test Result


%prep
%setup -q

%build

%install
install -d %{buildroot}%{destdir}
cp -r job_*.py job_*.groovy codebase.py dir-purge-tool.sh logs-collector.sh common obs_requests templates scripts vis dep_graph trbs abs pmb dtr %{buildroot}%{destdir}/
install -d %{buildroot}%{destinitdir}
cp -r groovy_init_scripts/{Module*,init.groovy,setup.properties.example} %{buildroot}%{destinitdir}/
install -d %{buildroot}%{homedir}
cp -r groovy_init_scripts/scriptApproval.xml %{buildroot}/%{homedir}/

%post common
if [ ! -d /var/lib/jenkins/userContent ]; then
  mkdir -p /var/lib/jenkins/userContent
fi
ln -sf %{destdir} /var/lib/jenkins/userContent/

%postun common
# remove link only when uninstall the package
if [ ${1:-0} -eq 0 ]; then
  if [ -L /var/lib/jenkins/userContent/jenkins-scripts ]; then
    rm -f /var/lib/jenkins/userContent/jenkins-scripts
  fi
fi

%files
%defattr(-,jenkins,jenkins)
%dir /var/lib/jenkins/
%dir %{destdir}
%{destdir}/job_post_image.py
%{destdir}/job_local_cache_cleanups.py
%{destdir}/job_pre_release_obs.py
%{destdir}/job_publish_test_results.py
%{destdir}/job_request.py
%{destdir}/job_test_build.py
%{destdir}/job_rpm_buildlogs.py
%{destdir}/obs_requests
%{destdir}/common/tempbuildpkg.py
%{destdir}/dir-purge-tool.sh
%{destdir}/logs-collector.sh
%{destdir}/job_monitor_scm_meta_git.py
%{destdir}/job_check_scm_meta_git.py
%{destdir}/job_ref_snapshot_info_update.py
%{destdir}/job_ref_create_prj_obs.py
%{destdir}/job_ref_import_rpm_obs.py
%{destdir}/job_ref_purge_prj_obs.py
%{destdir}/job_ref_precheck_project_obs.py
%{destdir}/job_test_trigger_info_update.py
%{destdir}/job_git_domain.py
%{destdir}/job_update_git_obs_mapping_for_dashboard.py
%{destdir}/job_add_dotnet_launching_performance_test.py
%{destdir}/job_update_git_branch_project_mapping_for_dashboard.py
%{destdir}/job_litmus_jira_issue_receiver.py
%{destdir}/job_litmus_tct_file_receiver.py
%{destdir}/job_update_nuget.py
%{destdir}/job_add_git_tag.py
%{destdir}/job_create_sdkrootstrap.py
%{destdir}/job_find_incorrect_filenames.py
%{destdir}/job_importrpm_obs.py
%{destdir}/job_rsync_download.py
%{destdir}/job_sync_repo.py
%{destdir}/job_trigger_for_sync_repo.py
%{destdir}/job_trigger_obs_sync.py
%{destdir}/job_update_public_git.py
%{destdir}/job_control_ondemand_slaves.groovy
%{destdir}/job_test_trigger_automation.py
%{destdir}/job_update_gbs_meta.py
%{destdir}/job_submit_request_sync.py
%{destdir}/job_submit_request_git_sync.py
%{destdir}/job_gbs_ref_fullbuild.py
%{destdir}/job_repa_auto_reject.py
%{destdir}/job_generate_gbs_full_build_script.py
%{destdir}/job_gbsfullbuild_create_snapshot.py
%{destdir}/job_gbsfullbuild_image_creator.py
%{destdir}/job_gbsfullbuild_buildlogs.py
%{destdir}/job_obs_worker_auto_scailing.py
%{destdir}/job_config_snapshot_repo_conf.py
%{destdir}/job_notify_buildstatus.py
%{destdir}/job_obs_project_manager.py
%{destdir}/job_gbs_dashboard_build.py
%{destdir}/job_gbsdbbuild_create_snapshot.py
%{destdir}/job_gbsdbbuild_one_repoarch_build.py
%{destdir}/job_gbsdbbuild_update_meta.py
%{destdir}/job_git_sync_downstream.py
%{destdir}/job_base_verification.py
%{destdir}/job_base_verification_dispatcher.py
%{destdir}/job_validate_scm_meta_resources.py
%{destdir}/job_check_digest_mismatch_issue.py
%{destdir}/job_fuzz_receiver.py

%files common
%defattr(-,jenkins,jenkins)
%doc doc/RELEASE_NOTES
%dir %{destdir}/common
%{destdir}/common/__init__.py
%{destdir}/common/backenddb.py
%{destdir}/common/builddata.py
%{destdir}/common/buildservice.py
%{destdir}/common/buildtrigger.py
%{destdir}/common/buildtrigger_ahub.py
%{destdir}/common/gerrit.py
%{destdir}/common/git.py
%{destdir}/common/imagedata.py
%{destdir}/common/mapping.py
%{destdir}/common/obspkg.py
%{destdir}/common/prerelease.py
%{destdir}/common/repomaker.py
%{destdir}/common/runner.py
%{destdir}/common/send_mail.py
%{destdir}/common/snapshot.py
%{destdir}/common/utils.py
%{destdir}/common/manifest.py
%{destdir}/common/upload_service.py
%{destdir}/common/iris_rest_client.py
%{destdir}/common/apply_scm_meta_git.py
%{destdir}/common/check_scm_meta_git.py
%{destdir}/common/git_diff_parse.py
%{destdir}/common/buildmonitor_db.py
%{destdir}/common/buildmonitor_extention.py
%{destdir}/common/git_obs_mapping.py
%{destdir}/job_re.py
%{destdir}/job_create_snapshot.py
%{destdir}/job_release_snapshot.py
%{destdir}/job_buildlogs.py
%{destdir}/job_jobs_dispatcher.py
%{destdir}/job_imager.py
%{destdir}/job_mail_sender.py
%{destdir}/job_load_repos.yaml.py
%{destdir}/job_sync_obs.py
%{destdir}/job_sync_snapdiff.py
%{destdir}/job_buildmonitor.py
%{destdir}/job_buildmonitor_gbs.py
%{destdir}/job_repa.py
%{destdir}/codebase.py
%dir %{destdir}/templates
%{destdir}/templates/index.html
%{destdir}/job_update_local_git.py
%dir %{destdir}/scripts
%{destdir}/scripts/check_section.sh
%{destdir}/scripts/get_git_desc_info.sh
%{destdir}/scripts/del-obs-tree-proj.sh
%{destdir}/scripts/nuget.exe
%{destdir}/common/aws_ec2.py
%{destdir}/common/workflow.py
%{destdir}/common/get_name_from_specfile.py
%{destdir}/common/gbsutils.py
%{destdir}/job_gbs_build_dispatcher.py
%{destdir}/job_add_new_node.groovy
%{destdir}/job_purge_tools_services_tester_projects.py
%{destdir}/job_rsync_download_switch.py

%files dependsgraph
%defattr(-,jenkins,jenkins)
%{destdir}/job_make_dep_graph.py
%{destdir}/common/dep_graph.html.template
%{destdir}/common/dep_graph.html.template_simple
%{destdir}/common/dep_parse.py
%dir %{destdir}/dep_graph
%{destdir}/dep_graph/dep_graph.css
%{destdir}/dep_graph/dep_graph.include.html
%{destdir}/dep_graph/dep_graph.js
%{destdir}/dep_graph/dep_graph_common.js
%{destdir}/dep_graph/dep_graph_full.include.html
%{destdir}/dep_graph/dep_graph_simple.js
%{destdir}/dep_graph/dep_graph_full.js
%{destdir}/dep_graph/slider.js
%dir %{destdir}/vis
%{destdir}/vis/CONTRIBUTING.md
%{destdir}/vis/HISTORY.md
%{destdir}/vis/LICENSE-APACHE-2.0
%{destdir}/vis/LICENSE-MIT
%{destdir}/vis/NOTICE
%{destdir}/vis/README.md
%dir %{destdir}/vis/dist
%{destdir}/vis/dist/vis-graph3d.min.js
%{destdir}/vis/dist/vis-network.min.js
%{destdir}/vis/dist/vis-timeline-graph2d.min.js
%{destdir}/vis/dist/vis.css
%{destdir}/vis/dist/vis.js
%{destdir}/vis/dist/vis.map
%{destdir}/vis/dist/vis.min.css
%{destdir}/vis/dist/vis.min.js
%dir %{destdir}/vis/dist/img
%dir %{destdir}/vis/dist/img/network
%{destdir}/vis/dist/img/network/acceptDeleteIcon.png
%{destdir}/vis/dist/img/network/addNodeIcon.png
%{destdir}/vis/dist/img/network/backIcon.png
%{destdir}/vis/dist/img/network/connectIcon.png
%{destdir}/vis/dist/img/network/cross.png
%{destdir}/vis/dist/img/network/cross2.png
%{destdir}/vis/dist/img/network/deleteIcon.png
%{destdir}/vis/dist/img/network/downArrow.png
%{destdir}/vis/dist/img/network/editIcon.png
%{destdir}/vis/dist/img/network/leftArrow.png
%{destdir}/vis/dist/img/network/minus.png
%{destdir}/vis/dist/img/network/plus.png
%{destdir}/vis/dist/img/network/rightArrow.png
%{destdir}/vis/dist/img/network/upArrow.png
%{destdir}/vis/dist/img/network/zoomExtends.png
%dir %{destdir}/vis/dist/img/timeline
%{destdir}/vis/dist/img/timeline/delete.png

%files trbs
%defattr(-,jenkins,jenkins)
%dir %{destdir}/common
%{destdir}/common/trbs.py
%{destdir}/job_trbs_test_result_receiver.py
%dir %{destdir}/trbs
%{destdir}/trbs/job_trbs_autoremove.py
%{destdir}/trbs/job_trbs_obs.py
%{destdir}/trbs/job_trbs_post_image.py
%{destdir}/trbs/job_trbs_submit.py
%{destdir}/trbs/job_trbs_test_automation.py
%{destdir}/trbs/job_trbs_update_git.py
%{destdir}/trbs/job_trbs_sync_aws.py

%files abs
%defattr(-,jenkins,jenkins)
%dir %{destdir}/abs
%{destdir}/abs/job_abs_build.py
%{destdir}/abs/job_abs_update.py
%{destdir}/abs/job_abs_frontend.py
%{destdir}/abs/job_abs_frontend.sh
%{destdir}/abs/job_abs_backend.py
%{destdir}/abs/job_update_abs_rbs_status_for_dashboard.py
%{destdir}/abs/job_update_status_remote_for_dashboard.py
%dir %{destdir}/common
%{destdir}/common/tizen_studio.py
%{destdir}/common/tizen_studio_docker.py
%{destdir}/abs/report_template

%files tzs
%defattr(-,jenkins,jenkins)
%{destdir}/job_submit.py

%files groovyinit
%defattr(-,jenkins,jenkins)
%dir %{homedir}/
%dir %{destinitdir}/
%{destinitdir}/init.groovy
%{destinitdir}/setup.properties.example
%{destinitdir}/Module_AmazonEC2Cloud
%{destinitdir}/Module_AmazonEC2Slave
%{destinitdir}/Module_AwsCredentials
%{destinitdir}/Module_Executors
%{destinitdir}/Module_GerritServer
%{destinitdir}/Module_Ldap
%{destinitdir}/Module_LocationConfig
%{destinitdir}/Module_Mailer
%{destinitdir}/Module_MatrixAuthorization
%{destinitdir}/Module_Node
%{destinitdir}/Module_RabbitmqConsumer
%{destinitdir}/Module_SshCredentials
%{homedir}/scriptApproval.xml

%files submitobs
%defattr(-,jenkins,jenkins)
%{destdir}/job_submitobs.py

%files pmb
%defattr(-,jenkins,jenkins)
%dir %{destdir}/pmb
%{destdir}/pmb/config.jenkins
%{destdir}/pmb/jiradata.txt
%{destdir}/pmb/job_tool_sender.py
%{destdir}/pmb/job_tool_jira_receiver.py
%{destdir}/pmb/job_tool_history_update.py
%{destdir}/pmb/job_release_mail_sender.py
%{destdir}/pmb/trigger_tools_staging_test.py

%files dtr
%defattr(-,jenkins,jenkins)
%dir %{destdir}/dtr
%{destdir}/dtr/job_dtr_status.py
%{destdir}/dtr/job_dtr_db_writer.py

%changelog
