#!/bin/bash

# Copyright (C) 2016 Samsung
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; version 2
#    of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

### "Search some data in git-trees file" ###

GIT=$1

FILE="git-trees"
LAST_LINE_NUM=`wc -l $FILE | awk -F ' ' '{print $1}'`

CNT=`grep -xn "G:\ $GIT" $FILE | awk -F ':' '{print $1}'`

RET=""

while [ 1 ]
do
    CHK=`head -$CNT $FILE | tail -1`
    if [ "$CHK" = "" ] || [ $CNT -eq $((LAST_LINE_NUM + 1)) ]; then
        echo $RET
        break;
    fi
    if [ "${CHK:$i:1}" = "D" ] || [ "${CHK:$i:1}" = "O" ] || [ "${CHK:$i:1}" = "L" ] || [ "${CHK:$i:1}" = "C" ]; then
                RET="$RET$CHK;"
        fi
    CNT=$((CNT + 1))
done
