#!/usr/bin/env python

import snapdiff

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

setup(name=snapdiff.__title__,
      version=snapdiff.__version__,
      description='Generate image and repo diffs',
      author='Lingchao Xin',
      author_email='lingchaox.xin@intel.com',
      url='http://www.tizen.org/',
      scripts=['tools/snap-diff',],
      packages=['snapdiff',],
      data_files = [('/etc/%s/' % snapdiff.__title__, ['distfiles/profile.yaml']),],
      include_package_data=True,
      install_requires=['Jinja2>=2.6', 'requests>=2.0.1', 'pyyaml>=3.10'],
      zip_safe=False,
)
