%define _build_name_fmt    %%{ARCH}/%%{NAME}-%%{VERSION}-%%{RELEASE}.%%{ARCH}.vanish.rpm
%define __os_install_post %{nil}
%define nodebug 1

Name:		mic-bootstrap
VCS:   tools/mic-bootstrap#3a17173ec055806cb5e020ac48dcee8e8641791e
Version:	1.0
Release:	2.1
AutoReqProv:    0
Provides:       %{name}
ExclusiveArch:  x86_64 %ix86

Summary:	mic bootstrap
Group:		System/Tools
License:	GPLv2
URL:		http://www.tizen.org/
Source100:      baselibs.conf
Source101:      rpmlintrc

BuildRequires:	rpm
#BuildRequires:	!rpmlint !rpmlint-min !rpmlint-tizen
BuildRequires:  python-rpm
BuildRequires:  python-zypp
BuildRequires:  kmod-compat
BuildRequires:  mic
#BuildRequires:  busybox
BuildRequires:  rpm-security-plugin
BuildRequires:  bmap-tools
BuildRequires:  e2fsprogs
BuildRequires:  kpartx
BuildRequires:  dosfstools
BuildRequires:  parted
BuildRequires:  openssl

%description
used for mic bootstrap, this package will be repackaged for i586 and arm libs.
it provides a x86 bootstrap environment for unified usage, especially to speed
up the performance of arm image creation.

%prep

%build

%install
%if %nodebug
set +x
%endif

mkdir -p %buildroot
mkdir -p %buildroot/bootstrap
rpm -qla > filestoinclude1

# ignore files - construct sed script
sedtmp="sedtmp.$$"
echo "s#^%{_docdir}.*##" >> $sedtmp
echo "s#^%{_mandir}.*##" >> $sedtmp
echo "s#^%{_infodir}.*##" >> $sedtmp
# ignore pyc and pyo
echo "s#^.*\.pyc\$##" >> $sedtmp
echo "s#^.*\.pyo\$##" >> $sedtmp

# ignore default filesystem files
for i in `rpm -ql filesystem`; do
  echo "s#^${i}\$##" >> $sedtmp
done

#finish up
echo "/^\$/d" >> $sedtmp

#execute
sed -f $sedtmp -i filestoinclude1

# tar copy to bootstrap dir under buildroot
# prefix /bootstrap will fix conflicts
tar -T filestoinclude1 -cpf - | ( cd %buildroot/bootstrap && tar -xpf - )
# tar copy /usr/bin and /usr/sbin to /bin and /sbin to fix symblic lost in tar
(cd /usr/bin && tar -cpf - *) | (cd %buildroot/bootstrap/bin && tar -xpf -)
(cd /usr/sbin && tar -cpf - *) | (cd %buildroot/bootstrap/sbin && tar -xpf -)
rm filestoinclude1

# Todo: refractor
# no directories, in filelist
find %buildroot >  filestoinclude2
cat filestoinclude2 | sed -e "s#%{buildroot}##g" | uniq | sort > filestoinclude1
for i in `cat filestoinclude1`; do
# no directories
  if test -h %buildroot/$i || ! test -d %buildroot/$i; then
    #
    echo "$i" >> filestoinclude
  fi
done
rm filestoinclude1
rm filestoinclude2

set -x

%clean
rm -rf $RPM_BUILD_ROOT

%files -f filestoinclude

%changelog
* Fri Jun 21 2013 Gui Chen <gui.chen@intel.com> -1.0
- fix baselib.conf
* Wed Jun 19 2013 Anas Nashif <anas.nashif@intel.com> submit/tizen/20130618.163133@495ed63
- fix duplicate source and regex of lint filter
* Tue Jun 18 2013 Anas Nashif <anas.nashif@intel.com> accepted/tizen/20130606.122015@a0a738f
- Add rpmlintrc to skip errors
* Mon Jun  3 2013 Anas Nashif <anas.nashif@intel.com> submit/tizen/20130603.141902@da9a281
- fixed arch exclusion again
* Mon Jun  3 2013 Anas Nashif <anas.nashif@intel.com> accepted/tizen_2.1/20130520.103448@7e6ff80
- fixed arch exclusion
* Fri Nov  9 2012 Gui Chen <gui.chen@intel.com> - 1.0
- Initial version on tizen.org
