
"""This module renders html templates"""

import os

from jinja2 import Environment, FileSystemLoader

_SETTINGS = {
    'template_path': os.path.join(os.path.dirname(__file__), 'templates'),
    }

def output_html(template_name, **kwargs):
    """Render a template file with given kwargs"""
    env = Environment(
        loader = FileSystemLoader(_SETTINGS['template_path']),
        # auto_reload = True,
    )
    template = env.get_template(template_name)
    return template.render(kwargs)
