%define major 0
%define libname lib%{name}%{major}
%define devname lib%{name}-devel

Name:           createrepo_c
Version:        0.17.4
Release:        1
License:        LGPL-2.1
Summary:        C language implemention of createrepo
Group:          System/Base
Source:         %{name}-%{version}.tar.gz
Source1001:     createrepo_c.manifest
BuildRequires:  libbz2-devel cmake libexpat-devel file-devel
BuildRequires:  libcurl-devel libxml2-devel python3-devel gcc-c++
BuildRequires:  rpm-devel openssl-devel sqlite-devel doxygen
BuildRequires:  glib2-devel xz-devel

Requires: %{libname} = %{version}-%{release}

%description
C language implemention of createrepo

%package -n %{devname}
Summary:        Devel package of createrepo_c
Provides:       %{devname} = %{version}-%{release}
Requires:       %{libname} = %{version}-%{release}

%description -n %{devname}
Devel package C language implemention of createrepo

%package -n %{libname}
Summary:        Library package of createrepo_c

%description -n %{libname}
Library package C language implemention of createrepo

%package -n python3-%{name}
Summary:        Python 3 bindings for the createrepo_c library
Requires:       %{libname}%{?_isa} = %{version}-%{release}
# Python 2 subpackage is fully dropped
Obsoletes:      python2-%{name} < 0.12.0

%description -n python3-%{name}
The Python 3 bindings for the createrepo_c library.


%prep
%setup -q
cp %{SOURCE1001} .

%build
cmake -DCMAKE_SKIP_RPATH=ON \
      -DCMAKE_INSTALL_PREFIX=%{_prefix} \
      -DENABLE_LEGACY_WEAKDEPS=ON

%{__make} %{?jobs:-j%jobs}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%install
make DESTDIR=%{buildroot} sysconfdir=%{_sysconfdir} install
for i in createrepo mergerepo modifyrepo sqliterepo;do
  ln -s  %{_bindir}/$i\_c %{buildroot}%{_bindir}/$i
  echo ".so man8/$i\_c.8" > %{buildroot}%{_mandir}/man8/$i\.8
done

%post -n %{libname} -p /sbin/ldconfig
%postun -n %{libname} -p /sbin/ldconfig

%files
%defattr(-, root, root,-)
%{_sysconfdir}/bash_completion.d/
%{_bindir}/createrepo_c
%{_bindir}/modifyrepo_c
%{_bindir}/sqliterepo_c
%{_bindir}/mergerepo_c
%{_bindir}/createrepo
%{_bindir}/mergerepo
%{_bindir}/modifyrepo
%{_bindir}/sqliterepo
%{_mandir}/*/*

%files -n %{devname}
%defattr(-, root, root,-)
%{_libdir}/libcreaterepo_c.so
%{_libdir}/pkgconfig/createrepo_c.pc
%{_includedir}/createrepo_c

%files -n %{libname}
%defattr(-, root, root,-)
%{_libdir}/libcreaterepo_c.so.*

%files -n python3-%{name}
%{python3_sitearch}/createrepo_c/

%changelog
