#!/usr/bin/env python3
from setuptools import setup

from itest import __version__

setup(name='itest',
      version=__version__,
      description='Functional test framework',
      long_description='Functional test framework',
      author='Hui Wang, Yigang Wen, Daiwei Yang, Hao Huang, Junchun Guan',
      author_email='huix.wang@intel.com, yigangx.wen@intel.com, '
      'dawei.yang@intel.com, hao.h.huang@intel.com, junchunx.guan@intel.com',
      license='GPLv2',
      platforms=['Linux'],
      include_package_data=True,
      packages=['itest', 'itest.conf', 'imgdiff', 'spm', 'spm.templates', 'nosexcase'],
      package_data={'': ['*.html']},
      data_files=[('/etc', ['spm/spm.yml'])],
      entry_points={
          'nose.plugins.0.10': [
              'xcase = nosexcase.xcase:XCase'
              ]
          },
      scripts=[
          'scripts/runtest',
          'scripts/runtest_pty',
          'scripts/imgdiff',
          'scripts/spm',
          ],
      )
