#!/usr/bin/env python

"""Tests for render module."""

import unittest

from snapdiff import render


class RenderTestCase(unittest.TestCase):

    def test_output_html(self):
        """Ensures that we can properly render html pages"""
        users = [{'url': 'http://example.com', 'username': 'foo'}]
        output = render.output_html('sparrow.html', users=users)
        self.assertEqual(output, u'<ul>\n\n  <li><a href="http://example.com">foo</a></li>\n\n</ul>\n')
