#
# spec file for package python-requests
#
# Copyright (c) 2013 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           python-requests
Version:        2.4.4
Release:        0
Url:            http://python-requests.org
Summary:        Awesome Python HTTP Library That's Actually Usable
License:        Apache-2.0 and LGPL-2.1+ and MIT
Group:          Development/Languages/Python
#TODO/FIXME: Maybe split out charade and urllib3 into sub-packages to simplify:
Source:         http://pypi.python.org/packages/source/r/requests/requests-%{version}.tar.gz
# PATCH-FIX-OPENSUSE no-default-cacert.patch -- completely ignore the internal CA bundle
Patch0:         no-default-cacert.patch
# PATCH-FIX-OPENSUSE no-default-cacert-sles.patch -- completely ignore the internal CA bundle (SLES version)
Patch1:         no-default-cacert-sles.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildRequires:  python
BuildRequires:  python-devel
BuildRequires:  python-setuptools
Requires:       python
%if 0%{?suse_version} && 0%{?suse_version} <= 1110
%{!?python_sitelib: %global python_sitelib %(python -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%else
BuildArch:      noarch
%endif

%description
Requests is an ISC Licensed HTTP library, written in Python, for human
beings.

Most existing Python modules for sending HTTP requests are extremely
verbose and cumbersome. Python's builtin urllib2 module provides most of
the HTTP capabilities you should need, but the api is thoroughly broken.
It requires an enormous amount of work (even method overrides) to
perform the simplest of tasks.

Features:

- Extremely simple GET, HEAD, POST, PUT, DELETE Requests
    + Simple HTTP Header Request Attachment
    + Simple Data/Params Request Attachment
    + Simple Multipart File Uploads
    + CookieJar Support
    + Redirection History
    + Redirection Recursion Urllib Fix
    + Auto Decompression of GZipped Content
    + Unicode URL Support
- Simple Authentication
    + Simple URL + HTTP Auth Registry

%prep
%setup -q -n requests-%{version}
# For rpmlint warning: remove shebang from python library:
sed -i '/^#!/d' ./requests/certs.py
%if %suse_version > 1110
%patch0 -p1
%else
%patch1 -p1
%endif
rm ./requests/cacert.pem

%build
python setup.py build

%check
python setup.py test

%install
python setup.py install --prefix=%{_prefix} --root=%{buildroot}

%files
%defattr(-,root,root)
%doc README.rst HISTORY.rst LICENSE NOTICE
%{python_sitelib}/*

%changelog
