#!/usr/bin/env python3
# Copyright 2015-2016 Samsung Electronics Co., Ltd.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from litmus.device.devicestandalone import devicestandalone


class devicestandalone_tw1(devicestandalone):
    """docstring for device"""
    _screen_width = 360
    _screen_height = 360

    def flash(self, filenames, flasher='heimdall', waiting=5,
              partition_bin_mappings={'BOOT': 'zImage',
                                      'ROOTFS': 'rootfs.img',
                                      'USER': 'user.img',
                                      'SYSTEM-DATA': 'system-data.img'}):
        """docstring for flash"""
        super(devicestandalone_tw1, self).flash(filenames, flasher, waiting,
                                                partition_bin_mappings)
