#!/usr/bin/env python3

"""A setuptools based setup module.
"""

from setuptools import setup
import os
import sys

here = os.path.abspath(os.path.dirname(__file__))

packages = ['bsr']

requires = [
    'requests>=2.19.1',
    'urllib3>=1.21.1',
]

about = {}
with open(os.path.join(here, 'bsr', '__version__.py'), 'r') as f:
    exec(f.read(), about) # pylint: disable=exec-used

with open('README.md', 'r') as f:
    readme = f.read()

def check_debian():
    """--install-layout is recognized after 2.5"""
    if sys.version_info[:2] > (2, 5):
        if len(sys.argv) > 1 and 'install' in sys.argv:
            try:
                import platform
                (dist, _, _) = platform.linux_distribution()
                # for debian-like distros, mods will be installed to
                # ${PYTHONLIB}/dist-packages
                if dist in ('debian', 'Ubuntu'):
                    sys.argv.append('--install-layout=deb')
            except AttributeError:
                pass

check_debian()

setup(
    name=about['__title__'],
    version=about['__version__'],
    description=about['__description__'],
    long_description=readme,
    long_description_content_type='text/markdown',
    author=about['__author__'],
    author_email=about['__author_email__'],
    url=about['__url__'],
    scripts=['bsr/bsr'],
    packages=['bsr', 'bsr.analyzer', 'bsr.network', 'bsr.tests', 'bsr.report', 'bsr.utility', 'bsr.gbs',
              'bsr.web_dist', 'bsr.web_dist.images', 'bsr.web_dist.static.css',
              'bsr.web_dist.static.js', 'bsr.web_dist.static.media'],
    package_data={
        '': ['LICENSE', 'NOTICE'],
        'requests': ['*.pem'],
        'bsr.web_dist': ["*.json", "*.html"],
        'bsr.web_dist.images': ["*.svg", "*.png"],
        'bsr.web_dist.static.css': ["*.css"],
        'bsr.web_dist.static.js': ["*.js", "*.txt"],
        'bsr.web_dist.static.media': ["*.woff2", "*.ttf", "*.svg", "*.woff", "*.eot", "*.png"],
        },
    include_package_data=True,
    python_requires=">=2.7.17, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*, !=3.4.*",
    install_requires=requires,
    license=about['__license__'],
    zip_safe=False,
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.17',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy'
    ],
    project_urls={
        'Documentation': about['__url__'],
        'Source': about['__url__'],
    },
)

