/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.supportenabler;

import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.tizen.web.tv.sec.wasm.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.wasm.supportenabler.Messages;
import org.tizen.web.tv.sec.wasm.supportenabler.WasmToolchainContent;

public class WasmToolchainDialog
extends TitleAreaDialog {
    private final WasmToolchainContent content;
    private Composite wasmToolchainContainer;
    private Button okButton;
    private final IProject tizenProject;

    public WasmToolchainDialog(Shell parentShell, IProject tizenProject) {
        super(parentShell);
        this.tizenProject = tizenProject;
        this.content = new WasmToolchainContent();
        this.content.setEnableToolchainConfirmation(new Consumer<Boolean>(){

            @Override
            public void accept(Boolean shouldEnableOk) {
                try {
                    if (WasmToolchainDialog.this.okButton != null) {
                        WasmToolchainDialog.this.okButton.setEnabled(shouldEnableOk.booleanValue());
                    }
                }
                catch (IllegalArgumentException | SWTException throwable) {
                    return;
                }
            }
        });
        this.setHelpAvailable(false);
    }

    public String getEmConfigPath() {
        return this.content.getEmConfigPath();
    }

    public String getEmCachePath() {
        return this.content.getEmCachePath();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.WasmToolchainContent_TITLE_BAR_TEXT);
        this.setTitle(Messages.WasmToolchainDialog_SET_WASM_TOOLCHAIN_TEXT);
        this.setMessage(Messages.WasmToolchainDialog_DESCRIPTION);
        this.wasmToolchainContainer = (Composite)super.createDialogArea(parent);
        this.content.implementContent(this.wasmToolchainContainer, this.tizenProject);
        return this.wasmToolchainContainer;
    }

    protected void okPressed() {
        IProject selectedProject = ProjectUtils.getCurrentProject();
        if (selectedProject != null) {
            this.content.performFinish(selectedProject, false);
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(1000, 300);
    }

    protected boolean isResizable() {
        return true;
    }
}

