/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.step;

import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.web.tv.sec.launch.util.SecTVCommandLauncher;
import org.tizen.web.tv.sec.launch.util.SecTVWRTCommandUtil;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;

public class SecTVDebugRWIAppIDSettingStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(SecTVDebugRWIAppIDSettingStep.class);
    protected SecTVCommandLauncher secTVLauncher;
    protected ZimLaunchResource resource;

    public SecTVDebugRWIAppIDSettingStep() {
        super(new IStep[0]);
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String errMsg = "";
        int code = 0;
        String eMsg = Messages.getFailMessage((String)Messages.STEP_DEBUG_URL_SETTING);
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort((String)eMsg, (Throwable)new TizenWebIDEException(errMsg, code), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        this.secTVLauncher = (SecTVCommandLauncher)((Object)ctx.getValue((Object)"command launcher"));
        if (this.secTVLauncher == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort((String)eMsg, (Throwable)new TizenWebIDEException(errMsg, code), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
    }

    public void executeStep(ILaunchContext ctx) throws Exception {
        this.preExecuteStep(ctx);
        String cmd = this.getLaunchCommand();
        if (!cmd.equals("")) {
            try {
                this.secTVLauncher.runCommand(cmd, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected String getLaunchCommand() throws Exception {
        SecTVWRTCommandUtil secTVWRTCommandUtil = new SecTVWRTCommandUtil();
        String cmd = null;
        cmd = secTVWRTCommandUtil.getCommand("SET_RWI_APP_ID_COMMAND", null, this.resource);
        return cmd;
    }
}

