/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.Surrogate;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.web.tv.sec.launch.Activator;
import org.tizen.web.tv.sec.launch.command.SdbCmdSelector;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.TizenDeviceInfo;
import org.tizen.web.zimlaunch.resource.TizenWebAppInfo;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.util.Messages;

public class SecTVWRTCommandUtil {
    Activator plugin;
    private Surrogate<Activator> su;

    public String getCommand(String key, String param, ZimLaunchResource resource) throws Exception {
        File appFile;
        if (resource == null || StringUtil.isEmpty((CharSequence)key)) {
            SecTVWRTCommandUtil.defaultAbort();
        }
        String errMsg = "";
        int code = 0;
        TizenWebAppInfo appInfo = resource.getAppinfo();
        TizenDeviceInfo devInfo = resource.getDeviceinfo();
        if (appInfo == null || devInfo == null) {
            SecTVWRTCommandUtil.defaultAbort();
        }
        int timeout = devInfo.getTimeout();
        String appID = appInfo.getAppID();
        String appPkgName = appInfo.getAppPackageID();
        String appGUID = appInfo.getAppGUID();
        String appName = appInfo.getAppFile().getName();
        if (key.equals("INSTALL_COMMAND") || key.equals("INSTALL_COMMAND_2")) {
            param = appName;
        }
        SdbCmdSelector sdbCmdSelector = new SdbCmdSelector(ConnectionPlugin.getDefault().getCurrentDevice());
        String cmd = sdbCmdSelector.getCmd(key, param);
        StringBuffer sbcmd = new StringBuffer(cmd);
        if (StringUtil.isEmpty((CharSequence)appID)) {
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONVERT_WRTCMD_HANDLE);
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONVERT_WRT_CMD_CAN_NOT_FIND_APPID.getCode();
            TizenWebIDEException.abort((String)Messages.STEP_CONVERT_WRTCMD_HANDLE_FAILED, (Throwable)new TizenWebIDEException(errMsg, code), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        if ((appFile = appInfo.getAppFile()) == null) {
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONVERT_WRTCMD_HANDLE);
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONVERT_WRT_CMD_CAN_NOT_FIND_FILE.getCode();
            TizenWebIDEException.abort((String)Messages.STEP_CONVERT_WRTCMD_HANDLE_FAILED, (Throwable)new TizenWebIDEException(errMsg, code), (TizenWebNotifier[])new TizenWebNotifier[0]);
        }
        String regex = "%timeout";
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + Integer.toString(timeout) + "\"");
        }
        regex = "%widgetGUID";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + appGUID + "\"");
        }
        regex = "%widgetID";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + appID + "\"");
        }
        regex = "%packageID";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + appPkgName + "\"");
        }
        regex = "%widgetPackageName";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + appID + "\"");
        }
        regex = "%widgetPath";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + SecTVWRTCommandUtil.getPackageTransferAbsolutePath(devInfo.getDevice(), appFile) + "\"");
        }
        return cmd;
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.getActivator().getPreferenceStore();
    }

    protected Activator getActivator() {
        this.plugin = (Activator)((Object)this.su.getAdapter());
        return this.plugin;
    }

    public static String getPackageTransferAbsolutePath(IDevice device, File appFile) {
        return String.valueOf(TizenPlatformConstants.getAppTmpDirectory((IDevice)device)) + "/" + appFile.getName();
    }

    protected static void defaultAbort() throws Exception {
        String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONVERT_WRTCMD_HANDLE);
        int code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONVERT_WRT_CMD.getCode();
        TizenWebIDEException.abort((String)Messages.STEP_CONVERT_WRTCMD_HANDLE_FAILED, (Throwable)new TizenWebIDEException(errMsg, code), (TizenWebNotifier[])new TizenWebNotifier[0]);
    }
}

