/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.tizen.web.tv.sec.util.OSUtil;

public class StvSDKAboutUI
extends Dialog {
    private Text tztvSDKVertext;
    List versionList;
    private String sTVExtensionTitle = "Samsung TV Extension";
    private String sdkTitle = String.valueOf(this.sTVExtensionTitle) + " " + "for Tizen Studio";

    public StvSDKAboutUI(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        Bundle bundle = Platform.getBundle((String)"org.tizen.web.tv.sec");
        URL imgFileURL = null;
        try {
            imgFileURL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/stv_sdk_icon.png"), null));
            ImageData stvLogoImageData = new ImageData(imgFileURL.getPath());
            Image stvLogoImage = new Image((Device)shell.getDisplay(), stvLogoImageData);
            shell.setImage(stvLogoImage);
            shell.setText(this.sdkTitle);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new FormLayout());
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new FormLayout());
        FormData fd_composite = new FormData();
        fd_composite.top = new FormAttachment(0, 10);
        fd_composite.left = new FormAttachment(0, 10);
        fd_composite.right = new FormAttachment(0, 434);
        composite.setLayoutData((Object)fd_composite);
        Label lblSamsungTizenTv = new Label(composite, 0);
        FormData fd_lblSamsungTizenTv = new FormData();
        lblSamsungTizenTv.setLayoutData((Object)fd_lblSamsungTizenTv);
        lblSamsungTizenTv.setText(this.sdkTitle);
        this.versionList = new List(container, 770);
        fd_composite.bottom = new FormAttachment(100, -429);
        Label lblVersion = new Label(composite, 0);
        fd_lblSamsungTizenTv.bottom = new FormAttachment((Control)lblVersion, -6);
        fd_lblSamsungTizenTv.left = new FormAttachment((Control)lblVersion, 0, 16384);
        FormData fd_lblVersion = new FormData();
        fd_lblVersion.top = new FormAttachment(0, 52);
        lblVersion.setLayoutData((Object)fd_lblVersion);
        lblVersion.setText("Version :");
        this.tztvSDKVertext = new Text(composite, 0);
        this.tztvSDKVertext.setEnabled(false);
        this.tztvSDKVertext.setEditable(false);
        FormData fd_tztvSDKVertext = new FormData();
        fd_tztvSDKVertext.top = new FormAttachment((Control)lblVersion, 0, 128);
        fd_tztvSDKVertext.left = new FormAttachment((Control)lblVersion, 6);
        this.tztvSDKVertext.setLayoutData((Object)fd_tztvSDKVertext);
        Label lblVisit = new Label(composite, 0);
        FormData fd_lblVisit = new FormData();
        lblVisit.setLayoutData((Object)fd_lblVisit);
        lblVisit.setText("Visit : ");
        Link link = new Link(composite, 0);
        fd_lblVisit.right = new FormAttachment((Control)link, -6);
        fd_lblVisit.bottom = new FormAttachment((Control)link, 0, 1024);
        FormData fd_link = new FormData();
        fd_link.top = new FormAttachment((Control)this.tztvSDKVertext, 47);
        fd_link.left = new FormAttachment((Control)this.tztvSDKVertext, 0, 16384);
        link.setLayoutData((Object)fd_link);
        link.setText("<a href=\"http://developer.samsung.com/tv\">http://developer.samsung.com/tv</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.text));
                }
                catch (PartInitException ex) {
                    ex.printStackTrace();
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
        });
        FormData fd_versionList = new FormData();
        fd_versionList.top = new FormAttachment((Control)composite, 6);
        fd_versionList.right = new FormAttachment(100, -16);
        fd_versionList.left = new FormAttachment(0, 10);
        Bundle bundle = Platform.getBundle((String)"org.tizen.web.tv.sec");
        URL imgFileURL = null;
        try {
            imgFileURL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/stv_logo.png"), null));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Composite stvLogoComposite = new Composite(composite, 0);
        fd_lblVisit.left = new FormAttachment((Control)stvLogoComposite, 6);
        fd_lblVersion.left = new FormAttachment(0, 138);
        FormData fd_stvLogoComposite = new FormData();
        fd_stvLogoComposite.right = new FormAttachment(100, -292);
        fd_stvLogoComposite.left = new FormAttachment(0, 10);
        fd_stvLogoComposite.top = new FormAttachment(0, 10);
        fd_stvLogoComposite.bottom = new FormAttachment(100, -10);
        stvLogoComposite.setLayoutData((Object)fd_stvLogoComposite);
        if (imgFileURL != null) {
            ImageData stvLogoImageData = new ImageData(imgFileURL.getPath());
            final Image stvLogoImage = new Image((Device)stvLogoComposite.getDisplay(), stvLogoImageData);
            Label stvLogoImageLabel = new Label(stvLogoComposite, 0);
            stvLogoImageLabel.setLayoutData((Object)new FormData());
            stvLogoImageLabel.setImage(stvLogoImage);
            Canvas stvLogoCanvas = new Canvas(stvLogoComposite, 0);
            stvLogoCanvas.setBounds(10, 10, 100, 111);
            stvLogoCanvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    pe.gc.drawImage(stvLogoImage, 0, 0);
                }
            });
        }
        fd_versionList.height = 129;
        fd_versionList.width = 424;
        this.versionList.setLayoutData((Object)fd_versionList);
        Button btnCopyTo = new Button(container, 0);
        fd_versionList.bottom = new FormAttachment((Control)btnCopyTo, -19);
        btnCopyTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StvSDKAboutUI.this.versionListAllDataCopyToClipboard();
            }
        });
        FormData fd_btnCopyTo = new FormData();
        fd_btnCopyTo.left = new FormAttachment(0, 228);
        fd_btnCopyTo.right = new FormAttachment(100, -16);
        fd_btnCopyTo.bottom = new FormAttachment(100, -24);
        btnCopyTo.setLayoutData((Object)fd_btnCopyTo);
        btnCopyTo.setText("Copy to clipboard");
        this.versionList.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.stateMask == 262144 && event.keyCode == 99) {
                    StvSDKAboutUI.this.versionListDataCopyToClipboard();
                }
            }

            public void keyReleased(KeyEvent event) {
                if (event.stateMask == 262144 && event.keyCode == 99) {
                    StvSDKAboutUI.this.versionListDataCopyToClipboard();
                }
            }
        });
        this.initTZTVSDKVersion();
        this.initVersionList();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(456, 700);
    }

    protected String getSDKInstallRootPath() {
        String ideRootPath = this.getIDERootPath();
        String sdkRootPath = "";
        sdkRootPath = OSUtil.isMAC() ? String.valueOf(ideRootPath) + '/' + ".." + '/' + ".." + '/' + ".." + '/' : String.valueOf(ideRootPath) + '/' + ".." + '/';
        return sdkRootPath;
    }

    protected String getIDERootPath() {
        String ideRootPath = "";
        ideRootPath = Platform.getInstallLocation().getURL().getPath();
        return ideRootPath;
    }

    protected String getVersion(String keyWord, String filePath) {
        String version;
        block14: {
            version = "0.0.0";
            Pattern versionPattern = Pattern.compile("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b");
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(filePath));
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        if (line.indexOf(keyWord) == -1) continue;
                        Matcher matcher = versionPattern.matcher(line);
                        while (matcher.find()) {
                            version = matcher.group(0);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (br == null) break block14;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return version;
    }

    protected String getPartnerSDKVersion(String keyWord, String filePath) {
        String version;
        block14: {
            version = "0.0.0";
            Pattern versionPattern = Pattern.compile("\\d+$");
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(filePath));
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        if (line.indexOf(keyWord) == -1) continue;
                        Matcher matcher = versionPattern.matcher(line);
                        while (matcher.find()) {
                            version = matcher.group(0);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (br == null) break block14;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return version;
    }

    protected String getStvSDKVersion() {
        String stvSDKVersion = "0.0.0";
        String versionKeyword = "SDK_Version";
        String sdkVerfilePath = String.valueOf(this.getIDERootPath()) + '/' + this.getIDEPluginVersionFileName();
        File versionFile = new File(sdkVerfilePath);
        if (versionFile.exists() && (stvSDKVersion = this.getVersion(versionKeyword, sdkVerfilePath)).equals("0.0.0")) {
            stvSDKVersion = this.getPartnerSDKVersion(versionKeyword, sdkVerfilePath);
        }
        return stvSDKVersion;
    }

    private String getIDEPluginVersionFileName() {
        String versionFileName = "";
        String packageName = "samsung-eplugin";
        versionFileName = String.valueOf(this.getPackageMainVersionName()) + "-" + packageName + ".version";
        return versionFileName;
    }

    private String getPackageMainVersionName() {
        String packageMainVersionName = "tv";
        return packageMainVersionName;
    }

    protected HashMap<String, String> getStvEmulatorPlatformImgVersion() {
        String versionKeyword = "binary_version";
        String platformsPath = String.valueOf(this.getSDKInstallRootPath()) + '/' + "platforms" + '/';
        File platformsDir = new File(platformsPath);
        String[] platformList = platformsDir.list();
        HashMap<String, String> emulatorVersionMap = new HashMap<String, String>();
        String emulVersion = "0.0.0";
        String[] stringArray = platformList;
        int n = platformList.length;
        int n2 = 0;
        while (n2 < n) {
            String platformName = stringArray[n2];
            try {
                if (!platformName.equals("common") && !platformName.equals(".DS_Store")) {
                    String platformVerText = platformName.split("-", 2)[1];
                    String platformMainVer = platformVerText.substring(0, 3);
                    double platformVerNumber = Double.parseDouble(platformMainVer.trim());
                    emulVersion = platformVerNumber < 3.0 ? this.getEmulatorImageVersionUntilVerTizen24(platformsPath, platformName, platformVerText, versionKeyword) : this.getEmulatorImageVersion(platformsPath, platformName, platformVerText, versionKeyword);
                    if (!platformName.equals("common")) {
                        emulatorVersionMap.put(platformName, emulVersion);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return emulatorVersionMap;
    }

    private String getEmulatorImageVersionUntilVerTizen24(String platformsPath, String platformName, String platformVer, String versionKeyword) {
        String[] sdkTypeNameList;
        String emulVersion = "0.0.0";
        String[] stringArray = sdkTypeNameList = new String[]{"public", "partner", "product"};
        int n = sdkTypeNameList.length;
        int n2 = 0;
        while (n2 < n) {
            String sdkTypeName = stringArray[n2];
            File stvDir = new File(String.valueOf(platformsPath) + platformName + '/' + "tv-samsung-" + sdkTypeName + '/');
            if (stvDir.exists()) {
                String emulVersionFilePath = String.valueOf(stvDir.getPath()) + '/' + "emulator-images" + '/' + "tv-samsung-" + sdkTypeName + "-" + platformVer + "-x86" + '/' + "info.ini";
                File emulVersionFile = new File(emulVersionFilePath);
                if (!emulVersionFile.exists()) {
                    String oldEmulVersionFilePath = String.valueOf(stvDir.getPath()) + '/' + "emulator-images" + '/' + platformVer + "-stv-" + sdkTypeName + '/' + "info.ini";
                    File oldEmulVersionFile = new File(oldEmulVersionFilePath);
                    if (oldEmulVersionFile.exists()) {
                        emulVersion = this.getVersion(versionKeyword, oldEmulVersionFilePath);
                        break;
                    }
                } else if (emulVersionFile.exists()) {
                    emulVersion = this.getVersion(versionKeyword, emulVersionFilePath);
                    break;
                }
            }
            ++n2;
        }
        return emulVersion;
    }

    private String getEmulatorImageVersion(String platformsPath, String platformName, String platformVer, String versionKeyword) {
        String emulVersion = "0.0.0";
        File stvDir = new File(String.valueOf(platformsPath) + platformName + '/' + "tv-samsung" + '/');
        if (!stvDir.exists()) {
            return emulVersion;
        }
        String emulVersionFilePath = String.valueOf(stvDir.getPath()) + '/' + "emulator-images" + '/' + "tv-samsung" + "-" + platformVer + "-x86" + '/' + "info.ini";
        File emulVersionFile = new File(emulVersionFilePath);
        emulVersion = emulVersionFile.exists() ? this.getVersion(versionKeyword, emulVersionFilePath) : this.getEmulatorImageVersionBySDKType(stvDir, platformVer, versionKeyword);
        return emulVersion;
    }

    private String getEmulatorImageVersionBySDKType(File stvDir, String platformVer, String versionKeyword) {
        String[] sdkTypeNameList;
        String emulVersion = "0.0.0";
        String[] stringArray = sdkTypeNameList = new String[]{"inhouse", "public", "partner"};
        int n = sdkTypeNameList.length;
        int n2 = 0;
        while (n2 < n) {
            String sdkTypeName = stringArray[n2];
            String emulVersionFilePath = String.valueOf(stvDir.getPath()) + '/' + "emulator-images" + '/' + "tv-samsung" + "-" + sdkTypeName + "-" + platformVer + "-x86" + '/' + "info.ini";
            File emulVersionFile = new File(emulVersionFilePath);
            if (emulVersionFile.exists()) {
                emulVersion = this.getVersion(versionKeyword, emulVersionFilePath);
                break;
            }
            String anotherEmulVersionFilePath = String.valueOf(stvDir.getPath()) + '/' + "emulator-images" + '/' + "tv-samsung" + "-" + sdkTypeName + "-" + platformVer + "-i386" + '/' + "info.ini";
            File anotherEmulVersionFile = new File(anotherEmulVersionFilePath);
            if (anotherEmulVersionFile.exists()) {
                emulVersion = this.getVersion(versionKeyword, anotherEmulVersionFilePath);
                break;
            }
            ++n2;
        }
        return emulVersion;
    }

    protected String getStvIDEVersion() {
        String ideVersion = "0.0.0";
        String versionKeyword = "Version";
        String ideVerfilePath = String.valueOf(this.getIDERootPath()) + '/' + this.getIDEPluginVersionFileName();
        File ideVersionFile = new File(ideVerfilePath);
        if (ideVersionFile.exists()) {
            ideVersion = this.getVersion(versionKeyword, ideVerfilePath);
        }
        return ideVersion;
    }

    protected String getStvIDEResourcesVersion() {
        String ideResVersion = "0.0.0";
        String versionKeyword = "Version";
        String ideResVerfilePath = String.valueOf(this.getIDERootPath()) + '/' + this.getIDEResourceVersionFileName();
        File ideVersionFile = new File(ideResVerfilePath);
        if (ideVersionFile.exists()) {
            ideResVersion = this.getVersion(versionKeyword, ideResVerfilePath);
        }
        return ideResVersion;
    }

    private String getIDEResourceVersionFileName() {
        String versionFileName = "";
        String packageName = "samsung-eplugin-res";
        versionFileName = String.valueOf(this.getPackageMainVersionName()) + "-" + packageName + ".version";
        return versionFileName;
    }

    protected String getStvWebSimulatorVersion() {
        String webSimulatorVersion = "0.0.0";
        String versionKeyword = "Version";
        String webSimulatorVerfilePath = String.valueOf(this.getSDKInstallRootPath()) + '/' + "tools" + '/' + "sec-tv-simulator" + '/' + "sec-tv-simulator.version";
        File webSimulatorVersionFile = new File(webSimulatorVerfilePath);
        if (webSimulatorVersionFile.exists()) {
            webSimulatorVersion = this.getVersion(versionKeyword, webSimulatorVerfilePath);
        }
        return webSimulatorVersion;
    }

    protected void initVersionList() {
        this.versionList.add("");
        this.versionList.add(String.valueOf(this.sTVExtensionTitle) + " plugin version     : " + this.getStvIDEVersion());
        this.versionList.add(String.valueOf(this.sTVExtensionTitle) + " resources version : " + this.getStvIDEResourcesVersion());
        this.versionList.add("");
        this.versionList.add(" Samsung TV Web Simulator version      : " + this.getStvWebSimulatorVersion());
        this.versionList.add("");
        this.versionList.add(" [ Samsung TV Emulator image version ] ");
        HashMap<String, String> emulatorVersionMap = this.getStvEmulatorPlatformImgVersion();
        Set<Map.Entry<String, String>> set = emulatorVersionMap.entrySet();
        for (Map.Entry<String, String> e : set) {
            this.versionList.add(" - " + e.getKey() + " : " + e.getValue());
        }
    }

    protected void initTZTVSDKVersion() {
        this.tztvSDKVertext.setText(this.getStvSDKVersion());
    }

    private void versionListDataCopyToClipboard() {
        String data = "";
        String[] stringArray = this.versionList.getSelection();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            data = String.valueOf(data) + str + System.getProperty("line.separator");
            ++n2;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (data != null && !data.isEmpty()) {
            StringSelection contents = new StringSelection(data);
            clipboard.setContents(contents, null);
        }
    }

    private void versionListAllDataCopyToClipboard() {
        String sdkVersion = String.valueOf(this.sdkTitle) + " " + "Version : " + this.tztvSDKVertext.getText();
        String[] versionInfo = this.versionList.getItems();
        String data = "";
        data = String.valueOf(data) + sdkVersion + System.getProperty("line.separator");
        String[] stringArray = versionInfo;
        int n = versionInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            data = String.valueOf(data) + str + System.getProperty("line.separator");
            ++n2;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(data);
        clipboard.setContents(contents, null);
    }
}

