#!/bin/bash
cd "$(dirname "$0")"

if [ -x "./runtime/node" ]; then
  echo "Using bundled Node.js runtime"
  ./runtime/node dist/index.js "$@"
else
  echo "[warn] Bundled runtime missing, using system Node.js"
  if ! command -v node >/dev/null 2>&1; then
    echo "[error] Node.js not found" >&2
    exit 1
  fi

  node dist/index.js "$@"
fi
