/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Resource;

public final class Color
extends Resource {
    public double[] handle;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int n, int n2, int n3) {
        super(device);
        this.init(n, n2, n3, 255);
        this.init();
    }

    public Color(Device device, int n, int n2, int n3, int n4) {
        super(device);
        this.init(n, n2, n3, n4);
        this.init();
    }

    public Color(Device device, RGB rGB) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, 255);
        this.init();
    }

    public Color(Device device, RGBA rGBA) {
        super(device);
        if (rGBA == null) {
            SWT.error(4);
        }
        this.init(rGBA.rgb.red, rGBA.rgb.green, rGBA.rgb.blue, rGBA.alpha);
        this.init();
    }

    public Color(Device device, RGB rGB, int n) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, n);
        this.init();
    }

    void destroy() {
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        double[] dArray = color.handle;
        if (this.handle == dArray) {
            return true;
        }
        return this.device == color.device && (int)(this.handle[0] * 255.0) == (int)(dArray[0] * 255.0) && (int)(this.handle[1] * 255.0) == (int)(dArray[1] * 255.0) && (int)(this.handle[2] * 255.0) == (int)(dArray[2] * 255.0) && (int)(this.handle[3] * 255.0) == (int)(dArray[3] * 255.0);
    }

    public int getAlpha() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[3] * 255.0);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[2] * 255.0);
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[1] * 255.0);
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[0] * 255.0);
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return (int)(this.handle[0] * 255.0) ^ (int)(this.handle[1] * 255.0) ^ (int)(this.handle[2] * 255.0) ^ (int)(this.handle[3] * 255.0);
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public RGBA getRGBA() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGBA(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public static Color cocoa_new(Device device, double[] dArray) {
        double[] dArray2 = dArray;
        Color color = new Color(device);
        color.handle = dArray2;
        return color;
    }

    public static Color cocoa_new(Device device, double[] dArray, int n) {
        double[] dArray2 = dArray;
        Color color = new Color(device);
        color.handle = dArray2;
        color.handle[3] = (float)n / 255.0f;
        return color;
    }

    void init(int n, int n2, int n3, int n4) {
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0 || n4 > 255 || n4 < 0) {
            SWT.error(5);
        }
        double[] dArray = new double[]{(float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, (float)n4 / 255.0f};
        this.handle = dArray;
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "}";
    }
}

