#!/bin/sh -e

TIZEN_SDK_INSTALL_PATH="`echo $INSTALLED_PATH`"
OLD_SHMMAXSIZE=`sysctl -n kern.sysv.shmmax`
SYSCTL_FILE=sysctl.conf
COCOASUDO_PATH=$TIZEN_SDK_INSTALL_PATH/tools/emulator/bin
TIZEN_BIN_PATH=$TIZEN_SDK_INSTALL_PATH/platforms/tizen-10.0/common/emulator/bin
TIZEN_PLATFORM_ETC_PATH=$TIZEN_SDK_INSTALL_PATH/platforms/tizen-10.0/common/emulator/etc
TIZEN_TOOL_ETC_PATH=$TIZEN_SDK_INSTALL_PATH/tools/emulator/etc
TMP_FILE=emulator-install.sh
NEW_SHMMAXSIZE=83886080

if [ -z "$TIZEN_SDK_INSTALL_PATH" ]
then
	echo "There is no TIZEN_SDK_PATH ENV" >> /tmp/emulator.log
	# exit 2;
fi

function remove_tmp_file {
	if [ -e "$TMP_FILE" ]
	then
		echo "delete $TMP_FILE"
		rm -f "$TMP_FILE"
	fi
}

function generate_tap_kext_cmd {
	echo "cp -pR \"${TIZEN_PLATFORM_ETC_PATH}/emulator-ifup.sh\"  /etc/" >> "$TMP_FILE"
	echo "mkdir -p /Library/Extensions" >> "$TMP_FILE"
	echo "cp -pR \"${TIZEN_TOOL_ETC_PATH}/tap.kext\" /Library/Extensions" >> "$TMP_FILE"
	echo "rm -rf \"${TIZEN_TOOL_ETC_PATH}/tap.kext\"" >> "$TMP_FILE"
	echo "chown -R root:wheel /Library/Extensions/tap.kext" >> "$TMP_FILE"
	echo "mkdir -p /Library/LaunchDaemons" >> "$TMP_FILE"
	echo "cp /Library/Extensions/tap.kext/Contents/net.sf.tuntaposx.tap.plist /Library/LaunchDaemons" >> "$TMP_FILE"
	echo "kextutil -nt /Library/Extensions/tap.kext" >> "$TMP_FILE"
	echo "/sbin/kextload /Library/Extensions/tap.kext" >> "$TMP_FILE"
}

function generate_sudoer_cmd {
	cat << 'EOF' >> $TMP_FILE
FILE=/etc/sudoers
BACKFILE=/etc/sudoers.bak
TMPFILE=/etc/sudoers.tmp
MESSAGE="# Tizen SDK generated the following script. Do not modify."
LINE1="User_Alias QEMUERS="
LINE2="Cmnd_Alias QEMU=/etc/emulator-ifup.sh, /etc/emulator-ifdown.sh"
LINE3="QEMUERS ALL=(ALL) NOPASSWD: QEMU"
count=0

if [[ "$USER" == "" ]]
then
	echo "user is not set. aborting..."
	exit 1
fi

while read line
do
	echo $line
	count=$((count+1))
	if [[ $line == $LINE1* ]]
	then
		echo "find original script"
		NAMES=`echo $line | cut -d = -f2`
		if [[ "$NAMES"x == ""x ]]
		then
			cp $FILE $BACKFILE
			# in case of blank user
			eval sed -e "$count"c\"$line $USER\" $FILE > $TMPFILE
			exit 0
		fi
		for i in $(echo $NAMES | tr "," "\n")
		do
			if [[ "$i" == "$USER" ]]
			then
				echo "already added the same user"
				exit 0
			fi
		done
		cp $FILE $BACKFILE
		# new user is added with comma behind the original users.
		eval sed -e "$count"c\"$line, $USER\" $FILE > $TMPFILE
		mv $TMPFILE $FILE
		exit 0
		fi
done < $FILE

cp $FILE $BACKFILE
echo "do not find qemu sudoer. add it"
echo "$MESSAGE" >> $FILE
echo "$LINE1$USER" >> $FILE
echo "$LINE2" >> $FILE
echo "$LINE3" >> $FILE
exit 0
EOF
}

function prepare {
	TAP_ZIP_FILE="$TIZEN_TOOL_ETC_PATH/tap.zip"
	TAP_KEXT="$TIZEN_TOOL_ETC_PATH/tap.kext"
	USER=`id -un`
	echo "create $TMP_FILE"
	echo "#!/bin/sh" > "$TMP_FILE"
	echo "TIZEN_SDK_INSTALL_PATH=$TIZEN_SDK_INSTALL_PATH" >> "$TMP_FILE"
	echo "USER=$USER" >> "$TMP_FILE"
}

function generate {
	generate_tap_kext_cmd;
	generate_sudoer_cmd;
}

function execute {
	/bin/chmod +x "$TMP_FILE"
	"$COCOASUDO_PATH/cocoasudo" --prompt="Please enter your password to install Tizen Emulator." sh -x "$TMP_FILE"
}

function cleanup {
	remove_tmp_file;
}

prepare;
generate;
execute;
cleanup;

CURRENT_SHMMAXSIZE=`sysctl -n kern.sysv.shmmax`

if [ ! $OLD_SHMMAXSIZE -eq $CURRENT_SHMMAXSIZE ]
then
	echo 'need reboot'
	exit 99
fi

