#!/bin/bash -x

TIZEN_SDK_INSTALL_PATH=`echo ${INSTALLED_PATH}`
TIZEN_PLATFORM_ETC_PATH=$TIZEN_SDK_INSTALL_PATH/platforms/tizen-10.0/common/emulator/etc
if [ -z "${TIZEN_SDK_INSTALL_PATH}" ]
then
#   echo "There is no TIZEN_SDK_PATH ENV" >> /tmp/emulator.log
   exit 2;
fi

PLATFORM_VERSION=tizen-10.0

LSB_RELEASE=`which lsb_release`
if [ "${LSB_RELEASE}" = "" ]; then
	if [ -e /etc/os-release ]; then
		OS_NAME=`cat /etc/os-release | grep ID | head -n 1 | awk -F= '{print $2}'`
	fi
	# TODO: Detect other linux distributions.
else
	OS_NAME=`lsb_release --id --short`
fi

if [ ! -z "${OS_NAME}" ]; then
	OS_NAME=`echo ${OS_NAME} | tr '[:upper:]' '[:lower:]'`
fi
echo "Linux Distribution: ${OS_NAME}"

# need sudo to enable kvm module and set qemu sudoers
TMP_FILE=init_tizen.sh
echo "#!/bin/bash -x" >> ${TMP_FILE}
echo "TIZEN_SDK_INSTALL_PATH=$TIZEN_SDK_INSTALL_PATH" >> ${TMP_FILE}
echo "cp \"${TIZEN_SDK_INSTALL_PATH}/platforms/${PLATFORM_VERSION}/common/emulator/etc/tizen-vhost-net\" /etc/init.d/" >> ${TMP_FILE}
echo "cp \"${TIZEN_SDK_INSTALL_PATH}/platforms/${PLATFORM_VERSION}/common/emulator/etc/45-tizen-vhost-net.rules\" /lib/udev/rules.d/" >> ${TMP_FILE}
echo "cp \"${TIZEN_PLATFORM_ETC_PATH}/emulator-ifup.sh\" /etc" >> $TMP_FILE
echo "update-rc.d tizen-vhost-net defaults" >> $TMP_FILE
echo "if [ ! -d /etc/sudoers.d ];then" >> $TMP_FILE
echo "mkdir /etc/sudoers.d" >> $TMP_FILE
echo "fi" >> $TMP_FILE
echo "cp \"${TIZEN_PLATFORM_ETC_PATH}/tizen-sudoers.rules\" /etc/sudoers.d/tizen-emulator" >> $TMP_FILE
echo "chmod 0440 /etc/sudoers.d/tizen-emulator" >> $TMP_FILE
echo "chmod 0666 /dev/vhost-net" >> $TMP_FILE
chmod +x ${TMP_FILE}
if [ "${TSUDO}" != "" ] # since installer v2.27
then
	TSUDO_MSG="Enter your password to install Tizen Emulator"
	TMP_PATH="`pwd`/${TMP_FILE}"
	${TSUDO} -m "${TSUDO_MSG}" bash -x "${TMP_PATH}"
else
	GKSUDO=`which gksudo`
	if [ "${GKSUDO}" = "" ]
	then
		echo "there is no gksudo."
		sudo bash -x ./${TMP_FILE}
	else
		gksudo bash -x ./${TMP_FILE}
	fi
fi

rm ${TMP_FILE}
