#!/bin/sh

if [ "$(uname | cut -c 1-5)" = "Linux" ]; then
# under linux
SCRIPT_DIR=$(dirname "$(readlink -f "$0")")
EMULATOR_INSTALLED_PATH=$(readlink -f "$SCRIPT_DIR/..")
EMULATOR_BIN_PATH=$EMULATOR_INSTALLED_PATH/bin

# set env variables for linux
# LD_LIBRARY_PATH is not mandatory anymore, but we leave it for sure.
export LD_LIBRARY_PATH="$EMULATOR_BIN_PATH":

elif [ "$(uname | cut -c 1-6)" = "Darwin" ]; then
# under darwin
EMULATOR_INSTALLED_PATH=$(cd "$(dirname "$0")"; cd ..; pwd)
EMULATOR_BIN_PATH=$EMULATOR_INSTALLED_PATH/bin

# set env variables for darwin
# nothing now...

elif [ "$(uname | cut -c 1-5)" = "MINGW" ]; then
# under mingw
SCRIPT_DIR=$(dirname "$(readlink -f "$0")")
EMULATOR_INSTALLED_PATH=$(readlink -f "$SCRIPT_DIR/..")
EMULATOR_BIN_PATH=$EMULATOR_INSTALLED_PATH/bin
# set env variables for windows
# for SDL display
export SDL_STDIO_REDIRECT=0

fi

# set platform independent environment variables
# for VIGS
export VIGS_SYNC_READ_PIXELS=1

# check "--with-gdb"
WITH_GDB="no"
if [ "$1" = "--with-gdb" ]; then
	shift
	WITH_GDB="yes"
fi

# try to use default conf file if no options provided
if [ -z $1 ]; then
	if [ -e $HOME/.emulator_default.conf ]; then
		set -- "--conf" "$HOME/.emulator_default.conf"
		echo "No options provided. Use default conf file [$HOME/.emulator_default.conf]."
	fi
fi

# run emulator
if [ "$WITH_GDB" = "yes" ]; then
	gdb --args "$EMULATOR_BIN_PATH/emulator-x86_64" "$@"
else
	"$EMULATOR_BIN_PATH/emulator-x86_64" "$@"
fi
