/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.base.util.HelpProperties;
import org.eclipse.help.internal.protocols.HelpURLConnection;
import org.eclipse.help.internal.search.LazyProgressMonitor;
import org.eclipse.help.internal.search.PluginIndex;
import org.eclipse.help.internal.search.PrebuiltIndexes;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.search.SearchParticipant;

class IndexingOperation {
    private static final String ELEMENT_NAME_INDEX = "index";
    private static final String ATTRIBUTE_NAME_PATH = "path";
    private int numAdded;
    private int numRemoved;
    private SearchIndex index = null;

    public IndexingOperation(SearchIndex ix) {
        this.index = ix;
    }

    private void checkCancelled(IProgressMonitor pm) throws OperationCanceledException {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void execute(IProgressMonitor pm) throws OperationCanceledException, IndexingException {
        this.checkCancelled(pm);
        Collection<URL> staleDocs = this.getRemovedDocuments(this.index);
        this.numRemoved = staleDocs.size();
        Collection<URL> newDocs = this.getAddedDocuments(this.index);
        this.numAdded = newDocs.size();
        if (this.numRemoved + this.numAdded <= 0) {
            pm.done();
            BaseHelpSystem.getLocalSearchManager().clearSearchParticipants();
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (String)HelpBaseResources.UpdatingIndex, (int)(this.numRemoved + 10 * this.numAdded));
        this.removeStaleDocuments((IProgressMonitor)subMonitor.split(this.numRemoved), staleDocs);
        this.checkCancelled(pm);
        this.addNewDocuments((IProgressMonitor)subMonitor.split(10 * this.numAdded), newDocs, staleDocs.size() == 0);
        pm.done();
        BaseHelpSystem.getLocalSearchManager().clearSearchParticipants();
    }

    private Map<String, String[]> calculateNewToRemove(Collection<URL> newDocs, Map<String, String[]> prebuiltDocs) {
        Map<String, String[]> docsToDelete = prebuiltDocs;
        ArrayList<String> prebuiltHrefs = new ArrayList<String>(prebuiltDocs.keySet());
        int i = 0;
        while (i < prebuiltHrefs.size()) {
            String href = prebuiltHrefs.get(i);
            URL u = SearchIndex.getIndexableURL(this.index.getLocale(), href);
            if (u == null) {
                docsToDelete.put(href, null);
            }
            if (newDocs.contains(u)) {
                if (docsToDelete.get(href) == null) {
                    docsToDelete.remove(href);
                }
            } else {
                docsToDelete.put(href, null);
            }
            ++i;
        }
        return docsToDelete;
    }

    private Map<String, String[]> addNewDocuments(IProgressMonitor pm, Collection<URL> newDocs, boolean opened) throws IndexingException {
        Map<String, String[]> prebuiltDocs = this.mergeIndexes(pm, opened);
        this.checkCancelled(pm);
        Collection<URL> docsToIndex = this.calculateDocsToAdd(newDocs, prebuiltDocs);
        this.checkCancelled(pm);
        Map<String, String[]> docsToDelete = this.calculateNewToRemove(newDocs, prebuiltDocs);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)(10 * docsToIndex.size() + docsToDelete.size()));
        this.checkCancelled(pm);
        this.addDocuments((IProgressMonitor)subMonitor.split(10 * docsToIndex.size()), docsToIndex, docsToDelete.size() == 0);
        this.checkCancelled(pm);
        this.removeNewDocuments((IProgressMonitor)subMonitor.split(docsToDelete.size()), docsToDelete);
        pm.done();
        return docsToDelete;
    }

    private Collection<URL> calculateDocsToAdd(Collection<URL> newDocs, Map<String, String[]> prebuiltDocs) {
        Collection<URL> docsToIndex = null;
        int newDocSize = newDocs.size();
        if (prebuiltDocs.size() > 0) {
            docsToIndex = new HashSet<URL>(newDocs);
            for (String href : prebuiltDocs.keySet()) {
                URL u = SearchIndex.getIndexableURL(this.index.getLocale(), href);
                if (u == null) continue;
                docsToIndex.remove(u);
            }
        } else {
            docsToIndex = newDocs;
        }
        if (HelpPlugin.DEBUG_SEARCH) {
            System.out.println("Building search index-  new docs: " + newDocSize + ", preindexed: " + prebuiltDocs.size() + ", remaining: " + docsToIndex.size());
        }
        return docsToIndex;
    }

    private void removeNewDocuments(IProgressMonitor pm, Map<String, String[]> docsToDelete) throws IndexingException {
        pm = new LazyProgressMonitor((IProgressMonitor)pm);
        pm.beginTask("", docsToDelete.size());
        this.checkCancelled((IProgressMonitor)pm);
        Set<String> keysToDelete = docsToDelete.keySet();
        if (keysToDelete.size() > 0) {
            if (!this.index.beginRemoveDuplicatesBatch()) {
                throw new IndexingException();
            }
            MultiStatus multiStatus = null;
            for (String href : keysToDelete) {
                String[] indexIds = docsToDelete.get(href);
                if (indexIds == null) {
                    this.index.removeDocument(href);
                    continue;
                }
                IStatus status = this.index.removeDuplicates(href, indexIds);
                if (status.getCode() != 0) {
                    if (multiStatus == null) {
                        multiStatus = new MultiStatus("org.eclipse.help.base", 2, "Some help documents could not removed from index.", null);
                    }
                    multiStatus.add(status);
                }
                this.checkCancelled((IProgressMonitor)pm);
                pm.worked(1);
                if (multiStatus == null) continue;
                HelpBasePlugin.logStatus((IStatus)multiStatus);
            }
            if (!this.index.endRemoveDuplicatesBatch()) {
                throw new IndexingException();
            }
        }
        pm.done();
    }

    private void addDocuments(IProgressMonitor pm, Collection<URL> addedDocs, boolean lastOperation) throws IndexingException {
        pm = new LazyProgressMonitor((IProgressMonitor)pm);
        pm.beginTask("", addedDocs.size());
        this.checkCancelled((IProgressMonitor)pm);
        pm.subTask(HelpBaseResources.UpdatingIndex);
        MultiStatus multiStatus = null;
        for (URL doc : addedDocs) {
            IStatus status = this.index.addDocument(this.getName(doc), doc);
            if (status.getCode() != 0) {
                if (multiStatus == null) {
                    multiStatus = new MultiStatus("org.eclipse.help.base", 4, "Help documentation could not be indexed completely.", null);
                }
                multiStatus.add(status);
            }
            this.checkCancelled((IProgressMonitor)pm);
            pm.worked(1);
        }
        if (multiStatus != null) {
            HelpBasePlugin.logStatus(multiStatus);
        }
        pm.subTask(HelpBaseResources.Writing_index);
        if (!this.index.endAddBatch(addedDocs.size() > 0, lastOperation)) {
            throw new IndexingException();
        }
        pm.done();
    }

    private void removeStaleDocuments(IProgressMonitor pm, Collection<URL> removedDocs) throws IndexingException {
        pm = new LazyProgressMonitor((IProgressMonitor)pm);
        pm.beginTask("", removedDocs.size());
        pm.subTask(HelpBaseResources.Preparing_for_indexing);
        this.checkCancelled((IProgressMonitor)pm);
        if (this.numRemoved > 0) {
            if (!this.index.beginDeleteBatch()) {
                throw new IndexingException();
            }
            this.checkCancelled((IProgressMonitor)pm);
            pm.subTask(HelpBaseResources.UpdatingIndex);
            MultiStatus multiStatus = null;
            for (URL doc : removedDocs) {
                IStatus status = this.index.removeDocument(this.getName(doc));
                if (status.getCode() != 0) {
                    if (multiStatus == null) {
                        multiStatus = new MultiStatus("org.eclipse.help.base", 2, "Uninstalled or updated help documents could not be removed from index.", null);
                    }
                    multiStatus.add(status);
                }
                this.checkCancelled((IProgressMonitor)pm);
                pm.worked(1);
            }
            if (multiStatus != null) {
                HelpBasePlugin.logStatus(multiStatus);
            }
            if (!this.index.endDeleteBatch()) {
                throw new IndexingException();
            }
        }
        pm.done();
    }

    private String getName(URL doc) {
        String name = doc.getFile();
        int i = name.indexOf(63);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    private Collection<String> getAddedPlugins(SearchIndex index) {
        Collection<String> addedPlugins = index.getDocPlugins().getAdded();
        if (addedPlugins == null || addedPlugins.isEmpty()) {
            return new ArrayList<String>(0);
        }
        return addedPlugins;
    }

    private Collection<URL> getAddedDocuments(SearchIndex index) {
        Collection<String> addedPlugins = this.getAddedPlugins(index);
        if (HelpPlugin.DEBUG_SEARCH) {
            this.traceAddedContributors(addedPlugins);
        }
        Set<String> urls = this.getAllDocuments(index.getLocale());
        HashSet<URL> addedDocs = new HashSet<URL>(urls.size());
        for (String doc : urls) {
            URL url;
            int i;
            String plugin;
            if (doc.startsWith("//")) {
                doc = doc.substring(1);
            }
            String string = plugin = (i = doc.indexOf(47, 1)) == -1 ? "" : doc.substring(1, i);
            if (!addedPlugins.contains(plugin) || (url = SearchIndex.getIndexableURL(index.getLocale(), doc)) == null) continue;
            addedDocs.add(url);
        }
        SearchParticipant[] participants = BaseHelpSystem.getLocalSearchManager().getGlobalParticipants();
        int j = 0;
        while (j < participants.length) {
            block10: {
                Set<String> set;
                String participantId;
                try {
                    participantId = participants[j].getId();
                }
                catch (Throwable t) {
                    HelpBasePlugin.logError("Failed to get help search participant id for: " + participants[j].getClass().getName() + "; skipping this one.", t);
                    break block10;
                }
                try {
                    set = participants[j].getAllDocuments(index.getLocale());
                }
                catch (Throwable t) {
                    HelpBasePlugin.logError("Failed to retrieve documents from one of the help search participants: " + participants[j].getClass().getName() + "; skipping this one.", t);
                    break block10;
                }
                for (String doc : set) {
                    URL url;
                    int i;
                    String plugin;
                    String id = null;
                    int qloc = doc.indexOf(63);
                    if (qloc != -1) {
                        String query = doc.substring(qloc + 1);
                        doc = doc.substring(0, qloc);
                        HashMap<String, Object> arguments = new HashMap<String, Object>();
                        HelpURLConnection.parseQuery(query, arguments);
                        id = (String)arguments.get("id");
                    }
                    String string = plugin = (i = doc.indexOf(47, 1)) == -1 ? "" : doc.substring(1, i);
                    if (!addedPlugins.contains(plugin) || (url = SearchIndex.getIndexableURL(index.getLocale(), doc, id, participantId)) == null) continue;
                    addedDocs.add(url);
                }
            }
            ++j;
        }
        return addedDocs;
    }

    private void traceAddedContributors(Collection<String> addedContributors) {
        for (String id : addedContributors) {
            System.out.println("Updating search index for contributor :" + id);
        }
    }

    private Collection<URL> getRemovedDocuments(SearchIndex index) {
        Collection<String> removedPlugins = index.getDocPlugins().getRemoved();
        if (removedPlugins == null || removedPlugins.isEmpty()) {
            return new ArrayList<URL>(0);
        }
        HelpProperties indexedDocs = index.getIndexedDocs();
        HashSet<URL> removedDocs = new HashSet<URL>(indexedDocs.size());
        for (String string : indexedDocs.keySet()) {
            URL url;
            String plugin;
            int i = string.indexOf(47, 1);
            String string2 = plugin = i == -1 ? "" : string.substring(1, i);
            if (!removedPlugins.contains(plugin) || (url = SearchIndex.getIndexableURL(index.getLocale(), string)) == null) continue;
            removedDocs.add(url);
        }
        return removedDocs;
    }

    private void add(ITopic topic, Set<String> hrefs) {
        String href = topic.getHref();
        this.add(href, hrefs);
        ITopic[] subtopics = topic.getSubtopics();
        int i = 0;
        while (i < subtopics.length) {
            this.add(subtopics[i], hrefs);
            ++i;
        }
    }

    private void add(String href, Set<String> hrefs) {
        if (!(href == null || href.equals("") || href.startsWith("http://") || href.startsWith("https://"))) {
            hrefs.add(href);
        }
    }

    private Set<String> getAllDocuments(String locale) {
        HashSet<String> hrefs = new HashSet<String>();
        Toc[] tocs = this.index.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            ITopic[] topics = tocs[i].getTopics();
            int j = 0;
            while (j < topics.length) {
                this.add(topics[j], hrefs);
                ++j;
            }
            ITocContribution contrib = tocs[i].getTocContribution();
            String[] extraDocs = contrib.getExtraDocuments();
            int j2 = 0;
            while (j2 < extraDocs.length) {
                this.add(extraDocs[j2], hrefs);
                ++j2;
            }
            ITopic tocDescriptionTopic = tocs[i].getTopic(null);
            if (tocDescriptionTopic != null) {
                this.add(tocDescriptionTopic, hrefs);
            }
            ++i;
        }
        return hrefs;
    }

    private PrebuiltIndexes getIndexesToAdd(Collection<String> pluginIds) {
        PrebuiltIndexes indexes = new PrebuiltIndexes(this.index);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.help.toc");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement elem = elements[i];
            try {
                String pluginId;
                if (elem.getName().equals(ELEMENT_NAME_INDEX) && pluginIds.contains(pluginId = elem.getNamespaceIdentifier())) {
                    String path = elem.getAttribute(ATTRIBUTE_NAME_PATH);
                    if (path != null) {
                        indexes.add(pluginId, path);
                        if (HelpPlugin.DEBUG_SEARCH) {
                            System.out.println("Search index for " + pluginId + " is prebuilt with path \"" + path + '\"');
                        }
                    } else {
                        String msg = "Element \"index\" in extension of \"org.eclipse.help.toc\" must specify a \"path\" attribute (plug-in: " + pluginId + ")";
                        HelpBasePlugin.logError(msg, null);
                    }
                }
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                // empty catch block
            }
            ++i;
        }
        return indexes;
    }

    private Map<String, String[]> mergeIndexes(IProgressMonitor monitor, boolean opened) throws IndexingException {
        Collection<String> addedPluginIds = this.getAddedPlugins(this.index);
        PrebuiltIndexes indexes = this.getIndexesToAdd(addedPluginIds);
        PluginIndex[] pluginIndexes = indexes.getIndexes();
        Map<String, String[]> mergedDocs = null;
        if (!this.index.beginAddBatch(opened)) {
            throw new IndexingException();
        }
        if (pluginIndexes.length > 0) {
            mergedDocs = this.index.merge(pluginIndexes, monitor);
        }
        if (mergedDocs == null) {
            return Collections.EMPTY_MAP;
        }
        return mergedDocs;
    }

    public class IndexingException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

