/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.QueryWordsExactPhrase;
import org.eclipse.help.internal.search.QueryWordsPhrase;
import org.eclipse.help.internal.search.QueryWordsToken;

public class QueryBuilder {
    private static final int MAX_TERMS = 10;
    private static final int MAX_UNIONS = 4;
    private static final int MAX_WILD_TERMS = 2;
    private String searchWords;
    private AnalyzerDescriptor analyzerDesc;
    private Analyzer analyzer;
    private List<QueryWordsToken> analyzedTokens;
    private List<String> highlightWords = new ArrayList<String>();
    private Locale locale;

    public QueryBuilder(String searchWords, AnalyzerDescriptor analyzerDesc) {
        this.searchWords = searchWords;
        String language = analyzerDesc.getLang();
        this.locale = language.length() >= 5 ? new Locale(language.substring(0, 2), language.substring(3, 5)) : new Locale(language.substring(0, 2), "");
        this.analyzerDesc = analyzerDesc;
        this.analyzer = analyzerDesc.getAnalyzer();
    }

    private List<QueryWordsToken> tokenizeUserQuery(String searchWords) {
        ArrayList<QueryWordsToken> tokenList = new ArrayList<QueryWordsToken>();
        boolean withinQuotation = false;
        String quotedString = "";
        int termCount = 0;
        int fromIndex = -1;
        searchWords = searchWords.trim();
        while ((fromIndex = searchWords.indexOf("\"", fromIndex + 1)) != -1) {
            boolean bl = withinQuotation = !withinQuotation;
        }
        if (withinQuotation) {
            searchWords = String.valueOf(searchWords) + "\"";
            withinQuotation = !withinQuotation;
        }
        StringTokenizer qTokenizer = new StringTokenizer(searchWords, "\"", true);
        int orCount = 0;
        while (qTokenizer.hasMoreTokens()) {
            String curToken = qTokenizer.nextToken();
            if (curToken.equals("\"")) {
                if (withinQuotation) {
                    if (BaseHelpSystem.getMode() == 1 && ++termCount > 10) {
                        throw new QueryTooComplexException();
                    }
                    tokenList.add(QueryWordsToken.exactPhrase(quotedString));
                } else {
                    quotedString = "";
                }
                withinQuotation = !withinQuotation;
                continue;
            }
            if (withinQuotation) {
                quotedString = curToken;
                continue;
            }
            StringTokenizer parser = new StringTokenizer(curToken.trim());
            while (parser.hasMoreTokens()) {
                String token = parser.nextToken();
                if (token.equalsIgnoreCase(QueryWordsToken.AND().value)) {
                    tokenList.add(QueryWordsToken.AND());
                    continue;
                }
                if (token.equalsIgnoreCase(QueryWordsToken.OR().value)) {
                    if (BaseHelpSystem.getMode() == 1 && ++orCount > 4) {
                        throw new QueryTooComplexException();
                    }
                    tokenList.add(QueryWordsToken.OR());
                    continue;
                }
                if (token.equalsIgnoreCase(QueryWordsToken.NOT().value)) {
                    tokenList.add(QueryWordsToken.NOT());
                    continue;
                }
                if (BaseHelpSystem.getMode() == 1 && ++termCount > 10) {
                    throw new QueryTooComplexException();
                }
                tokenList.add(QueryWordsToken.word(token));
            }
        }
        return tokenList;
    }

    private List<QueryWordsToken> analyzeTokens(List<QueryWordsToken> tokens) {
        boolean isTokenAfterNot = false;
        ArrayList<QueryWordsToken> newTokens = new ArrayList<QueryWordsToken>();
        int wildCardTermCount = 0;
        int i = 0;
        while (i < tokens.size()) {
            QueryWordsToken token = tokens.get(i);
            if (token.type == 5) {
                int questionMIndex = token.value.indexOf(63);
                int starIndex = token.value.indexOf(42);
                if (starIndex >= 0 || questionMIndex >= 0) {
                    if (BaseHelpSystem.getMode() == 1 && ++wildCardTermCount > 2) {
                        throw new QueryTooComplexException();
                    }
                    newTokens.add(QueryWordsToken.word(token.value.toLowerCase(this.locale)));
                    if (!isTokenAfterNot && !this.highlightWords.contains(token.value)) {
                        this.highlightWords.add(token.value);
                    }
                } else {
                    List<String> wordList = this.analyzeText(this.analyzer, "contents", token.value);
                    if (wordList.size() > 0) {
                        if (!isTokenAfterNot && !this.highlightWords.contains(token.value)) {
                            this.highlightWords.add(token.value);
                        }
                        if (wordList.size() == 1) {
                            String word = wordList.get(0);
                            newTokens.add(QueryWordsToken.word(word));
                            if (!isTokenAfterNot && !this.highlightWords.contains(word)) {
                                this.highlightWords.add(word);
                            }
                        } else {
                            QueryWordsPhrase phrase = QueryWordsToken.phrase();
                            for (String word : wordList) {
                                phrase.addWord(word);
                                if (this.analyzerDesc.getId().startsWith("org.eclipse.help.base#") || isTokenAfterNot || this.highlightWords.contains(word)) continue;
                                this.highlightWords.add(word);
                            }
                            newTokens.add(phrase);
                        }
                    }
                }
            } else if (token.type == 1 || token.type == 2) {
                newTokens.add(token);
            } else if (token.type == 3) {
                List<String> wordList = this.analyzeText(this.analyzer, "exact_contents", token.value);
                if (wordList.size() > 0 && !isTokenAfterNot && !this.highlightWords.contains(token.value)) {
                    this.highlightWords.add(token.value);
                }
                QueryWordsExactPhrase phrase = QueryWordsToken.exactPhrase();
                for (String word : wordList) {
                    phrase.addWord(word);
                    if (this.highlightWords.contains(word)) continue;
                    this.highlightWords.add(word);
                }
                if (phrase.getWords().size() > 0) {
                    newTokens.add(phrase);
                }
            }
            isTokenAfterNot = token.type == 2;
            ++i;
        }
        return newTokens;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> analyzeText(Analyzer analyzer, String fieldName, String text) {
        ArrayList<String> words = new ArrayList<String>(1);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                StringReader reader = new StringReader(text);
                try {
                    try (TokenStream tStream = analyzer.tokenStream(fieldName, (Reader)reader);){
                        tStream.reset();
                        CharTermAttribute termAttribute = (CharTermAttribute)tStream.getAttribute(CharTermAttribute.class);
                        while (tStream.incrementToken()) {
                            String term = termAttribute.toString();
                            words.add(term);
                        }
                    }
                    if (reader == null) return words;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (reader == null) throw throwable;
                    ((Reader)reader).close();
                    throw throwable;
                }
                ((Reader)reader).close();
                return words;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return words;
    }

    private Query createLuceneQuery(List<QueryWordsToken> searchTokens, String[] fieldNames, float[] boosts) {
        List<Query> requiredQueries = this.getRequiredQueries(searchTokens, fieldNames, boosts);
        if (requiredQueries.size() == 0) {
            return null;
        }
        if (requiredQueries.size() <= 1) {
            return requiredQueries.get(0);
        }
        return this.orQueries(requiredQueries);
    }

    private List<Query> getRequiredQueries(List<QueryWordsToken> tokens, String[] fieldNames, float[] boosts) {
        ArrayList<Query> oredQueries = new ArrayList<Query>();
        ArrayList<QueryWordsToken> requiredQueryTokens = new ArrayList<QueryWordsToken>();
        int i = 0;
        while (i < tokens.size()) {
            QueryWordsToken token = tokens.get(i);
            if (token.type != 1) {
                requiredQueryTokens.add(token);
            } else {
                Query reqQuery = this.getRequiredQuery(requiredQueryTokens, fieldNames, boosts);
                if (reqQuery != null) {
                    oredQueries.add(reqQuery);
                }
                requiredQueryTokens = new ArrayList();
            }
            ++i;
        }
        Query reqQuery = this.getRequiredQuery(requiredQueryTokens, fieldNames, boosts);
        if (reqQuery != null) {
            oredQueries.add(reqQuery);
        }
        return oredQueries;
    }

    private Query orQueries(Collection<Query> queries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Query q : queries) {
            builder.add(q, BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    private Query getRequiredQuery(List<QueryWordsToken> requiredTokens, String[] fieldNames, float[] boosts) {
        BooleanQuery.Builder retQueryBuilder = new BooleanQuery.Builder();
        boolean requiredTermExist = false;
        QueryWordsToken operator = null;
        int i = 0;
        while (i < requiredTokens.size()) {
            QueryWordsToken token = requiredTokens.get(i);
            if (token.type == 0 || token.type == 2) {
                operator = token;
            } else {
                Query[] qs = new Query[fieldNames.length];
                int f = 0;
                while (f < fieldNames.length) {
                    qs[f] = token.createLuceneQuery(fieldNames[f], boosts[f]);
                    ++f;
                }
                Query q = qs[0];
                if (fieldNames.length > 1) {
                    BooleanQuery.Builder allFieldsQueryBuilder = new BooleanQuery.Builder();
                    int f2 = 0;
                    while (f2 < fieldNames.length) {
                        allFieldsQueryBuilder.add(qs[f2], BooleanClause.Occur.SHOULD);
                        ++f2;
                    }
                    q = allFieldsQueryBuilder.build();
                }
                if (operator != null && operator.type == 2) {
                    retQueryBuilder.add(q, BooleanClause.Occur.MUST_NOT);
                } else {
                    retQueryBuilder.add(q, BooleanClause.Occur.MUST);
                    requiredTermExist = true;
                }
            }
            ++i;
        }
        if (!requiredTermExist) {
            return null;
        }
        return retQueryBuilder.build();
    }

    private Query getLuceneQuery(String[] fieldNames, float[] boosts) {
        Query luceneQuery = this.createLuceneQuery(this.analyzedTokens, fieldNames, boosts);
        return luceneQuery;
    }

    public Query getLuceneQuery(Collection<String> fieldNames, boolean fieldSearchOnly) throws QueryTooComplexException {
        List<QueryWordsToken> userTokens = this.tokenizeUserQuery(this.searchWords);
        this.analyzedTokens = this.analyzeTokens(userTokens);
        return this.buildLuceneQuery(fieldNames, fieldSearchOnly);
    }

    private Query buildLuceneQuery(Collection<String> fieldNames, boolean fieldSearchOnly) {
        Iterator<String> fieldNamesIt;
        float[] boosts;
        String[] fields;
        if (fieldSearchOnly) {
            fields = new String[fieldNames.size()];
            boosts = new float[fieldNames.size()];
            fieldNamesIt = fieldNames.iterator();
            int i = 0;
            while (i < fieldNames.size()) {
                fields[i] = fieldNamesIt.next();
                boosts[i] = 5.0f;
                ++i;
            }
        } else {
            fields = new String[fieldNames.size() + 2];
            boosts = new float[fieldNames.size() + 2];
            fieldNamesIt = fieldNames.iterator();
            int i = 0;
            while (i < fieldNames.size()) {
                fields[i] = fieldNamesIt.next();
                boosts[i] = 5.0f;
                ++i;
            }
            fields[fieldNames.size()] = "contents";
            boosts[fieldNames.size()] = 1.0f;
            fields[fieldNames.size() + 1] = "title";
            boosts[fieldNames.size() + 1] = 1.0f;
        }
        Query query = this.getLuceneQuery(fields, boosts);
        query = this.improveRankingForUnqotedPhrase(query, fields, boosts);
        return query;
    }

    private Query improveRankingForUnqotedPhrase(Query query, String[] fields, float[] boosts) {
        if (query == null) {
            return query;
        }
        int i = 0;
        while (i < this.analyzedTokens.size()) {
            if (this.analyzedTokens.get((int)i).type != 5) {
                return query;
            }
            ++i;
        }
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        booleanQueryBuilder.add(query, BooleanClause.Occur.SHOULD);
        PhraseQuery.Builder[] phraseQueriesBuilders = new PhraseQuery.Builder[fields.length];
        int f = 0;
        while (f < fields.length) {
            phraseQueriesBuilders[f] = new PhraseQuery.Builder();
            int i2 = 0;
            while (i2 < this.analyzedTokens.size()) {
                Term t = new Term(fields[f], this.analyzedTokens.get((int)i2).value);
                phraseQueriesBuilders[f].add(t);
                ++i2;
            }
            BoostQuery boostQuery = new BoostQuery((Query)phraseQueriesBuilders[f].build(), 10.0f * boosts[f]);
            booleanQueryBuilder.add((Query)boostQuery, BooleanClause.Occur.SHOULD);
            ++f;
        }
        return booleanQueryBuilder.build();
    }

    public String gethighlightTerms() {
        StringBuffer buf = new StringBuffer();
        Iterator<String> it = this.highlightWords.iterator();
        while (it.hasNext()) {
            buf.append('\"');
            buf.append(it.next());
            buf.append("\" ");
        }
        return buf.toString();
    }
}

