/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.TizenButton;
import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class TizenAbstractButtonRenderer {
    protected TizenButton parent = null;
    protected Composite parentComposite = null;
    protected static final int MARGIN = 5;
    protected static final int MOUSE_LEFT = 1;
    protected static final int MOUSE_RIGHT = 3;
    protected boolean isFocus = false;
    protected boolean isSelection = false;
    protected boolean isEnable = true;
    protected static boolean isFocusByKeyInput = false;
    protected boolean isDefaultButton = false;
    protected boolean isGrayed = false;

    TizenAbstractButtonRenderer(TizenButton parent, Composite parentComposite) {
        this.parent = parent;
        this.parentComposite = parentComposite;
        this.parent.getAttribute().setFont(TizenResourceManager.NORMAL_FONT);
    }

    protected Point computeSize(TizenButton button, int wHint, int hHint, boolean changed) {
        this.parent = button;
        Point sizeOfTextAndImages = this.computeSizeOfTextAndImages();
        return new Point(10 + sizeOfTextAndImages.x, 10 + sizeOfTextAndImages.y + 2);
    }

    private Point computeSizeOfTextAndImages() {
        boolean hasImage;
        boolean hasText;
        int width = 0;
        int height = 0;
        boolean bl = hasText = this.parent.getText() != null && !this.parent.getText().isEmpty();
        if (hasText) {
            GC gc = new GC(this.parent);
            Point extent = gc.stringExtent(this.parent.getText());
            gc.dispose();
            width += extent.x;
            height = extent.y;
        }
        boolean bl2 = hasImage = this.parent.getImage() != null;
        if (hasImage) {
            Rectangle rect = this.parent.getImage().getBounds();
            width += rect.width;
            height = Math.max(rect.height, height);
            if (hasText) {
                width += 5;
            }
        }
        return new Point(width + 10, height);
    }

    protected boolean isHover() {
        Point cursorLocationOfDisplay = Display.getCurrent().getCursorLocation();
        Point cursorLocationOfWidget = this.parent.getParent().toControl(cursorLocationOfDisplay);
        return this.parent.getBounds().contains(cursorLocationOfWidget);
    }

    protected boolean isFocus() {
        return this.isFocus;
    }

    protected void setEnabled(boolean enabled) {
        this.isEnable = enabled;
    }

    protected void setDefaultButtonListener(boolean enable) {
    }

    protected void checkTypeButtonPressed() {
    }

    protected void setGrayed(boolean grayed) {
    }

    protected boolean getGrayed() {
        return false;
    }

    protected void setFocusByKeyInput(boolean isFocusFromTabKey) {
        isFocusByKeyInput = isFocusFromTabKey;
    }

    protected boolean isFocusByKeyInput() {
        return isFocusByKeyInput;
    }

    protected boolean isActiveDefaultButton() {
        return false;
    }

    protected abstract void drawButton(Event var1);

    protected abstract Listener getMouseListener();

    protected abstract void setBackground(Color var1);

    protected abstract void setForeground(Color var1);

    protected abstract void setSelection(boolean var1);

    protected abstract boolean getSelection();

    protected abstract boolean setFocus();

    protected abstract boolean removeFocus();
}

