/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.ArrayList;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TizenAbstractButtonRenderer;
import org.eclipse.swt.custom.TizenButton;
import org.eclipse.swt.custom.TizenButtonAttribute;
import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TizenPushButtonRenderer
extends TizenAbstractButtonRenderer {
    protected boolean isButtonPressed = false;
    protected int state = 0;
    protected static final int STATE_NORMAL = 0;
    protected static final int STATE_HOVER = 1;
    protected static final int STATE_PRESSED = 2;
    protected static final int STATE_DIMMED = 3;
    private static int eventEnterKeyTime = 0;

    TizenPushButtonRenderer(TizenButton parent, Composite parentComposite) {
        super(parent, parentComposite);
        this.setPushButtonDefaultColors();
    }

    private void setPushButtonDefaultColors() {
        this.setBackgroundColors(TizenResourceManager.PUSH_BUTTON_NORMAL_BG_COLOR, TizenResourceManager.PUSH_BUTTON_PRESSED_BG_COLOR, TizenResourceManager.PUSH_BUTTON_HOVER_BG_COLOR, TizenResourceManager.PUSH_BUTTON_DIMMED_BG_COLOR);
        this.setforegroundColors(TizenResourceManager.PUSH_BUTTON_NORMAL_FONT_COLOR, TizenResourceManager.PUSH_BUTTON_PRESSED_FONT_COLOR, TizenResourceManager.PUSH_BUTTON_HOVER_FONT_COLOR, TizenResourceManager.PUSH_BUTTON_DIMMED_FONT_COLOR);
        this.setLineColors(TizenResourceManager.PUSH_BUTTON_OUTLINE_NORMAL_COLOR, TizenResourceManager.PUSH_BUTTON_OUTLINE_PRESSED_COLOR, TizenResourceManager.PUSH_BUTTON_OUTLINE_HOVER_COLOR, TizenResourceManager.PUSH_BUTTON_OUTLINE_DIMMED_COLOR);
    }

    private void setBackgroundColors(Color normal, Color push, Color hover, Color disable) {
        this.parent.getAttribute().setBackgroundColors(0, normal);
        this.parent.getAttribute().setBackgroundColors(2, push);
        this.parent.getAttribute().setBackgroundColors(1, hover);
        this.parent.getAttribute().setBackgroundColors(3, disable);
    }

    private void setforegroundColors(Color normal, Color push, Color hover, Color disable) {
        this.parent.getAttribute().setForegroundColors(0, normal);
        this.parent.getAttribute().setForegroundColors(2, push);
        this.parent.getAttribute().setForegroundColors(1, hover);
        this.parent.getAttribute().setForegroundColors(3, disable);
    }

    private void setLineColors(Color normal, Color push, Color hover, Color disable) {
        this.parent.getAttribute().setBorderColors(0, normal);
        this.parent.getAttribute().setBorderColors(2, push);
        this.parent.getAttribute().setBorderColors(1, hover);
        this.parent.getAttribute().setBorderColors(3, disable);
    }

    @Override
    protected void setBackground(Color color) {
        this.setBackgroundColors(color, TizenResourceManager.PUSH_BUTTON_PRESSED_BG_COLOR, TizenResourceManager.PUSH_BUTTON_HOVER_BG_COLOR, TizenResourceManager.PUSH_BUTTON_DIMMED_BG_COLOR);
    }

    @Override
    protected void setForeground(Color color) {
        this.setforegroundColors(color, TizenResourceManager.PUSH_BUTTON_PRESSED_FONT_COLOR, TizenResourceManager.PUSH_BUTTON_HOVER_FONT_COLOR, TizenResourceManager.PUSH_BUTTON_DIMMED_FONT_COLOR);
        this.setLineColors(color, TizenResourceManager.PUSH_BUTTON_OUTLINE_PRESSED_COLOR, TizenResourceManager.PUSH_BUTTON_OUTLINE_HOVER_COLOR, TizenResourceManager.PUSH_BUTTON_OUTLINE_DIMMED_COLOR);
    }

    @Override
    protected void setSelection(boolean selected) {
        this.isSelection = selected;
        this.parent.redraw();
    }

    @Override
    protected boolean getSelection() {
        return this.isSelection;
    }

    @Override
    protected void setEnabled(boolean enabled) {
        this.isEnable = enabled;
        this.parent.redraw();
    }

    @Override
    protected boolean setFocus() {
        this.isFocus = true;
        this.redrawAllButton();
        return true;
    }

    @Override
    protected boolean removeFocus() {
        this.isFocus = false;
        this.isButtonPressed = false;
        this.redrawAllButton();
        return false;
    }

    private void redrawAllButton() {
        ArrayList<Button> buttonList = this.parent.getPushButtonInWindow();
        for (Button button : buttonList) {
            button.redraw();
        }
    }

    private Control getFocusedWidget() {
        return Display.getCurrent().getFocusControl();
    }

    @Override
    protected boolean isFocus() {
        Control control = this.getFocusedWidget();
        if (control == null) {
            return false;
        }
        if (!(control instanceof Button)) {
            return false;
        }
        Button button = (Button)control;
        if (!button.isEqualsType(button.getStyle(), 8)) {
            return false;
        }
        return button == this.parent;
    }

    private Button getFocusedPushButton() {
        Control control = this.getFocusedWidget();
        if (control == null) {
            return null;
        }
        if (!(control instanceof Button)) {
            return null;
        }
        Button button = (Button)control;
        if (!button.isEqualsType(button.getStyle(), 8)) {
            return null;
        }
        return button;
    }

    @Override
    protected boolean isActiveDefaultButton() {
        if (!this.isDefaultButton) {
            return false;
        }
        if (!this.isEnable) {
            return false;
        }
        Button button = this.getFocusedPushButton();
        if (button == this.parent) {
            return true;
        }
        return button == null || !this.isFocusByKeyInput();
    }

    @Override
    public Listener getMouseListener() {
        return new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 6: 
                    case 32: {
                        if (!TizenPushButtonRenderer.this.isEnable) break;
                        TizenPushButtonRenderer.this.parent.redraw();
                        TizenPushButtonRenderer.this.parent.update();
                        break;
                    }
                    case 7: {
                        if (!TizenPushButtonRenderer.this.isEnable) break;
                        TizenPushButtonRenderer.this.isButtonPressed = false;
                        TizenPushButtonRenderer.this.parent.redraw();
                        TizenPushButtonRenderer.this.parent.update();
                        break;
                    }
                    case 3: {
                        if (!TizenPushButtonRenderer.this.isEnable) break;
                        if (event.button == 3) {
                            TizenPushButtonRenderer.this.parent.setFocus();
                        } else {
                            TizenPushButtonRenderer.this.isButtonPressed = true;
                        }
                        TizenPushButtonRenderer.this.setFocusByKeyInput(true);
                        TizenPushButtonRenderer.this.parent.redraw();
                        TizenPushButtonRenderer.this.parent.update();
                        break;
                    }
                    case 4: {
                        if (event.button == 3) {
                            return;
                        }
                        if (!TizenPushButtonRenderer.this.isButtonPressed) break;
                        TizenPushButtonRenderer.this.isButtonPressed = false;
                        if (!TizenPushButtonRenderer.this.isHover()) break;
                        TizenPushButtonRenderer.this.parent.redraw();
                        TizenPushButtonRenderer.this.parent.update();
                        TizenPushButtonRenderer.this.parent.fireSelectionEvent();
                        break;
                    }
                    case 9: {
                        TizenPushButtonRenderer.this.drawButton(event);
                    }
                }
            }
        };
    }

    @Override
    protected void setDefaultButtonListener(boolean enable) {
        this.isDefaultButton = enable;
        this.parent.getShell().addTraverseListener(new TraverseListener(){

            @Override
            public void keyTraversed(TraverseEvent event) {
                if (TizenPushButtonRenderer.this.parent.isDisposed()) {
                    return;
                }
                switch (event.character) {
                    case '\r': {
                        if (TizenPushButtonRenderer.this.isFocus()) {
                            return;
                        }
                        if (!TizenPushButtonRenderer.this.isActiveDefaultButton()) {
                            return;
                        }
                        if (eventEnterKeyTime == event.time) {
                            return;
                        }
                        eventEnterKeyTime = event.time;
                        if (event.widget instanceof StyledText) {
                            return;
                        }
                        event.doit = false;
                        TizenPushButtonRenderer.this.parent.fireSelectionEvent();
                    }
                }
            }
        });
    }

    private void updateStateForDraw() {
        this.state = !this.isEnable ? 3 : (this.isEnable && this.isButtonPressed ? 2 : (this.isEnable && this.isHover() ? 1 : 0));
    }

    private void updateFocusOfDefaultButton() {
        if (Display.getCurrent().getActiveShell() == null) {
            return;
        }
        Control control = this.getFocusedWidget();
        if (control != null) {
            return;
        }
        ArrayList<Button> buttonList = this.parent.getPushButtonInWindow();
        for (Button button : buttonList) {
            if (!button.isDefaultButton() || !button.isEnabled()) continue;
            button.setFocus();
            return;
        }
    }

    @Override
    protected void drawButton(Event e) {
        this.updateStateForDraw();
        this.updateFocusOfDefaultButton();
        TizenButton me = (TizenButton)e.widget;
        Rectangle rect = me.getClientArea();
        this.drawBackground(e.gc, rect, this.parent.getAttribute());
        this.drawButtonImage(e.gc, rect, this.parent.getAttribute());
        this.drawIcon(e.gc, rect, this.parent.getAttribute());
        this.drawButtonText(e.gc, rect, this.parent.getAttribute());
        this.drawBorder(e.gc, rect, this.parent.getAttribute());
        this.drawFocusedLine(e.gc, rect, this.parent.getAttribute());
    }

    private void drawFocusedLine(GC gc, Rectangle rect, TizenButtonAttribute attr) {
        if (this.isEnable && this.isFocus() && !this.isButtonPressed) {
            gc.setForeground(TizenResourceManager.PUSH_BUTTON_FOCUSED_LIEN_COLOR);
            gc.setLineWidth(1);
            gc.setLineStyle(2);
            int startX = 3;
            int startY = 3;
            int endX = rect.width - 4;
            int endY = rect.height - 4;
            gc.drawLine(startX, startY, endX, startY);
            gc.drawLine(startX, endY, endX, endY);
            gc.drawLine(endX, startY, endX, endY);
            gc.drawLine(startX, startY, startX, endY);
        }
    }

    private void drawBorder(GC gc, Rectangle rect, TizenButtonAttribute attr) {
        if (this.isEnable && this.isFocus() && isFocusByKeyInput) {
            this.drawHighlightBorder(gc, rect, this.parent.getAttribute());
        } else if (this.isActiveDefaultButton() && this.parent.isEnabled()) {
            this.drawHighlightBorder(gc, rect, this.parent.getAttribute());
        } else {
            this.drawNormalBorder(gc, rect, this.parent.getAttribute());
        }
    }

    private void drawIcon(GC gc, Rectangle parentRect, TizenButtonAttribute attr) {
        Image icon = attr.getIcon();
        if (icon == null) {
            return;
        }
        gc.drawImage(icon, parentRect.x + 2, parentRect.height / 2 - icon.getBounds().height / 2);
    }

    protected void drawBackground(GC gc, Rectangle rect, TizenButtonAttribute attr) {
        if (attr == null || attr.getBackgroundColors(this.state) == null) {
            return;
        }
        gc.setBackground(attr.getBackgroundColors(this.state));
        gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    private void drawNormalBorder(GC gc, Rectangle rect, TizenButtonAttribute attr) {
        if (attr == null) {
            return;
        }
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        if (attr.getBorderColors(this.state) != null) {
            gc.setForeground(attr.getBorderColors(this.state));
        } else if (this.parent.getForeground() != null) {
            gc.setForeground(this.parent.getForeground());
        } else {
            gc.setForeground(TizenResourceManager.BLACK_COLOR);
        }
        gc.drawRectangle(r);
    }

    private void drawHighlightBorder(GC gc, Rectangle rect, TizenButtonAttribute attr) {
        if (attr == null) {
            return;
        }
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        gc.setForeground(TizenResourceManager.PUSH_BUTTON_DEFAULT_FONT_COLOR);
        gc.drawRectangle(r);
        Rectangle ir = new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
        gc.setForeground(TizenResourceManager.PUSH_BUTTON_OUTLINE_DEFAULT_COLOR);
        gc.drawRectangle(ir);
    }

    private void drawButtonImage(GC gc, Rectangle rect, TizenButtonAttribute attr) {
        Point textP;
        if (attr == null || attr.getImage() == null) {
            return;
        }
        Image img = attr.getImage();
        if (img.isDisposed()) {
            return;
        }
        Rectangle imgRect = img.getBounds();
        int x = 0;
        int y = 0;
        Point p = attr.getButtonImagePoint();
        if (p == null) {
            int width = rect.width - imgRect.width;
            int height = rect.height - imgRect.height;
            if (width > 0) {
                x = width / 2;
            }
            if (height > 0) {
                y = height / 2;
            }
        } else {
            x = p.x;
            y = p.y;
        }
        if ((textP = this.getTextDrawPoint(gc, rect, attr)) != null) {
            x = textP.x - imgRect.width - 5;
        }
        int alpha = 255;
        if (this.state == 3) {
            alpha = 100;
        }
        gc.setAlpha(alpha);
        gc.drawImage(img, x, y);
    }

    private Point getTextDrawPoint(GC gc, Rectangle rect, TizenButtonAttribute attr) {
        if (attr == null || attr.getText() == null) {
            return null;
        }
        String text = attr.getText();
        Rectangle textRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        if (attr.getImage() != null) {
            Rectangle iconRect = attr.getImage().getBounds();
            textRect.x += iconRect.width;
            textRect.width -= iconRect.width;
        }
        if (attr.getFont() != null) {
            gc.setFont(attr.getFont());
        }
        int x = 0;
        int y = 0;
        int offset = 0;
        Point p = null;
        if (attr.getFontPoint() == null) {
            p = gc.textExtent(text, 8);
            if (attr.getAlign() == 0x1000000) {
                x = (textRect.width - p.x) / 2 + textRect.x;
                x = x < 0 ? 0 : x;
                offset = 0;
            } else {
                x = textRect.x;
                offset = 2;
            }
            y = (textRect.height - p.y) / 2;
        } else {
            p = attr.getFontPoint();
            x = p.x;
            y = p.y;
        }
        return new Point(x + offset, y);
    }

    private void drawButtonText(GC gc, Rectangle rect, TizenButtonAttribute attr) {
        if (attr == null || attr.getText() == null) {
            return;
        }
        if (attr.getForegroundColors(this.state) != null) {
            gc.setForeground(attr.getForegroundColors(this.state));
        } else if (this.parentComposite.getForeground() != null) {
            gc.setForeground(this.parentComposite.getForeground());
        } else {
            gc.setForeground(TizenResourceManager.BLACK_COLOR);
        }
        Point p = this.getTextDrawPoint(gc, rect, attr);
        gc.setAlpha(255);
        gc.drawString(attr.getText(), p.x, p.y, true);
    }
}

