/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.actions;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptValue;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.EvaluationManager;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;

public abstract class EvaluateAction
implements IEditorActionDelegate,
IObjectActionDelegate,
IActionDelegate2,
IViewActionDelegate,
IWorkbenchWindowActionDelegate,
IHandler {
    private IRegion region = null;
    private IWorkbenchPart targetpart = null;
    private IWorkbenchWindow window = null;
    private IAction action = null;
    private Object selection = null;
    private IJavaScriptValue value = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        IJavaScriptStackFrame frame = this.getStackFrameContext();
        if (frame != null) {
            this.resolveSelection();
            this.setValue(frame.evaluate(this.getSelection().toString()));
            this.showResult(this.getValue());
        }
    }

    protected abstract void showResult(IJavaScriptValue var1);

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
    }

    public void init(IAction action) {
        this.setAction(action);
    }

    public void init(IViewPart view) {
        this.setTargetpart((IWorkbenchPart)view);
    }

    public void init(IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.setTargetpart(window.getActivePage().getActivePart());
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setTargetpart(targetPart);
        this.setAction(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setTargetpart((IWorkbenchPart)targetEditor);
        this.setAction(action);
    }

    protected void resolveSelection() {
        ISelection sel = this.getTargetSelection();
        this.setRegion(null);
        if (sel instanceof ITextSelection) {
            IEditorPart editor;
            ITextSelection ts = (ITextSelection)sel;
            String text = ts.getText();
            if (text.trim().length() > 0) {
                this.setSelection(text);
                this.setRegion((IRegion)new Region(ts.getOffset(), ts.getLength()));
            } else if (this.getTargetPart() instanceof IEditorPart && (editor = (IEditorPart)this.getTargetPart()) instanceof ITextEditor) {
                this.setSelection(this.resolveText(null, ts, editor));
            }
        } else {
            boolean cfr_ignored_0 = sel instanceof IStructuredSelection;
        }
    }

    String resolveText(String text, ITextSelection ts, IEditorPart editor) {
        ITextEditor textEditor = (ITextEditor)editor;
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.region = JavaWordFinder.findWord((IDocument)doc, (int)ts.getOffset());
        if (this.region != null) {
            try {
                return doc.get(this.region.getOffset(), this.region.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return text;
    }

    protected ISelection getTargetSelection() {
        ISelectionProvider provider;
        IWorkbenchPart part = this.getTargetPart();
        if (part != null && (provider = part.getSite().getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    protected IJavaScriptStackFrame getStackFrameContext() {
        IWorkbenchPart part = this.getTargetPart();
        IJavaScriptStackFrame frame = null;
        frame = part == null ? EvaluationManager.getManager().getEvaluationContext(this.getWindow()) : EvaluationManager.getManager().getEvaluationContext(part);
        return frame;
    }

    protected void setValue(IJavaScriptValue value) {
        this.value = value;
    }

    protected IJavaScriptValue getValue() {
        return this.value;
    }

    protected void setSelection(Object obj) {
        this.selection = obj;
    }

    protected Object getSelection() {
        return this.selection;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.targetpart;
    }

    protected void setTargetpart(IWorkbenchPart targetpart) {
        this.targetpart = targetpart;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.window = window;
    }

    protected IRegion getRegion() {
        return this.region;
    }

    protected void setRegion(IRegion region) {
        this.region = region;
    }

    protected IAction getAction() {
        return this.action;
    }

    protected void setAction(IAction action) {
        this.action = action;
    }

    protected StyledText getStyledText(IWorkbenchPart part) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITextViewer viewer = (ITextViewer)part.getAdapter((Class)clazz);
        StyledText textWidget = null;
        if (viewer == null) {
            Control control;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.swt.widgets.Control");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((control = (Control)part.getAdapter((Class)clazz2)) instanceof StyledText) {
                textWidget = (StyledText)control;
            }
        } else {
            textWidget = viewer.getTextWidget();
        }
        return textWidget;
    }

    protected Point getPopupAnchor(StyledText textWidget) {
        if (textWidget != null) {
            Point docRange = textWidget.getSelectionRange();
            int midOffset = docRange.x + docRange.y / 2;
            Point point = textWidget.getLocationAtOffset(midOffset);
            point = textWidget.toDisplay(point);
            GC gc = new GC((Drawable)textWidget);
            gc.setFont(textWidget.getFont());
            int height = gc.getFontMetrics().getHeight();
            gc.dispose();
            point.y += height;
            return point;
        }
        return null;
    }
}

