/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.LoggedCreateTargetChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.LoggedCreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.MonitoringCreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.NullReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public final class JavaMoveProcessor
extends MoveProcessor
implements IScriptableRefactoring,
ICommentProvider,
IQualifiedNameUpdating,
IReorgDestinationValidator {
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.MoveProcessor";
    private String fComment;
    private ICreateTargetQueries fCreateTargetQueries;
    private IReorgPolicy.IMovePolicy fMovePolicy;
    private IReorgQueries fReorgQueries;
    private boolean fWasCanceled;

    public JavaMoveProcessor(IReorgPolicy.IMovePolicy policy) {
        this.fMovePolicy = policy;
    }

    public boolean canChildrenBeDestinations(IJavaScriptElement javaElement) {
        return this.fMovePolicy.canChildrenBeDestinations(javaElement);
    }

    public boolean canChildrenBeDestinations(IResource resource) {
        return this.fMovePolicy.canChildrenBeDestinations(resource);
    }

    public boolean canElementBeDestination(IJavaScriptElement javaElement) {
        return this.fMovePolicy.canElementBeDestination(javaElement);
    }

    public boolean canElementBeDestination(IResource resource) {
        return this.fMovePolicy.canElementBeDestination(resource);
    }

    public boolean canEnableComment() {
        return true;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return this.fMovePolicy.canEnableQualifiedNameUpdating();
    }

    public boolean canUpdateQualifiedNames() {
        return this.fMovePolicy.canUpdateQualifiedNames();
    }

    public boolean canUpdateReferences() {
        return this.fMovePolicy.canUpdateReferences();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            Assert.isNotNull((Object)this.fReorgQueries);
            this.fWasCanceled = false;
            return this.fMovePolicy.checkFinalConditions(pm, context, this.fReorgQueries);
        }
        catch (OperationCanceledException e) {
            this.fWasCanceled = true;
            throw e;
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(this.fMovePolicy.getResources()))));
            IResource[] javaResources = ReorgUtils.getResources(this.fMovePolicy.getJavaElements());
            result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        Assert.isTrue((this.fMovePolicy.getJavaElementDestination() == null || this.fMovePolicy.getResourceDestination() == null ? 1 : 0) != 0);
        Assert.isTrue((this.fMovePolicy.getJavaElementDestination() != null || this.fMovePolicy.getResourceDestination() != null ? 1 : 0) != 0);
        try {
            Change change;
            MonitoringCreateTargetQueries queries;
            ICreateTargetQueries delegate;
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.JavaMoveProcessor_change_name){

                public ChangeDescriptor getDescriptor() {
                    return JavaMoveProcessor.this.fMovePolicy.getDescriptor();
                }

                public Change perform(IProgressMonitor pm2) throws CoreException {
                    Change change = super.perform(pm2);
                    Change[] changes = this.getChildren();
                    int index = 0;
                    while (index < changes.length) {
                        if (!(changes[index] instanceof TextEditBasedChange)) {
                            return null;
                        }
                        ++index;
                    }
                    return change;
                }
            };
            CreateTargetExecutionLog log = null;
            if (this.fCreateTargetQueries instanceof MonitoringCreateTargetQueries && (delegate = (queries = (MonitoringCreateTargetQueries)this.fCreateTargetQueries).getDelegate()) instanceof LoggedCreateTargetQueries) {
                log = queries.getCreateTargetExecutionLog();
            }
            if (log != null) {
                Object[] selected = log.getSelectedElements();
                int index = 0;
                while (index < selected.length) {
                    result.add(new LoggedCreateTargetChange(selected[index], this.fCreateTargetQueries));
                    ++index;
                }
            }
            if ((change = this.fMovePolicy.createChange(pm)) instanceof CompositeChange) {
                CompositeChange subComposite = (CompositeChange)change;
                result.merge(subComposite);
            } else {
                result.add(change);
            }
            DynamicValidationStateChange dynamicValidationStateChange = result;
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = JavaProcessors.computeAffectedNaturs(this.fMovePolicy.getJavaElements());
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fMovePolicy.getResources());
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    public String getComment() {
        return this.fComment;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fMovePolicy.getResources(), this.fMovePolicy.getJavaElements()).getCommonParent();
    }

    public ICreateTargetQuery getCreateTargetQuery() {
        return this.fMovePolicy.getCreateTargetQuery(this.fCreateTargetQueries);
    }

    protected Object getDestination() {
        IJavaScriptElement je = this.fMovePolicy.getJavaElementDestination();
        if (je != null) {
            return je;
        }
        return this.fMovePolicy.getResourceDestination();
    }

    public Object[] getElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(this.fMovePolicy.getJavaElements()));
        result.addAll(Arrays.asList(this.fMovePolicy.getResources()));
        return result.toArray();
    }

    public String getFilePatterns() {
        return this.fMovePolicy.getFilePatterns();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public IJavaScriptElement[] getJavaElements() {
        return this.fMovePolicy.getJavaElements();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.MoveRefactoring_0;
    }

    public IResource[] getResources() {
        return this.fMovePolicy.getResources();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fMovePolicy.getUpdateQualifiedNames();
    }

    public boolean getUpdateReferences() {
        if (!this.canUpdateReferences()) {
            return false;
        }
        return this.fMovePolicy.getUpdateReferences();
    }

    public boolean hasAllInputSet() {
        return this.fMovePolicy.hasAllInputSet();
    }

    public boolean hasDestinationSet() {
        return this.fMovePolicy.getJavaElementDestination() != null || this.fMovePolicy.getResourceDestination() != null;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        this.setReorgQueries(new NullReorgQueries());
        RefactoringStatus status = new RefactoringStatus();
        if (arguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            this.fMovePolicy = ReorgPolicyFactory.createMovePolicy(status, arguments);
            if (this.fMovePolicy != null && !status.hasFatalError()) {
                CreateTargetExecutionLog log = ReorgPolicyFactory.loadCreateTargetExecutionLog(status, extended);
                if (log != null && !status.hasFatalError()) {
                    this.fMovePolicy.setDestinationCheck(false);
                    this.fCreateTargetQueries = new MonitoringCreateTargetQueries(new LoggedCreateTargetQueries(log), log);
                }
                status.merge(this.fMovePolicy.initialize(arguments));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return status;
    }

    public boolean isApplicable() throws CoreException {
        return this.fMovePolicy.canEnable();
    }

    public boolean isTextualMove() {
        return this.fMovePolicy.isTextualMove();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fMovePolicy.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        return this.fMovePolicy.postCreateChange(participantChanges, pm);
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public void setCreateTargetQueries(ICreateTargetQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fCreateTargetQueries = new MonitoringCreateTargetQueries(queries, this.fMovePolicy.getCreateTargetExecutionLog());
    }

    public RefactoringStatus setDestination(IJavaScriptElement destination) throws JavaScriptModelException {
        return this.fMovePolicy.setDestination(destination);
    }

    public RefactoringStatus setDestination(IResource destination) throws JavaScriptModelException {
        return this.fMovePolicy.setDestination(destination);
    }

    public void setFilePatterns(String patterns) {
        this.fMovePolicy.setFilePatterns(patterns);
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fReorgQueries = queries;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fMovePolicy.setUpdateQualifiedNames(update);
    }

    public void setUpdateReferences(boolean update) {
        this.fMovePolicy.setUpdateReferences(update);
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }
}

