/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintOperator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintVariableFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ExpressionVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.FullConstraintCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.SimpleTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.TypeConstraintFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.TypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;

public class ChangeTypeRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_TYPE = "type";
    private final Map fConstraintCache;
    private int fSelectionStart;
    private int fSelectionLength;
    private int fEffectiveSelectionStart;
    private int fEffectiveSelectionLength;
    private IJavaScriptUnit fCu;
    private IFunctionBinding fMethodBinding;
    private int fParamIndex;
    private String fParamName;
    private IVariableBinding fFieldBinding;
    private IJavaScriptUnit[] fAffectedUnits;
    private Collection fRelevantVars;
    private final Collection fValidTypes;
    private Collection fRelevantConstraints;
    private Collection fAllConstraints;
    private String fSelectedTypeName;
    private ITypeBinding fSelectedType;
    private Map fCuToSearchResultGroup = new HashMap();
    private ITypeBinding fObject;
    private static final boolean DEBUG = false;
    private ConstraintVariable fCv;
    private IBinding fSelectionBinding;
    private ITypeBinding fSelectionTypeBinding;
    private ConstraintCollector fCollector;

    public ITypeBinding getObject() {
        return this.fObject;
    }

    public ChangeTypeRefactoring(IJavaScriptUnit cu, int selectionStart, int selectionLength) {
        this(cu, selectionStart, selectionLength, null);
    }

    public ChangeTypeRefactoring(IJavaScriptUnit cu, int selectionStart, int selectionLength, String selectedType) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fEffectiveSelectionStart = selectionStart;
        this.fEffectiveSelectionLength = selectionLength;
        this.fCu = cu;
        if (selectedType != null) {
            this.fSelectedTypeName = selectedType;
        }
        this.fConstraintCache = new HashMap();
        this.fValidTypes = new HashSet();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fCu == null || !this.fCu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_invalidSelection);
        }
        return this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 1));
    }

    private void setSelectionRanges(Expression exp) {
        this.fEffectiveSelectionStart = exp.getStartPosition();
        this.fEffectiveSelectionLength = exp.getLength();
        this.fSelectionBinding = ExpressionVariable.resolveBinding(exp);
        this.setOriginalType(exp.resolveTypeBinding());
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaScriptModelException {
        try {
            IFunction selectedMethod;
            pm.beginTask("", 5);
            ASTNode node = this.getTargetNode(this.fCu, this.fSelectionStart, this.fSelectionLength);
            TypeConstraintFactory typeConstraintFactory = new TypeConstraintFactory(){

                public boolean filter(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator o) {
                    if (o.isStrictSubtypeOperator()) {
                        return true;
                    }
                    if (v1.getBinding() != null && v2.getBinding() != null && !Bindings.equals((IBinding)v1.getBinding(), (IBinding)ChangeTypeRefactoring.this.fSelectionTypeBinding) && !Bindings.equals((IBinding)v2.getBinding(), (IBinding)ChangeTypeRefactoring.this.fSelectionTypeBinding)) {
                        return true;
                    }
                    return super.filter(v1, v2, o);
                }
            };
            this.fCollector = new ConstraintCollector(new FullConstraintCreator(new ConstraintVariableFactory(), typeConstraintFactory));
            String selectionValid = this.determineSelection(node);
            if (selectionValid != null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)selectionValid);
                return refactoringStatus;
            }
            if (this.fMethodBinding != null && (selectedMethod = (IFunction)this.fMethodBinding.getJavaElement()) == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_insideLocalTypesNotSupported);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            if (this.fSelectionTypeBinding.isArray()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported);
                return refactoringStatus;
            }
            if (this.fSelectionTypeBinding.isPrimitive()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_primitivesNotSupported);
                return refactoringStatus;
            }
            if (this.checkOverriddenBinaryMethods()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnBinary);
                return refactoringStatus;
            }
            if (this.fSelectionTypeBinding.isLocal()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_localTypesNotSupported);
                return refactoringStatus;
            }
            if (this.fFieldBinding != null && this.fFieldBinding.getDeclaringClass().isLocal()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeTypeRefactoring_insideLocalTypesNotSupported);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.fSelectedType != null) {
                this.computeValidTypes((IProgressMonitor)new NullProgressMonitor());
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private boolean checkOverriddenBinaryMethods() throws JavaScriptModelException {
        if (this.fMethodBinding != null) {
            Set declaringSupertypes = ChangeTypeRefactoring.getDeclaringSuperTypes(this.fMethodBinding);
            for (ITypeBinding superType : declaringSupertypes) {
                IFunctionBinding overriddenMethod = ChangeTypeRefactoring.findMethod(this.fMethodBinding, superType);
                Assert.isNotNull((Object)overriddenMethod);
                IFunction iMethod = (IFunction)overriddenMethod.getJavaElement();
                if (!iMethod.isBinary()) continue;
                return true;
            }
        }
        return false;
    }

    private static IFunctionBinding findMethod(IFunctionBinding methodBinding, ITypeBinding type) {
        if (methodBinding.getDeclaringClass().equals((Object)type)) {
            return methodBinding;
        }
        return Bindings.findOverriddenMethodInType(type, methodBinding);
    }

    private static Set getDeclaringSuperTypes(IFunctionBinding methodBinding) {
        ITypeBinding[] allSuperTypes = Bindings.getAllSuperTypes(methodBinding.getDeclaringClass());
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        int i = 0;
        while (i < allSuperTypes.length) {
            ITypeBinding type = allSuperTypes[i];
            if (ChangeTypeRefactoring.findMethod(methodBinding, type) != null) {
                result.add(type);
            }
            ++i;
        }
        return result;
    }

    public Collection computeValidTypes(IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_checking_preconditions, 100);
        try {
            this.fCv = this.findConstraintVariableForSelectedNode((IProgressMonitor)new SubProgressMonitor(pm, 3));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fRelevantVars = this.findRelevantConstraintVars(this.fCv, (IProgressMonitor)new SubProgressMonitor(pm, 50));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fRelevantConstraints = this.findRelevantConstraints(this.fRelevantVars, (IProgressMonitor)new SubProgressMonitor(pm, 30));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fValidTypes.addAll(this.computeValidTypes(this.fSelectionTypeBinding, this.fRelevantVars, this.fRelevantConstraints, (IProgressMonitor)new SubProgressMonitor(pm, 20)));
        }
        catch (CoreException e) {
            JavaScriptPlugin.logErrorMessage("Error occurred during computation of valid types: " + e.toString());
            this.fValidTypes.clear();
        }
        pm.done();
        return this.fValidTypes;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_checking_preconditions, 1);
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fAffectedUnits), this.getValidationContext());
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeMessages_CreateChangesForChangeType, 1);
        try {
            HashMap relevantVarsByUnit = new HashMap();
            this.groupChangesByCompilationUnit(relevantVarsByUnit);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaScriptProject javaProject = this.fCu.getJavaScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            String description = RefactoringCoreMessages.ChangeTypeRefactoring_descriptor_description_short;
            String header = Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel(this.fSelectionBinding, 2235681801344L), BindingLabelProvider.getBindingLabel((IBinding)this.fSelectedType, 2235681801344L)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_original_element_pattern, BindingLabelProvider.getBindingLabel(this.fSelectionBinding, 2235681801344L)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_original_type_pattern, BindingLabelProvider.getBindingLabel((IBinding)this.getOriginalType(), 2235681801344L)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_refactored_type_pattern, BindingLabelProvider.getBindingLabel((IBinding)this.fSelectedType, 2235681801344L)));
            JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.change.type", project, description, comment.asString(), arguments, 786434);
            arguments.put("input", descriptor.elementToHandle((IJavaScriptElement)this.fCu));
            arguments.put("selection", String.valueOf(Integer.valueOf(this.fSelectionStart).toString()) + " " + Integer.valueOf(this.fSelectionLength).toString());
            arguments.put(ATTRIBUTE_TYPE, this.fSelectedType.getQualifiedName());
            DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.ChangeTypeRefactoring_allChanges);
            for (IJavaScriptUnit icu : relevantVarsByUnit.keySet()) {
                Set cVars = (Set)relevantVarsByUnit.get(icu);
                CompilationUnitChange cuChange = new CompilationUnitChange(this.getName(), icu);
                this.addAllChangesFor(icu, cVars, cuChange);
                result.add((Change)cuChange);
                pm.worked(1);
                if (!pm.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = result;
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
        }
    }

    private void addAllChangesFor(IJavaScriptUnit icu, Set vars, CompilationUnitChange unitChange) throws CoreException {
        JavaScriptUnit unit = new RefactoringASTParser(3).parse((ITypeRoot)icu, false);
        ASTRewrite unitRewriter = ASTRewrite.create((AST)unit.getAST());
        MultiTextEdit root = new MultiTextEdit();
        unitChange.setEdit((TextEdit)root);
        String typeName = this.updateImports(unit, root);
        this.updateCu(unit, vars, unitChange, unitRewriter, typeName);
        root.addChild(unitRewriter.rewriteAST());
    }

    private void updateCu(JavaScriptUnit unit, Set vars, CompilationUnitChange unitChange, ASTRewrite unitRewriter, String typeName) throws JavaScriptModelException {
        unitRewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SourceRangeComputer());
        for (ConstraintVariable cv : vars) {
            ASTNode decl = this.findDeclaration(unit, cv);
            if ((decl instanceof SimpleName || decl instanceof QualifiedName) && cv instanceof ExpressionVariable) {
                ASTNode gp = decl.getParent().getParent();
                this.updateType(unit, ChangeTypeRefactoring.getType(gp), unitChange, unitRewriter, typeName);
                continue;
            }
            if (!(decl instanceof FunctionDeclaration) && !(decl instanceof FieldDeclaration)) continue;
            this.updateType(unit, ChangeTypeRefactoring.getType(decl), unitChange, unitRewriter, typeName);
        }
    }

    private void updateType(JavaScriptUnit cu, Type oldType, CompilationUnitChange unitChange, ASTRewrite unitRewriter, String typeName) {
        String oldName = this.fSelectionTypeBinding.getName();
        String description = Messages.format(RefactoringCoreMessages.ChangeTypeRefactoring_typeChange, new String[]{oldName, typeName});
        TextEditGroup gd = new TextEditGroup(description);
        AST ast = cu.getAST();
        Type nodeToReplace = oldType;
        Assert.isTrue((boolean)this.fSelectedType.isClass());
        SimpleType newType = ast.newSimpleType(ASTNodeFactory.newName(ast, typeName));
        unitRewriter.replace((ASTNode)nodeToReplace, (ASTNode)newType, gd);
        unitChange.addTextEditGroup(gd);
    }

    private void groupChangesByCompilationUnit(Map relevantVarsByUnit) throws JavaScriptModelException {
        for (ConstraintVariable cv : this.fRelevantVars) {
            if (!(cv instanceof ExpressionVariable) && !(cv instanceof ReturnTypeVariable)) continue;
            IJavaScriptUnit icu = null;
            if (cv instanceof ExpressionVariable) {
                ExpressionVariable ev = (ExpressionVariable)cv;
                icu = ev.getCompilationUnitRange().getCompilationUnit();
            } else if (cv instanceof ReturnTypeVariable) {
                ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
                IFunctionBinding mb = rtv.getMethodBinding();
                icu = ((IFunction)mb.getJavaElement()).getJavaScriptUnit();
            }
            if (!relevantVarsByUnit.containsKey(icu)) {
                relevantVarsByUnit.put(icu, new HashSet());
            }
            ((Set)relevantVarsByUnit.get(icu)).add(cv);
        }
    }

    private ASTNode findDeclaration(JavaScriptUnit root, ConstraintVariable cv) throws JavaScriptModelException {
        if (this.fFieldBinding != null) {
            IField f = (IField)this.fFieldBinding.getJavaElement();
            return ASTNodeSearchUtil.getFieldDeclarationNode(f, root);
        }
        if (cv instanceof ExpressionVariable) {
            for (ITypeConstraint constraint : this.fAllConstraints) {
                ConstraintVariable right;
                SimpleTypeConstraint stc;
                if (!constraint.isSimpleTypeConstraint() || !(stc = (SimpleTypeConstraint)constraint).isDefinesConstraint() || !stc.getLeft().equals(cv) || !((right = stc.getRight()) instanceof TypeVariable)) continue;
                TypeVariable typeVariable = (TypeVariable)right;
                return NodeFinder.perform((ASTNode)root, typeVariable.getCompilationUnitRange().getSourceRange());
            }
        } else if (cv instanceof ReturnTypeVariable) {
            ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
            IFunctionBinding mb = rtv.getMethodBinding();
            IFunction im = (IFunction)mb.getJavaElement();
            return ASTNodeSearchUtil.getMethodDeclarationNode(im, root);
        }
        return null;
    }

    private static Type getType(ASTNode node) {
        switch (node.getNodeType()) {
            case 44: {
                return ((SingleVariableDeclaration)node).getType();
            }
            case 23: {
                return ((FieldDeclaration)node).getType();
            }
            case 60: {
                return ((VariableDeclarationStatement)node).getType();
            }
            case 31: {
                return ((FunctionDeclaration)node).getReturnType2();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.ChangeTypeRefactoring_name;
    }

    private String determineSelection(ASTNode node) {
        if (node == null) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_invalidSelection;
        }
        ASTNode parent = node.getParent();
        ASTNode grandParent = parent.getParent();
        if (grandParent == null) {
            return ChangeTypeRefactoring.nodeTypeNotSupported();
        }
        ASTNode current = null;
        if (node.getNodeType() == 40) {
            current = node;
            while (current.getNodeType() == 40) {
                current = current.getParent();
            }
            if (current.getNodeType() != 43) {
                return ChangeTypeRefactoring.nodeTypeNotSupported();
            }
            node = current.getParent();
        } else if (parent.getNodeType() == 40) {
            current = parent;
            while (current.getNodeType() == 40) {
                current = current.getParent();
            }
            if (current.getNodeType() != 43) {
                return ChangeTypeRefactoring.nodeTypeNotSupported();
            }
            node = current.getParent();
        }
        this.fObject = node.getAST().resolveWellKnownType("java.lang.Object");
        switch (node.getNodeType()) {
            case 42: {
                return this.simpleNameSelected((SimpleName)node);
            }
            case 60: {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)node);
            }
            case 23: {
                return this.fieldDeclarationSelected((FieldDeclaration)node);
            }
            case 44: {
                return this.singleVariableDeclarationSelected((SingleVariableDeclaration)node);
            }
        }
        return ChangeTypeRefactoring.nodeTypeNotSupported();
    }

    private static String nodeTypeNotSupported() {
        return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
    }

    private String singleVariableDeclarationSelected(SingleVariableDeclaration svd) {
        SimpleName name = svd.getName();
        this.setSelectionRanges((Expression)name);
        return this.simpleNameSelected(name);
    }

    private String variableDeclarationStatementSelected(VariableDeclarationStatement vds) {
        if (vds.fragments().size() != 1) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        VariableDeclarationFragment elem = (VariableDeclarationFragment)vds.fragments().iterator().next();
        SimpleName name = elem.getName();
        this.setSelectionRanges((Expression)name);
        return this.simpleNameSelected(name);
    }

    private String fieldDeclarationSelected(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration.fragments().size() != 1) {
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        VariableDeclarationFragment elem = (VariableDeclarationFragment)fieldDeclaration.fragments().iterator().next();
        this.fFieldBinding = elem.resolveBinding();
        SimpleName name = elem.getName();
        this.setSelectionRanges((Expression)name);
        return this.simpleNameSelected(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String simpleNameSelected(SimpleName simpleName) {
        ASTNode parent = simpleName.getParent();
        ASTNode grandParent = parent.getParent();
        if (parent.getNodeType() == 60) {
            VariableDeclarationStatement vds = (VariableDeclarationStatement)parent;
            if (vds.fragments().size() <= 1) return null;
            return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
        }
        if (parent.getNodeType() == 59) {
            if (grandParent.getNodeType() == 60) {
                VariableDeclarationStatement vds = (VariableDeclarationStatement)grandParent;
                if (vds.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else if (grandParent.getNodeType() == 58) {
                VariableDeclarationExpression vde = (VariableDeclarationExpression)grandParent;
                if (vde.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else {
                if (grandParent.getNodeType() != 23) return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
                FieldDeclaration fd = (FieldDeclaration)grandParent;
                if (fd.fragments().size() > 1) {
                    return RefactoringCoreMessages.ChangeTypeRefactoring_multiDeclarationsNotSupported;
                }
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)parent;
                this.fFieldBinding = fragment.resolveBinding();
                this.setSelectionRanges((Expression)fragment.getName());
            }
            return null;
        } else if (parent.getNodeType() == 44) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parent;
            if (grandParent.getNodeType() == 31) {
                this.fMethodBinding = ((FunctionDeclaration)grandParent).resolveBinding();
                this.setOriginalType(simpleName.resolveTypeBinding());
                this.fParamIndex = ((FunctionDeclaration)grandParent).parameters().indexOf(parent);
                this.fParamName = singleVariableDeclaration.getName().getIdentifier();
                return null;
            } else {
                this.setSelectionRanges((Expression)singleVariableDeclaration.getName());
            }
            return null;
        } else if (parent.getNodeType() == 43 && grandParent.getNodeType() == 44) {
            ASTNode greatGrandParent = grandParent.getParent();
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)grandParent;
            if (singleVariableDeclaration.getExtraDimensions() > 0) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported;
            }
            if (greatGrandParent != null && greatGrandParent.getNodeType() == 31) {
                this.fMethodBinding = ((FunctionDeclaration)greatGrandParent).resolveBinding();
                this.fParamIndex = ((FunctionDeclaration)greatGrandParent).parameters().indexOf(grandParent);
                this.fParamName = singleVariableDeclaration.getName().getIdentifier();
                this.setSelectionRanges((Expression)simpleName);
                return null;
            } else {
                this.setSelectionRanges((Expression)singleVariableDeclaration.getName());
            }
            return null;
        } else if (parent.getNodeType() == 43 && grandParent.getNodeType() == 31) {
            this.fMethodBinding = ((FunctionDeclaration)grandParent).resolveBinding();
            this.setOriginalType(this.fMethodBinding.getReturnType());
            this.fParamIndex = -1;
            return null;
        } else if (parent.getNodeType() == 31 && grandParent.getNodeType() == 55) {
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)parent;
            if (methodDeclaration.getName().equals((Object)simpleName) || methodDeclaration.thrownExceptions().contains(simpleName)) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
            }
            this.fMethodBinding = ((FunctionDeclaration)parent).resolveBinding();
            this.fParamIndex = -1;
            return null;
        } else {
            if (parent.getNodeType() == 43 && grandParent.getNodeType() == 60) {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)grandParent);
            }
            if (parent.getNodeType() == 43 && grandParent.getNodeType() == 23) {
                return this.fieldDeclarationSelected((FieldDeclaration)grandParent);
            }
            if (parent.getNodeType() == 43 && grandParent.getNodeType() == 5) {
                return RefactoringCoreMessages.ChangeTypeRefactoring_arraysNotSupported;
            }
            if (parent.getNodeType() != 40) return RefactoringCoreMessages.ChangeTypeRefactoring_notSupportedOnNodeType;
            this.setSelectionRanges((Expression)simpleName);
        }
        return null;
    }

    private ConstraintVariable findConstraintVariableForSelectedNode(IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 100);
        IJavaScriptUnit[] cus = new IJavaScriptUnit[]{this.fCu};
        Collection allConstraints = this.getConstraints(cus, (IProgressMonitor)new SubProgressMonitor(pm, 50));
        SubProgressMonitor subMonitor = new SubProgressMonitor(pm, 50);
        subMonitor.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, allConstraints.size());
        Iterator it = allConstraints.iterator();
        while (it.hasNext()) {
            subMonitor.worked(1);
            ITypeConstraint tc = (ITypeConstraint)it.next();
            if (!(tc instanceof SimpleTypeConstraint)) continue;
            SimpleTypeConstraint stc = (SimpleTypeConstraint)tc;
            if (this.matchesSelection(stc.getLeft())) {
                return stc.getLeft();
            }
            if (!this.matchesSelection(stc.getRight())) continue;
            return stc.getRight();
        }
        subMonitor.done();
        pm.done();
        Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_noMatchingConstraintVariable);
        return null;
    }

    private boolean matchesSelection(ConstraintVariable cv) {
        if (cv instanceof ExpressionVariable) {
            ExpressionVariable ev = (ExpressionVariable)cv;
            return this.fSelectionBinding != null && Bindings.equals(this.fSelectionBinding, ev.getExpressionBinding());
        }
        if (cv instanceof ParameterTypeVariable) {
            ParameterTypeVariable ptv = (ParameterTypeVariable)cv;
            if (this.fMethodBinding != null && Bindings.equals((IBinding)ptv.getMethodBinding(), (IBinding)this.fMethodBinding) && ptv.getParameterIndex() == this.fParamIndex) {
                return true;
            }
        } else if (cv instanceof ReturnTypeVariable) {
            ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
            if (this.fMethodBinding != null && Bindings.equals((IBinding)rtv.getMethodBinding(), (IBinding)this.fMethodBinding) && this.fParamIndex == -1) {
                return true;
            }
        }
        return false;
    }

    private Collection findRelevantConstraintVars(ConstraintVariable cv, IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 150);
        HashSet<ConstraintVariable> result = new HashSet<ConstraintVariable>();
        result.add(cv);
        IJavaScriptUnit[] cus = this.collectAffectedUnits((IProgressMonitor)new SubProgressMonitor(pm, 50));
        Collection allConstraints = this.getConstraints(cus, (IProgressMonitor)new SubProgressMonitor(pm, 50));
        ArrayList<ConstraintVariable> workList = new ArrayList<ConstraintVariable>(result);
        while (!workList.isEmpty()) {
            pm.worked(10);
            ConstraintVariable first = (ConstraintVariable)workList.remove(0);
            Iterator iter = allConstraints.iterator();
            while (iter.hasNext()) {
                ConstraintVariable match;
                SimpleTypeConstraint stc;
                pm.worked(1);
                ITypeConstraint typeConstraint = (ITypeConstraint)iter.next();
                if (!typeConstraint.isSimpleTypeConstraint() || !(stc = (SimpleTypeConstraint)typeConstraint).isDefinesConstraint() && !stc.isEqualsConstraint() || !((match = ChangeTypeRefactoring.match(first, stc.getLeft(), stc.getRight())) instanceof ExpressionVariable) && !(match instanceof ParameterTypeVariable) && !(match instanceof ReturnTypeVariable) || result.contains(match)) continue;
                workList.add(match);
                result.add(match);
            }
        }
        pm.done();
        return result;
    }

    private static ConstraintVariable match(ConstraintVariable matchee, ConstraintVariable left, ConstraintVariable right) {
        if (matchee.equals(left)) {
            return right;
        }
        if (matchee.equals(right)) {
            return left;
        }
        return null;
    }

    private Collection findRelevantConstraints(Collection relevantConstraintVars, IProgressMonitor pm) throws CoreException {
        IJavaScriptUnit[] cus = this.collectAffectedUnits((IProgressMonitor)new SubProgressMonitor(pm, 100));
        this.fAllConstraints = this.getConstraints(cus, (IProgressMonitor)new SubProgressMonitor(pm, 900));
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 1000 + this.fAllConstraints.size());
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>();
        for (ITypeConstraint tc : this.fAllConstraints) {
            if (tc.isSimpleTypeConstraint()) {
                SimpleTypeConstraint stc = (SimpleTypeConstraint)tc;
                if (stc.isDefinesConstraint() || stc.isEqualsConstraint() || stc.getLeft().equals(stc.getRight()) || ChangeTypeRefactoring.isNull(stc.getLeft())) continue;
                if (relevantConstraintVars.contains(stc.getLeft()) || relevantConstraintVars.contains(stc.getRight())) {
                    result.add(tc);
                }
            } else {
                CompositeOrTypeConstraint cotc = (CompositeOrTypeConstraint)tc;
                ITypeConstraint[] components = cotc.getConstraints();
                int i = 0;
                while (i < components.length) {
                    ITypeConstraint component = components[i];
                    SimpleTypeConstraint simpleComponent = (SimpleTypeConstraint)component;
                    if (relevantConstraintVars.contains(simpleComponent.getLeft())) {
                        result.add(tc);
                    }
                    ++i;
                }
            }
            pm.worked(1);
        }
        pm.done();
        return result;
    }

    private static ASTNode findDeclaration(ASTNode root, int start, int length) {
        ASTNode node = NodeFinder.perform(root, start, length);
        Assert.isTrue((boolean)(node instanceof SimpleName), (String)String.valueOf(node.getNodeType()));
        Assert.isTrue((boolean)(root instanceof JavaScriptUnit), (String)String.valueOf(root.getNodeType()));
        return ((JavaScriptUnit)root).findDeclaringNode(((SimpleName)node).resolveBinding());
    }

    static String print(Collection types) {
        if (types.isEmpty()) {
            return "{ }";
        }
        StringBuilder result = new StringBuilder("{ ");
        Iterator it = types.iterator();
        while (it.hasNext()) {
            ITypeBinding type = (ITypeBinding)it.next();
            result.append(type.getQualifiedName());
            if (it.hasNext()) {
                result.append(',').append(' ');
                continue;
            }
            result.append(' ').append('}');
        }
        return result.toString();
    }

    private Collection computeValidTypes(ITypeBinding originalType, Collection relevantVars, Collection relevantConstraints, IProgressMonitor pm) throws JavaScriptModelException {
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        IJavaScriptProject project = this.fCu.getJavaScriptProject();
        HashSet allTypes = new HashSet();
        allTypes.addAll(this.getAllSuperTypes(originalType));
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, allTypes.size());
        for (ITypeBinding type : allTypes) {
            if (!this.isValid(project, type, relevantVars, relevantConstraints, (IProgressMonitor)new SubProgressMonitor(pm, 1))) continue;
            result.add(type);
        }
        result.remove(originalType);
        pm.done();
        return result;
    }

    private boolean isValid(IJavaScriptProject project, ITypeBinding type, Collection relevantVars, Collection constraints, IProgressMonitor pm) throws JavaScriptModelException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, constraints.size());
        for (ITypeConstraint tc : constraints) {
            if (tc instanceof SimpleTypeConstraint ? !this.isValidSimpleConstraint(project, type, relevantVars, (SimpleTypeConstraint)tc) : tc instanceof CompositeOrTypeConstraint && !this.isValidOrConstraint(project, type, relevantVars, (CompositeOrTypeConstraint)tc)) {
                return false;
            }
            pm.worked(1);
        }
        pm.done();
        return true;
    }

    private boolean isValidSimpleConstraint(IJavaScriptProject project, ITypeBinding type, Collection relevantVars, SimpleTypeConstraint stc) throws JavaScriptModelException {
        return !relevantVars.contains(stc.getLeft()) || this.isSubTypeOf(type, this.findType(stc.getRight()));
    }

    private boolean isValidOrConstraint(IJavaScriptProject project, ITypeBinding type, Collection relevantVars, CompositeOrTypeConstraint cotc) throws JavaScriptModelException {
        ITypeConstraint[] components = cotc.getConstraints();
        int i = 0;
        while (i < components.length) {
            SimpleTypeConstraint sc;
            if (components[i] instanceof SimpleTypeConstraint && (relevantVars.contains((sc = (SimpleTypeConstraint)components[i]).getLeft()) ? this.isSubTypeOf(type, this.findType(sc.getRight())) : relevantVars.contains(sc.getRight()) && this.isSubTypeOf(this.findType(sc.getLeft()), type))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ITypeBinding findType(ConstraintVariable cv) {
        return cv.getBinding();
    }

    private Collection getConstraints(IJavaScriptUnit[] referringCus, IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, referringCus.length);
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < referringCus.length) {
            result.addAll(this.getConstraints(referringCus[i]));
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private List getConstraints(IJavaScriptUnit unit) {
        if (this.fConstraintCache.containsKey(unit)) {
            return (List)this.fConstraintCache.get(unit);
        }
        JavaScriptUnit cu = ASTCreator.createAST(unit, null);
        if (this.fMethodBinding != null && this.fCuToSearchResultGroup.containsKey(unit)) {
            SearchResultGroup group = (SearchResultGroup)this.fCuToSearchResultGroup.get(unit);
            ASTNode[] nodes = ASTNodeSearchUtil.getAstNodes(group.getSearchResults(), cu);
            int i = 0;
            while (i < nodes.length) {
                ASTNode node = nodes[i];
                if (this.fMethodBinding != null) {
                    ASTNode n = node;
                    while (!(n instanceof FunctionDeclaration)) {
                        n = n.getParent();
                    }
                    FunctionDeclaration md = (FunctionDeclaration)n;
                    md.accept((ASTVisitor)this.fCollector);
                }
                ++i;
            }
        } else {
            cu.accept((ASTVisitor)this.fCollector);
        }
        List<ITypeConstraint> constraints = Arrays.asList(this.fCollector.getConstraints());
        this.fConstraintCache.put(unit, constraints);
        return constraints;
    }

    private String updateImports(JavaScriptUnit astRoot, MultiTextEdit rootEdit) throws CoreException {
        ImportRewrite rewrite = StubUtility.createImportRewrite(astRoot, true);
        String typeName = rewrite.addImport(this.fSelectedType.getQualifiedName());
        rootEdit.addChild(rewrite.rewriteImports(null));
        return typeName;
    }

    public Collection getValidTypes() {
        return this.fValidTypes;
    }

    public ITypeBinding getOriginalType() {
        return this.fSelectionTypeBinding;
    }

    private void setOriginalType(ITypeBinding originalType) {
        this.fSelectionTypeBinding = originalType;
        this.fSelectedType = this.findSuperTypeByName(originalType, this.fSelectedTypeName);
    }

    public String getTarget() {
        String typeName;
        String string = typeName = this.fSelectionTypeBinding == null ? "" : String.valueOf(this.fSelectionTypeBinding.getName()) + " ";
        if (this.fFieldBinding != null) {
            return String.valueOf(typeName) + this.fFieldBinding.getName();
        }
        if (this.fMethodBinding != null) {
            if (this.fParamIndex == -1) {
                return String.valueOf(typeName) + this.fMethodBinding.getName() + "(...)";
            }
            return String.valueOf(typeName) + this.fParamName;
        }
        if (this.fSelectionBinding != null) {
            return String.valueOf(typeName) + this.fSelectionBinding.getName();
        }
        return typeName;
    }

    public Collection getValidTypeNames() {
        ArrayList<String> typeNames = new ArrayList<String>();
        for (ITypeBinding type : this.fValidTypes) {
            typeNames.add(type.getQualifiedName());
        }
        return typeNames;
    }

    private ASTNode getTargetNode(IJavaScriptUnit unit, int offset, int length) {
        JavaScriptUnit root = ASTCreator.createAST(unit, null);
        ASTNode node = NodeFinder.perform((ASTNode)root, offset, length);
        return node;
    }

    private IJavaScriptUnit[] collectAffectedUnits(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeTypeRefactoring_analyzingMessage, 100);
        if (this.fAffectedUnits != null) {
            pm.worked(100);
            return this.fAffectedUnits;
        }
        if (this.fMethodBinding != null) {
            if (this.fMethodBinding != null) {
                IFunction selectedMethod = (IFunction)this.fMethodBinding.getJavaElement();
                if (selectedMethod == null) {
                    Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_no_method);
                }
                IFunction root = selectedMethod;
                IFunction[] rippleMethods = RippleMethodFinder2.getRelatedMethods(root, (IProgressMonitor)new SubProgressMonitor(pm, 15), null);
                SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaScriptElement[])rippleMethods, 3);
                IJavaScriptSearchScope scope = RefactoringScopeFactory.create((IJavaScriptElement)selectedMethod);
                CollectingSearchRequestor csr = new CollectingSearchRequestor();
                SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, null, scope, csr, (IProgressMonitor)new SubProgressMonitor(pm, 80), new RefactoringStatus());
                this.fAffectedUnits = this.getCus(groups);
            }
        } else if (this.fFieldBinding != null) {
            IField iField = (IField)this.fFieldBinding.getJavaElement();
            if (iField == null) {
                Assert.isTrue((boolean)false, (String)RefactoringCoreMessages.ChangeTypeRefactoring_no_filed);
            }
            SearchPattern pattern = SearchPattern.createPattern((IJavaScriptElement)iField, (int)3, (int)24);
            IJavaScriptSearchScope scope = RefactoringScopeFactory.create((IJavaScriptElement)iField);
            CollectingSearchRequestor csr = new CollectingSearchRequestor();
            SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, null, scope, csr, (IProgressMonitor)new SubProgressMonitor(pm, 100), new RefactoringStatus());
            this.fAffectedUnits = this.getCus(groups);
        } else {
            this.fAffectedUnits = new IJavaScriptUnit[]{this.fCu};
        }
        pm.done();
        return this.fAffectedUnits;
    }

    public void setSelectedType(ITypeBinding type) {
        this.fSelectedType = type;
    }

    private static boolean isNull(ConstraintVariable cv) {
        return cv instanceof ExpressionVariable && ((ExpressionVariable)cv).getExpressionType() == 33;
    }

    void printCollection(String title, Collection l) {
        System.out.println(String.valueOf(l.size()) + " " + title);
        Iterator it = l.iterator();
        while (it.hasNext()) {
            System.out.println("  " + it.next());
        }
    }

    private IJavaScriptUnit[] getCus(SearchResultGroup[] groups) {
        ArrayList<IJavaScriptUnit> result = new ArrayList<IJavaScriptUnit>(groups.length);
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            IJavaScriptUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.add(cu);
                this.fCuToSearchResultGroup.put(cu, group);
            }
            ++i;
        }
        return result.toArray(new IJavaScriptUnit[result.size()]);
    }

    public Set getAllSuperTypes(ITypeBinding type) {
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        result.add(type);
        if (type.getSuperclass() != null) {
            result.addAll(this.getAllSuperTypes(type.getSuperclass()));
        }
        if (type != this.fObject && !ChangeTypeRefactoring.contains(result, this.fObject)) {
            result.add(this.fObject);
        }
        return result;
    }

    private ITypeBinding findSuperTypeByName(ITypeBinding type, String superTypeName) {
        Set superTypes = this.getAllSuperTypes(type);
        for (ITypeBinding sup : superTypes) {
            if (!sup.getQualifiedName().equals(superTypeName)) continue;
            return sup;
        }
        return null;
    }

    public boolean isSubTypeOf(ITypeBinding type1, ITypeBinding type2) {
        Set superTypes = this.getAllSuperTypes(type1);
        return ChangeTypeRefactoring.contains(superTypes, type2);
    }

    private static boolean contains(Collection c, ITypeBinding binding) {
        for (ITypeBinding b : c) {
            if (!Bindings.equals((IBinding)b, (IBinding)binding)) continue;
            return true;
        }
        return false;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String type;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaScriptElement element;
            int length;
            int offset;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String selection = extended.getAttribute("selection");
            if (selection != null) {
                offset = -1;
                length = -1;
                StringTokenizer tokenizer = new StringTokenizer(selection);
                if (tokenizer.hasMoreTokens()) {
                    offset = Integer.valueOf(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    length = Integer.valueOf(tokenizer.nextToken());
                }
                if (offset < 0 || length < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = offset;
            this.fSelectionLength = length;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 5) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.change.type");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (IJavaScriptUnit)element;
            type = extended.getAttribute(ATTRIBUTE_TYPE);
            if (type == null || "".equals(type)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPE));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fSelectedTypeName = type;
        return new RefactoringStatus();
    }

    private class SourceRangeComputer
    extends TargetSourceRangeComputer {
        private SourceRangeComputer() {
        }

        public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode node) {
            return new TargetSourceRangeComputer.SourceRange(node.getStartPosition(), node.getLength());
        }
    }
}

