/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.infoviews;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.infoviews.CopyToClipboardAction;
import org.eclipse.wst.jsdt.internal.ui.infoviews.GotoInputAction;
import org.eclipse.wst.jsdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;
import org.eclipse.wst.jsdt.ui.JSdocContentAccess;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public abstract class AbstractInfoView
extends ViewPart
implements ISelectionListener,
IMenuListener,
IPropertyChangeListener {
    private final long TITLE_FLAGS = 283710660642007L;
    private final long LOCAL_VARIABLE_TITLE_FLAGS = 283710660707543L;
    private static final long TOOLTIP_LABEL_FLAGS = 13196440454323L;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                IWorkbenchPart activePart = ref.getPage().getActivePart();
                if (activePart != null) {
                    AbstractInfoView.this.selectionChanged(activePart, ref.getPage().getSelection());
                }
                AbstractInfoView.this.startListeningForSelectionChanges();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.stopListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (!ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.computeAndSetInput(ref.getPart(false));
            }
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    };
    protected IJavaScriptElement fCurrentViewInput;
    private SelectionDispatchAction fCopyToClipboardAction;
    private GotoInputAction fGotoInputAction;
    private volatile int fComputeCount;
    private Color fBackgroundColor;
    private RGB fBackgroundColorRGB;

    protected abstract void setInput(Object var1);

    protected abstract Object computeInput(Object var1);

    protected abstract void internalCreatePartControl(Composite var1);

    protected abstract void setForeground(Color var1);

    protected abstract void setBackground(Color var1);

    abstract Control getControl();

    protected abstract String getHelpContextId();

    public final void createPartControl(Composite parent) {
        this.internalCreatePartControl(parent);
        this.inititalizeColors();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
        this.createContextMenu();
        this.createActions();
        this.fillActionBars(this.getViewSite().getActionBars());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    protected void createActions() {
        this.fGotoInputAction = new GotoInputAction(this);
        this.fGotoInputAction.setEnabled(false);
        this.fCopyToClipboardAction = new CopyToClipboardAction((IWorkbenchSite)this.getViewSite());
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, this.getSelectionProvider());
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("additions"));
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            menu.appendToGroup("group.edit", action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            menu.appendToGroup("group.edit", action);
        }
        menu.appendToGroup("group.open", (IAction)this.fGotoInputAction);
    }

    protected IAction getSelectAllAction() {
        return null;
    }

    protected IAction getCopyToClipboardAction() {
        return this.fCopyToClipboardAction;
    }

    protected IJavaScriptElement getInput() {
        return this.fCurrentViewInput;
    }

    ISelectionProvider getSelectionProvider() {
        return this.getViewSite().getSelectionProvider();
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), action);
        }
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.fGotoInputAction);
    }

    private void inititalizeColors() {
        Color bgColor;
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        this.setForeground(display.getSystemColor(28));
        ColorRegistry registry = JFaceResources.getColorRegistry();
        registry.addListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = registry.getRGB(this.getBackgroundColorKey());
        if (this.fBackgroundColorRGB == null) {
            bgColor = display.getSystemColor(29);
            this.fBackgroundColorRGB = bgColor.getRGB();
        } else {
            this.fBackgroundColor = bgColor = new Color((Device)display, this.fBackgroundColorRGB);
        }
        this.setBackground(bgColor);
    }

    protected abstract String getBackgroundColorKey();

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getBackgroundColorKey().equals(event.getProperty())) {
            this.inititalizeColors();
        }
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.equals((Object)this)) {
            return;
        }
        this.computeAndSetInput(part);
    }

    protected boolean isIgnoringNewInput(IJavaScriptElement je, IWorkbenchPart part, ISelection selection) {
        return this.fCurrentViewInput != null && this.fCurrentViewInput.equals(je) && je != null;
    }

    protected IJavaScriptElement findSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        Object element;
        block13: {
            block12: {
                element = null;
                try {
                    if (!(part instanceof JavaEditor) || !(selection instanceof ITextSelection)) break block12;
                    IJavaScriptElement[] elements = TextSelectionConverter.codeResolve((JavaEditor)part, (ITextSelection)selection);
                    if (elements != null) {
                        if (elements.length > 1) {
                            int i = 0;
                            while (i < elements.length) {
                                if (elements[i] != null) {
                                    int elementType = elements[i].getElementType();
                                    if ((elementType == 9 || elementType == 8 || elementType == 7 || elementType == 10) && JSdocContentAccess.getContentReader((IMember)elements[i], true) != null) {
                                        return elements[i];
                                    }
                                    if (elementType == 14 && JSdocContentAccess.getContentReader((ILocalVariable)elements[i], true) != null) {
                                        return elements[i];
                                    }
                                }
                                ++i;
                            }
                        } else if (elements.length > 0) {
                            return elements[0];
                        }
                        break block13;
                    }
                    return null;
                }
                catch (JavaScriptModelException e) {
                    return null;
                }
            }
            if (selection instanceof IStructuredSelection) {
                element = SelectionUtil.getSingleElement(selection);
                break block13;
            }
            return null;
        }
        return this.findJavaElement(element);
    }

    private IJavaScriptElement findJavaElement(Object element) {
        if (element == null) {
            return null;
        }
        IJavaScriptElement je = null;
        if (element instanceof IAdaptable) {
            je = (IJavaScriptElement)((IAdaptable)element).getAdapter(IJavaScriptElement.class);
        }
        return je;
    }

    protected IType getTypeForCU(IJavaScriptUnit cu) {
        if (cu == null || !cu.exists()) {
            return null;
        }
        IType primaryType = cu.findPrimaryType();
        if (primaryType != null) {
            return primaryType;
        }
        try {
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                return types[0];
            }
            return null;
        }
        catch (JavaScriptModelException ex) {
            return null;
        }
    }

    public final void dispose() {
        ++this.fComputeCount;
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = null;
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        this.internalDispose();
    }

    protected abstract void internalDispose();

    private void computeAndSetInput(final IWorkbenchPart part) {
        final int currentCount = ++this.fComputeCount;
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider == null) {
            return;
        }
        final ISelection selection = provider.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Thread thread = new Thread("Info view input computer"){

            public void run() {
                if (currentCount != AbstractInfoView.this.fComputeCount) {
                    return;
                }
                final IJavaScriptElement je = AbstractInfoView.this.findSelectedJavaElement(part, selection);
                if (AbstractInfoView.this.isIgnoringNewInput(je, part, selection)) {
                    return;
                }
                final Object input = AbstractInfoView.this.computeInput(je);
                if (input == null) {
                    return;
                }
                Shell shell = AbstractInfoView.this.getSite().getShell();
                if (shell.isDisposed()) {
                    return;
                }
                Display display = shell.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (AbstractInfoView.this.fComputeCount != currentCount || AbstractInfoView.this.getViewSite().getShell().isDisposed()) {
                            return;
                        }
                        (this).AbstractInfoView.this.fCurrentViewInput = je;
                        AbstractInfoView.this.doSetInput(input);
                    }
                });
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    private void doSetInput(Object input) {
        this.setInput(input);
        this.fGotoInputAction.setEnabled(true);
        IJavaScriptElement inputElement = this.getInput();
        long flags = inputElement instanceof ILocalVariable ? 283710660707543L : 283710660642007L;
        this.setContentDescription(JavaScriptElementLabels.getElementLabel(inputElement, flags));
        this.setTitleToolTip(JavaScriptElementLabels.getElementLabel(inputElement, 13196440454323L));
    }
}

