/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.CompilationUnitEntry;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.FileEntry;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchQuery;

public class NLSSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private static final Match[] NO_MATCHES = new Match[0];
    private NLSSearchQuery fQuery;
    private final List fFileEntryGroups;
    private final List fCompilationUnitGroups;

    public NLSSearchResult(NLSSearchQuery query) {
        this.fQuery = query;
        this.fFileEntryGroups = new ArrayList();
        this.fCompilationUnitGroups = new ArrayList();
    }

    public void addFileEntryGroup(FileEntry group) {
        this.fFileEntryGroups.add(group);
    }

    public void addCompilationUnitGroup(CompilationUnitEntry group) {
        this.fCompilationUnitGroups.add(group);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.computeContainedMatches(result, fileEditorInput.getFile());
        }
        if (editorInput instanceof IClassFileEditorInput) {
            IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)editorInput;
            HashSet matches = new HashSet();
            this.collectMatches(matches, (IJavaScriptElement)classFileEditorInput.getClassFile());
            return matches.toArray(new Match[matches.size()]);
        }
        return NO_MATCHES;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        HashSet<Match> matches = new HashSet<Match>();
        for (Object element : this.fFileEntryGroups) {
            if (!((FileEntry)element).getPropertiesFile().equals((Object)file)) continue;
            matches.addAll(Arrays.asList(this.getMatches(element)));
        }
        if (matches.size() > 0) {
            return matches.toArray(new Match[matches.size()]);
        }
        try {
            for (Object element : this.fCompilationUnitGroups) {
                IJavaScriptUnit cu = ((CompilationUnitEntry)element).getCompilationUnit();
                if (!cu.exists() || !file.equals((Object)cu.getCorrespondingResource())) continue;
                matches.addAll(Arrays.asList(this.getMatches(element)));
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
            return NO_MATCHES;
        }
        IJavaScriptElement javaElement = JavaScriptCore.create((IFile)file);
        this.collectMatches(matches, javaElement);
        return matches.toArray(new Match[matches.size()]);
    }

    private void collectMatches(Set matches, IJavaScriptElement element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                IJavaScriptElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.collectMatches(matches, children[i]);
                    ++i;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {
                // empty catch block
            }
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof FileEntry) {
            return ((FileEntry)element).getPropertiesFile();
        }
        Object javaElement = null;
        javaElement = element instanceof CompilationUnitEntry ? ((CompilationUnitEntry)element).getCompilationUnit() : (IJavaScriptElement)element;
        IResource resource = null;
        try {
            resource = javaElement.getCorrespondingResource();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (match.getElement() instanceof FileEntry) {
            IFile file = ((FileEntry)match.getElement()).getPropertiesFile();
            if (editorInput instanceof IFileEditorInput) {
                return ((IFileEditorInput)editorInput).getFile().equals((Object)file);
            }
        } else if (match.getElement() instanceof IJavaScriptElement || match.getElement() instanceof CompilationUnitEntry) {
            Object je = null;
            je = match.getElement() instanceof IJavaScriptElement ? (IJavaScriptElement)match.getElement() : ((CompilationUnitEntry)match.getElement()).getCompilationUnit();
            if (editorInput instanceof IFileEditorInput) {
                IJavaScriptUnit cu;
                block9: {
                    try {
                        cu = (IJavaScriptUnit)je.getAncestor(5);
                        if (cu != null) break block9;
                        return false;
                    }
                    catch (JavaScriptModelException e) {
                        return false;
                    }
                }
                return ((IFileEditorInput)editorInput).getFile().equals((Object)cu.getCorrespondingResource());
            }
            if (editorInput instanceof IClassFileEditorInput) {
                return ((IClassFileEditorInput)editorInput).getClassFile().equals(je.getAncestor(6));
            }
        }
        return false;
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

