/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class CutAction
extends SelectionDispatchAction {
    private CopyToClipboardAction fCopyToClipboardAction;

    public CutAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        this.setText(ReorgMessages.CutAction_text);
        this.fCopyToClipboardAction = new CopyToClipboardAction(site, clipboard);
        ISharedImages workbenchImages = JavaScriptPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.cut_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            try {
                if (!CutAction.containsOnlyElementsInsideCompilationUnits(selection) || CutAction.containsTopLevelTypes(selection)) {
                    this.setEnabled(false);
                    return;
                }
                this.fCopyToClipboardAction.selectionChanged(selection);
                this.setEnabled(this.fCopyToClipboardAction.isEnabled() && RefactoringAvailabilityTester.isDeleteAvailable(selection));
            }
            catch (CoreException e) {
                if (JavaModelUtil.isExceptionToBeLogged(e)) {
                    JavaScriptPlugin.log(e);
                }
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    private static boolean containsOnlyElementsInsideCompilationUnits(IStructuredSelection selection) {
        for (Object object : selection) {
            if (object instanceof IJavaScriptElement && ReorgUtils.isInsideCompilationUnit((IJavaScriptElement)object)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsTopLevelTypes(IStructuredSelection selection) {
        for (Object each : selection) {
            if (!(each instanceof IType) || ((IType)each).getDeclaringType() != null) continue;
            return true;
        }
        return false;
    }

    public void run(IStructuredSelection selection) {
        try {
            this.selectionChanged(selection);
            if (this.isEnabled()) {
                this.fCopyToClipboardAction.run(selection);
                RefactoringExecutionStarter.startCutRefactoring(selection.toArray(), this.getShell());
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

