/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFunctionCall;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.IndirectMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class MessageSend
extends Expression
implements InvocationSite,
IFunctionCall {
    public Expression receiver;
    public char[] selector;
    public Expression[] arguments;
    public MethodBinding binding;
    public TypeBinding expectedType;
    public long nameSourcePosition;
    public TypeBinding actualReceiverType;

    public char[] getSelector() {
        return this.selector;
    }

    public IExpression[] getArguments() {
        return this.arguments;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        Binding existingVariable;
        boolean nonStatic;
        boolean bl = nonStatic = this.binding == null || !this.binding.isStatic();
        if (this.receiver != null) {
            flowInfo = this.receiver.analyseCode(currentScope, flowContext, flowInfo, nonStatic).unconditionalInits();
            if (nonStatic) {
                this.receiver.checkNPE(currentScope, flowContext, flowInfo);
            }
        }
        if (this.selector != null && (existingVariable = currentScope.getLocalBinding(this.selector, 3, this, false)) != null && existingVariable instanceof LocalVariableBinding) {
            LocalVariableBinding localBinding = (LocalVariableBinding)existingVariable;
            if ((flowInfo.tagBits & 1) == 0) {
                localBinding.useFlag = 1;
            } else if (localBinding.useFlag == 0) {
                localBinding.useFlag = 2;
            }
        }
        if (this.arguments != null) {
            int length = this.arguments.length;
            int i = 0;
            while (i < length) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        return flowInfo;
    }

    public boolean isSuperAccess() {
        return this.receiver != null && this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.receiver != null && !this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, output);
            if (this.selector != null) {
                output.append('.');
            }
        }
        if (this.selector != null) {
            output.append(this.selector);
        }
        output.append('(');
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(')');
    }

    public TypeBinding resolveType(BlockScope scope) {
        ReferenceContext referenceContext;
        TypeBinding returnType;
        this.constant = Constant.NotAConstant;
        if (this.receiver instanceof FunctionExpression) {
            FunctionExpression expr = (FunctionExpression)this.receiver;
            if (expr.methodDeclaration != null && this.arguments != null && expr.methodDeclaration.arguments != null) {
                int i = 0;
                while (i < Math.min(this.arguments.length, expr.methodDeclaration.arguments.length)) {
                    Expression msgSndArgument = this.arguments[i];
                    Argument funcExprArgument = expr.methodDeclaration.arguments[i];
                    if (msgSndArgument != null) {
                        msgSndArgument.resolve(scope);
                        if (msgSndArgument.resolvedType != null) {
                            funcExprArgument.type = new SingleTypeReference(msgSndArgument.resolvedType.readableName(), 0L);
                            funcExprArgument.type.resolvedType = this.arguments[i].resolvedType;
                        }
                    }
                    ++i;
                }
            }
        }
        this.actualReceiverType = this.receiver != null ? this.receiver.resolveType(scope) : null;
        boolean receiverIsType = (this.receiver instanceof NameReference || this.receiver instanceof FieldReference || this.receiver instanceof ThisReference) && (this.receiver.bits & 4) != 0;
        TypeBinding[] argumentTypes = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                Expression argument = this.arguments[i];
                argumentTypes[i] = argument.resolveType(scope);
                if (argumentTypes[i] == null) {
                    argumentTypes[i] = TypeBinding.UNKNOWN;
                }
                ++i;
            }
        }
        if (this.selector == null) {
            this.binding = new IndirectMethodBinding(0, this.actualReceiverType, argumentTypes, scope.compilationUnitScope().referenceContext.compilationUnitBinding);
        } else {
            if (this.receiver == null) {
                this.binding = scope.getImplicitMethod(this.selector, argumentTypes, this);
            } else {
                MethodBinding tempBinding;
                Binding alternateBinding;
                this.binding = scope.getMethod(this.actualReceiverType, this.selector, argumentTypes, this);
                if (!this.binding.isValidBinding() && this.actualReceiverType != null && this.actualReceiverType.isFunctionType()) {
                    alternateBinding = this.receiver.alternateBinding();
                    if (alternateBinding instanceof TypeBinding) {
                        this.actualReceiverType = alternateBinding;
                        this.binding = scope.getMethod(this.actualReceiverType, this.selector, argumentTypes, this);
                        receiverIsType = true;
                    }
                } else if (!this.binding.isValidBinding() && receiverIsType && (tempBinding = scope.getMethod((TypeBinding)(alternateBinding = scope.getJavaLangFunction()), this.selector, argumentTypes, this)).isValidBinding()) {
                    this.actualReceiverType = alternateBinding;
                    this.binding = tempBinding;
                    receiverIsType = false;
                }
            }
            if (argumentTypes.length != this.binding.parameters.length) {
                scope.problemReporter().wrongNumberOfArguments(this, this.binding);
            }
        }
        if (!this.binding.isValidBinding() && this.actualReceiverType != TypeBinding.ANY && this.actualReceiverType != TypeBinding.UNKNOWN) {
            if (this.binding.declaringClass == null) {
                if (this.actualReceiverType == null || this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                } else {
                    return null;
                }
            }
            scope.problemReporter().invalidMethod(this, this.binding);
            MethodBinding closestMatch = ((ProblemMethodBinding)this.binding).closestMatch;
            switch (this.binding.problemId()) {
                case 3: {
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: {
                    if (closestMatch == null) break;
                    this.resolvedType = closestMatch.returnType;
                }
            }
            if (closestMatch != null) {
                this.binding = closestMatch;
                MethodBinding closestMatchOriginal = closestMatch.original();
                if ((closestMatchOriginal.isPrivate() || closestMatchOriginal.declaringClass.isLocalType()) && !scope.isDefinedInMethod(closestMatchOriginal)) {
                    closestMatchOriginal.original().modifiers |= 0x8000000;
                }
            }
            return this.resolvedType;
        }
        CompilerOptions compilerOptions = scope.compilerOptions();
        if (!this.binding.isStatic()) {
            if (receiverIsType && this.binding.isValidBinding()) {
                scope.problemReporter().mustUseAStaticMethod(this, this.binding);
            }
        } else if (this.receiver != null) {
            if (!(this.receiver.isImplicitThis() || this.receiver.isSuper() || receiverIsType)) {
                scope.problemReporter().nonStaticAccessToStaticMethod(this, this.binding);
            }
            if (!this.receiver.isImplicitThis()) {
                ReferenceBinding cfr_ignored_0 = this.binding.declaringClass;
            }
        }
        if (this.isMethodUseDeprecated(this.binding, scope, true)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if ((returnType = this.binding.returnType) == null) {
            returnType = TypeBinding.UNKNOWN;
        }
        this.resolvedType = returnType;
        if (this.receiver != null && this.receiver.isSuper() && compilerOptions.getSeverity(0x2000000000000L) != -1 && (referenceContext = scope.methodScope().referenceContext) instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)referenceContext;
            MethodBinding enclosingMethodBinding = abstractMethodDeclaration.binding;
            if (enclosingMethodBinding.isOverriding() && CharOperation.equals(this.binding.selector, enclosingMethodBinding.selector) && this.binding.areParametersEqual(enclosingMethodBinding)) {
                abstractMethodDeclaration.bits |= 0x10;
            }
        }
        return this.resolvedType;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
        if (receiverType == null) {
            return;
        }
        this.actualReceiverType = receiverType;
    }

    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    public void setExpectedType(TypeBinding expectedType) {
        this.expectedType = expectedType;
    }

    public void setFieldIndex(int depth) {
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            if (this.receiver != null) {
                this.receiver.traverse(visitor, blockScope);
            }
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, blockScope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public int getASTType() {
        return 42;
    }

    public IExpression getReceiver() {
        return this.receiver;
    }
}

