/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.ClassSignature;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceField;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceMethod;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;

public class BinaryTypeBinding
extends ReferenceBinding {
    protected ReferenceBinding superclass;
    protected ReferenceBinding enclosingType;
    protected FieldBinding[] fields;
    protected MethodBinding[] methods;
    protected ReferenceBinding[] memberTypes;
    protected LookupEnvironment environment;

    static Object convertMemberValue(Object binaryValue, LookupEnvironment env) {
        if (binaryValue == null) {
            return null;
        }
        if (binaryValue instanceof Constant) {
            return binaryValue;
        }
        if (binaryValue instanceof ClassSignature) {
            return env.getTypeFromSignature(((ClassSignature)binaryValue).getTypeName(), 0, -1, false, null);
        }
        if (binaryValue instanceof Object[]) {
            Object[] objects = (Object[])binaryValue;
            int length = objects.length;
            if (length == 0) {
                return objects;
            }
            Object[] values = new Object[length];
            int i = 0;
            while (i < length) {
                values[i] = BinaryTypeBinding.convertMemberValue(objects[i], env);
                ++i;
            }
            return values;
        }
        throw new IllegalStateException();
    }

    public static ReferenceBinding resolveType(ReferenceBinding type, LookupEnvironment environment, boolean convertGenericToRawType) {
        if (type instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)type).resolve(environment, convertGenericToRawType);
        }
        return type;
    }

    public static TypeBinding resolveType(TypeBinding type, LookupEnvironment environment, int rank) {
        switch (type.kind()) {
            case 68: {
                BinaryTypeBinding.resolveType(((ArrayBinding)type).leafComponentType, environment, rank);
                break;
            }
            default: {
                if (!(type instanceof UnresolvedReferenceBinding)) break;
                return ((UnresolvedReferenceBinding)type).resolve(environment, true);
            }
        }
        return type;
    }

    protected BinaryTypeBinding() {
    }

    public BinaryTypeBinding(PackageBinding packageBinding, ISourceType binaryType, LookupEnvironment environment) {
        this.compoundName = CharOperation.splitOn('/', binaryType.getName());
        this.fileName = binaryType.getFileName();
        this.computeId();
        this.tagBits |= 0x40L;
        this.environment = environment;
        this.fPackage = packageBinding;
        this.sourceName = binaryType.getFileName();
        this.modifiers = binaryType.getModifiers();
    }

    public FieldBinding[] availableFields() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            int length = this.fields.length;
            if (length > 1) {
                ReferenceBinding.sortFields(this.fields, 0, length);
            }
            this.tagBits |= 0x1000L;
        }
        FieldBinding[] availableFields = new FieldBinding[this.fields.length];
        int count = 0;
        int i = 0;
        while (i < this.fields.length) {
            try {
                availableFields[count] = this.resolveTypeFor(this.fields[i]);
                ++count;
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            ++i;
        }
        if (count < availableFields.length) {
            FieldBinding[] fieldBindingArray = availableFields;
            availableFields = new FieldBinding[count];
            System.arraycopy(fieldBindingArray, 0, availableFields, 0, count);
        }
        return availableFields;
    }

    public MethodBinding[] availableMethods() {
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        MethodBinding[] availableMethods = new MethodBinding[this.methods.length];
        int count = 0;
        int i = 0;
        while (i < this.methods.length) {
            try {
                availableMethods[count] = this.resolveTypesFor(this.methods[i]);
                ++count;
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            ++i;
        }
        if (count < availableMethods.length) {
            MethodBinding[] methodBindingArray = availableMethods;
            availableMethods = new MethodBinding[count];
            System.arraycopy(methodBindingArray, 0, availableMethods, 0, count);
        }
        return availableMethods;
    }

    void cachePartsFrom(ISourceType binaryType, boolean needFieldsAndMethods) {
        int size;
        this.memberTypes = Binding.NO_MEMBER_TYPES;
        ISourceType[] memberTypeStructures = binaryType.getMemberTypes();
        if (memberTypeStructures != null && (size = memberTypeStructures.length) > 0) {
            this.memberTypes = new ReferenceBinding[size];
            int i = 0;
            while (i < size) {
                this.memberTypes[i] = this.environment.getTypeFromConstantPoolName(memberTypeStructures[i].getName(), 0, -1, false);
                ++i;
            }
            this.tagBits |= 0x10000000L;
        }
        long sourceLevel = this.environment.globalOptions.sourceLevel;
        char[] typeSignature = null;
        if (typeSignature == null) {
            char[] superclassName = binaryType.getSuperclassName();
            if (superclassName != null) {
                this.superclass = this.environment.getTypeFromConstantPoolName(superclassName, 0, -1, false);
                this.tagBits |= 0x2000000L;
            }
        } else {
            SignatureWrapper wrapper = new SignatureWrapper(typeSignature);
            if (wrapper.signature[wrapper.start] == '<') {
                ++wrapper.start;
                ++wrapper.start;
                this.tagBits |= 0x1000000L;
            }
            this.superclass = (ReferenceBinding)this.environment.getTypeFromTypeSignature(wrapper, this);
            this.tagBits |= 0x2000000L;
        }
        if (needFieldsAndMethods) {
            this.createFields(binaryType.getFields(), sourceLevel);
            this.createMethods(binaryType.getMethods(), sourceLevel);
        } else {
            this.fields = Binding.NO_FIELDS;
            this.methods = Binding.NO_METHODS;
        }
    }

    private void createFields(ISourceField[] iFields, long sourceLevel) {
        int size;
        this.fields = Binding.NO_FIELDS;
        if (iFields != null && (size = iFields.length) > 0) {
            this.fields = new FieldBinding[size];
            boolean isViewedAsDeprecated = this.isViewedAsDeprecated();
            boolean hasRestrictedAccess = this.hasRestrictedAccess();
            int i = 0;
            while (i < size) {
                ISourceField binaryField = iFields[i];
                char[] fieldSignature = null;
                TypeBinding type = fieldSignature == null ? this.environment.getTypeFromSignature(binaryField.getTypeName(), 0, -1, false, this) : this.environment.getTypeFromTypeSignature(new SignatureWrapper(fieldSignature), this);
                FieldBinding field = new FieldBinding(((SourceField)((Object)binaryField)).getElementName().toCharArray(), type, binaryField.getModifiers() | 0x2000000, (ReferenceBinding)this);
                field.id = i;
                if (isViewedAsDeprecated && !field.isDeprecated()) {
                    field.modifiers |= 0x200000;
                }
                if (hasRestrictedAccess) {
                    field.modifiers |= 0x40000;
                }
                this.fields[i] = field;
                ++i;
            }
        }
    }

    private MethodBinding createMethod(ISourceMethod method, long sourceLevel) {
        int methodModifiers = method.getModifiers() | 0x2000000;
        if (sourceLevel < 0x310000L) {
            methodModifiers &= 0xFFFFFF7F;
        }
        throw new UnimplementedException("fix compile errors for this code");
    }

    private void createMethods(ISourceMethod[] iMethods, long sourceLevel) {
        int total = 0;
        int initialTotal = 0;
        int iClinit = -1;
        Object toSkip = null;
        if (iMethods != null) {
            total = initialTotal = iMethods.length;
            boolean keepBridgeMethods = sourceLevel < 0x310000L && this.environment.globalOptions.complianceLevel >= 0x310000L;
            int i = total;
            while (--i >= 0) {
                char[] methodName;
                ISourceMethod method = iMethods[i];
                if (iClinit != -1 || (methodName = ((SourceMethod)((Object)method)).getElementName().toCharArray()).length != 8 || methodName[0] != '<') continue;
                iClinit = i;
                --total;
            }
        }
        if (total == 0) {
            this.methods = Binding.NO_METHODS;
            return;
        }
        boolean isViewedAsDeprecated = this.isViewedAsDeprecated();
        boolean hasRestrictedAccess = this.hasRestrictedAccess();
        this.methods = new MethodBinding[total];
        if (total == initialTotal) {
            int i = 0;
            while (i < initialTotal) {
                MethodBinding method = this.createMethod(iMethods[i], sourceLevel);
                if (isViewedAsDeprecated && !method.isDeprecated()) {
                    method.modifiers |= 0x200000;
                }
                if (hasRestrictedAccess) {
                    method.modifiers |= 0x40000;
                }
                this.methods[i] = method;
                ++i;
            }
        } else {
            int i = 0;
            int index = 0;
            while (i < initialTotal) {
                if (iClinit != i && (toSkip == null || toSkip[i] != -1)) {
                    MethodBinding method = this.createMethod(iMethods[i], sourceLevel);
                    if (isViewedAsDeprecated && !method.isDeprecated()) {
                        method.modifiers |= 0x200000;
                    }
                    if (hasRestrictedAccess) {
                        method.modifiers |= 0x40000;
                    }
                    this.methods[index++] = method;
                }
                ++i;
            }
        }
    }

    public ReferenceBinding enclosingType() {
        if ((this.tagBits & 0x8000000L) == 0L) {
            return this.enclosingType;
        }
        this.enclosingType = BinaryTypeBinding.resolveType(this.enclosingType, this.environment, false);
        this.tagBits &= 0xFFFFFFFFF7FFFFFFL;
        return this.enclosingType;
    }

    public FieldBinding[] fields() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            int length = this.fields.length;
            if (length > 1) {
                ReferenceBinding.sortFields(this.fields, 0, length);
            }
            this.tagBits |= 0x1000L;
        }
        int i = this.fields.length;
        while (--i >= 0) {
            this.resolveTypeFor(this.fields[i]);
        }
        this.tagBits |= 0x2000L;
        return this.fields;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        int argCount = argumentTypes.length;
        long range = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
        if (range >= 0L) {
            int imethod = (int)range;
            int end = (int)(range >> 32);
            while (imethod <= end) {
                block7: {
                    MethodBinding method = this.methods[imethod];
                    if (method.parameters.length == argCount) {
                        this.resolveTypesFor(method);
                        TypeBinding[] toMatch = method.parameters;
                        int iarg = 0;
                        while (iarg < argCount) {
                            if (toMatch[iarg] == argumentTypes[iarg]) {
                                ++iarg;
                                continue;
                            }
                            break block7;
                        }
                        return method;
                    }
                }
                ++imethod;
            }
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        int argCount = argumentTypes.length;
        boolean foundNothing = true;
        long range = ReferenceBinding.binarySearch(selector, this.methods);
        if (range >= 0L) {
            int imethod = (int)range;
            int end = (int)(range >> 32);
            while (imethod <= end) {
                block9: {
                    MethodBinding method = this.methods[imethod];
                    foundNothing = false;
                    if (method.parameters.length == argCount) {
                        this.resolveTypesFor(method);
                        TypeBinding[] toMatch = method.parameters;
                        int iarg = 0;
                        while (iarg < argCount) {
                            if (toMatch[iarg] == argumentTypes[iarg]) {
                                ++iarg;
                                continue;
                            }
                            break block9;
                        }
                        return method;
                    }
                }
                ++imethod;
            }
        }
        if (foundNothing && this.getSuperBinding() != null) {
            if (refScope != null) {
                refScope.recordTypeReference(this.superclass);
            }
            return this.superclass.getExactMethod(selector, argumentTypes, refScope);
        }
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        if ((this.tagBits & 0x1000L) == 0L) {
            int length = this.fields.length;
            if (length > 1) {
                ReferenceBinding.sortFields(this.fields, 0, length);
            }
            this.tagBits |= 0x1000L;
        }
        FieldBinding field = ReferenceBinding.binarySearch(fieldName, this.fields);
        return needResolve && field != null ? this.resolveTypeFor(field) : field;
    }

    public ReferenceBinding getMemberType(char[] typeName) {
        int i = this.memberTypes.length;
        while (--i >= 0) {
            ReferenceBinding memberType = this.memberTypes[i];
            if (memberType instanceof UnresolvedReferenceBinding) {
                char[] name = memberType.sourceName;
                int prefixLength = this.compoundName[this.compoundName.length - 1].length + 1;
                if (name.length != prefixLength + typeName.length || !CharOperation.fragmentEquals(typeName, name, prefixLength, true)) continue;
                this.memberTypes[i] = BinaryTypeBinding.resolveType(memberType, this.environment, false);
                return this.memberTypes[i];
            }
            if (!CharOperation.equals(typeName, memberType.sourceName)) continue;
            return memberType;
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] selector) {
        long range;
        if ((this.tagBits & 0x8000L) != 0L) {
            long range2 = ReferenceBinding.binarySearch(selector, this.methods);
            if (range2 >= 0L) {
                int start = (int)range2;
                int end = (int)(range2 >> 32);
                int length = end - start + 1;
                if ((this.tagBits & 0x8000L) != 0L) {
                    MethodBinding[] result = new MethodBinding[length];
                    System.arraycopy(this.methods, start, result, 0, length);
                    return result;
                }
            }
            return Binding.NO_METHODS;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        if ((range = ReferenceBinding.binarySearch(selector, this.methods)) >= 0L) {
            int start = (int)range;
            int end = (int)(range >> 32);
            int length = end - start + 1;
            MethodBinding[] result = new MethodBinding[length];
            int i = start;
            int index = 0;
            while (i <= end) {
                result[index] = this.resolveTypesFor(this.methods[i]);
                ++i;
                ++index;
            }
            return result;
        }
        return Binding.NO_METHODS;
    }

    public boolean hasMemberTypes() {
        return this.memberTypes.length > 0;
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        return false;
    }

    public int kind() {
        return 4;
    }

    public ReferenceBinding[] memberTypes() {
        if ((this.tagBits & 0x10000000L) == 0L) {
            return this.memberTypes;
        }
        int i = this.memberTypes.length;
        while (--i >= 0) {
            this.memberTypes[i] = BinaryTypeBinding.resolveType(this.memberTypes[i], this.environment, false);
        }
        this.tagBits &= 0xFFFFFFFFEFFFFFFFL;
        return this.memberTypes;
    }

    public MethodBinding[] methods() {
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        int i = this.methods.length;
        while (--i >= 0) {
            this.resolveTypesFor(this.methods[i]);
        }
        this.tagBits |= 0x8000L;
        return this.methods;
    }

    private FieldBinding resolveTypeFor(FieldBinding field) {
        if ((field.modifiers & 0x2000000) == 0) {
            return field;
        }
        field.type = BinaryTypeBinding.resolveType(field.type, this.environment, 0);
        field.modifiers &= 0xFDFFFFFF;
        return field;
    }

    MethodBinding resolveTypesFor(MethodBinding method) {
        if ((method.modifiers & 0x2000000) == 0) {
            return method;
        }
        if (!method.isConstructor()) {
            method.returnType = BinaryTypeBinding.resolveType(method.returnType, this.environment, 0);
        }
        int i = method.parameters.length;
        while (--i >= 0) {
            method.parameters[i] = BinaryTypeBinding.resolveType(method.parameters[i], this.environment, 0);
        }
        method.modifiers &= 0xFDFFFFFF;
        return method;
    }

    public ReferenceBinding getSuperBinding() {
        if ((this.tagBits & 0x2000000L) == 0L) {
            return this.superclass;
        }
        this.superclass = BinaryTypeBinding.resolveType(this.superclass, this.environment, true);
        this.tagBits &= 0xFFFFFFFFFDFFFFFFL;
        if (this.superclass == null || this.superclass.problemId() == 1) {
            this.tagBits |= 0x20000L;
        }
        return this.superclass;
    }

    public String toString() {
        int length;
        int i;
        StringBuffer buffer = new StringBuffer();
        if (this.isDeprecated()) {
            buffer.append("deprecated ");
        }
        if (this.isPublic()) {
            buffer.append("public ");
        }
        if (this.isPrivate()) {
            buffer.append("private ");
        }
        if (this.isStatic() && this.isNestedType()) {
            buffer.append("static ");
        }
        if (this.isClass()) {
            buffer.append("class ");
        } else {
            buffer.append("interface ");
        }
        buffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        buffer.append("\n\textends ");
        buffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.enclosingType != null) {
            buffer.append("\n\tenclosing type : ");
            buffer.append(this.enclosingType.debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                buffer.append("\n/*   fields   */");
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    buffer.append(this.fields[i] != null ? "\n" + this.fields[i].toString() : "\nNULL FIELD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                buffer.append("\n/*   methods   */");
                i = 0;
                length = this.methods.length;
                while (i < length) {
                    buffer.append(this.methods[i] != null ? "\n" + this.methods[i].toString() : "\nNULL METHOD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                buffer.append("\n/*   members   */");
                i = 0;
                length = this.memberTypes.length;
                while (i < length) {
                    buffer.append(this.memberTypes[i] != null ? "\n" + this.memberTypes[i].toString() : "\nNULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL MEMBER TYPES");
        }
        buffer.append("\n\n\n");
        return buffer.toString();
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods;
    }
}

