/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.index;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

class PostponedRunnablesManager {
    private static final Object fRunnablesProcessingJobLock = new Object();
    private static RunnablesProcessingJob fRunnablesProcessingJob;

    PostponedRunnablesManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object addPostponedRunnable(ISafeRunnable runnable, int delay) {
        RunnablesProcessingJob.PostponedRunnable result;
        Object object = fRunnablesProcessingJobLock;
        synchronized (object) {
            if (fRunnablesProcessingJob == null) {
                fRunnablesProcessingJob = new RunnablesProcessingJob();
            }
            result = fRunnablesProcessingJob.addPostponedRunnable(runnable, delay);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cancelPostponedRunnable(Object runnable) throws IllegalArgumentException {
        Object object = fRunnablesProcessingJobLock;
        synchronized (object) {
            if (fRunnablesProcessingJob != null) {
                fRunnablesProcessingJob.removePostponedRunnable(runnable);
            }
        }
    }

    private static class RunnablesProcessingJob
    extends Job {
        private long fCurrentWaitTime;
        private long fTimeScheduled;
        private final List fRunnables;
        private final Object LOCK = new Object();

        protected RunnablesProcessingJob() {
            super(Messages.PostponedRunnablesManager_job_title);
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(10);
            this.fRunnables = new LinkedList();
            this.fCurrentWaitTime = -1L;
            this.fTimeScheduled = -1L;
        }

        protected PostponedRunnable addPostponedRunnable(ISafeRunnable runnable, int delay) {
            PostponedRunnable postponedAction = new PostponedRunnable(runnable, delay);
            this.addAction(postponedAction);
            return postponedAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removePostponedRunnable(Object runnable) throws IllegalArgumentException {
            if (runnable instanceof PostponedRunnable) {
                Object object = this.LOCK;
                synchronized (object) {
                    ((PostponedRunnable)runnable).cancel();
                    this.fRunnables.remove(runnable);
                }
            } else {
                throw new IllegalArgumentException("The given runnable to remove was not created from a call to PostponedRunnablesManager#addPostponedAction");
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.hasRunnablesToRun()) {
                List runnables = this.getRunnables();
                long shortestTimeToWait = 0L;
                int i = 0;
                while (i < runnables.size()) {
                    PostponedRunnable runnable = (PostponedRunnable)runnables.get(i);
                    if (!runnable.isCanceled()) {
                        if (runnable.doneWaiting()) {
                            runnable.run();
                        } else {
                            long timeToWait = runnable.timeToWait();
                            timeToWait = timeToWait < 0L ? 0L : timeToWait;
                            shortestTimeToWait = shortestTimeToWait < timeToWait ? shortestTimeToWait : timeToWait;
                            this.addAction(runnable);
                        }
                    }
                    ++i;
                }
                if (this.hasRunnablesToRun()) {
                    this.reSchedule(shortestTimeToWait + 100L);
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reSchedule(long newWaitTime) {
            Object object = this.LOCK;
            synchronized (object) {
                long aproxTimeLeftToWait = System.currentTimeMillis() - this.fTimeScheduled - this.fCurrentWaitTime;
                if (this.fCurrentWaitTime == -1L || newWaitTime < aproxTimeLeftToWait) {
                    this.cancel();
                    this.fCurrentWaitTime = newWaitTime;
                    this.fTimeScheduled = System.currentTimeMillis();
                    this.schedule(this.fCurrentWaitTime);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addAction(PostponedRunnable runnable) {
            Object object = this.LOCK;
            synchronized (object) {
                this.fRunnables.add(runnable);
            }
            this.reSchedule(runnable.fDelay);
        }

        private boolean hasRunnablesToRun() {
            return !this.fRunnables.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getRunnables() {
            ArrayList runnables = null;
            Object object = this.LOCK;
            synchronized (object) {
                this.fCurrentWaitTime = -1L;
                this.fTimeScheduled = -1L;
                runnables = new ArrayList(this.fRunnables);
                this.fRunnables.clear();
            }
            return runnables;
        }

        private static class PostponedRunnable {
            private final ISafeRunnable fRunnable;
            private final long fDelay;
            private final long fCreated;
            private boolean fCanceled;

            public PostponedRunnable(ISafeRunnable runnable, long delay) {
                this.fRunnable = runnable;
                this.fDelay = delay;
                this.fCreated = System.currentTimeMillis();
                this.fCanceled = false;
            }

            protected boolean doneWaiting() {
                return this.timeToWait() <= 0L;
            }

            protected long timeToWait() {
                return this.fDelay - (System.currentTimeMillis() - this.fCreated);
            }

            protected void cancel() {
                this.fCanceled = true;
            }

            protected boolean isCanceled() {
                return this.fCanceled;
            }

            protected void run() {
                SafeRunner.run((ISafeRunnable)this.fRunnable);
            }
        }
    }
}

