/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.ide.ResourceUtil;

public class BuildUtilities {
    public static IProject[] extractProjects(Object[] selection) {
        HashSet<IProject> projects = new HashSet<IProject>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentSelection = objectArray[n2];
            IResource resource = ResourceUtil.getResource(currentSelection);
            if (resource != null) {
                projects.add(resource.getProject());
            } else {
                ResourceMapping mapping = ResourceUtil.getResourceMapping(currentSelection);
                if (mapping != null) {
                    IProject[] theProjects;
                    IProject[] iProjectArray = theProjects = mapping.getProjects();
                    int n3 = theProjects.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IProject theProject = iProjectArray[n4];
                        projects.add(theProject);
                        ++n4;
                    }
                } else {
                    IProject project;
                    IMarker marker = ResourceUtil.getAdapter(currentSelection, IMarker.class, false);
                    if (marker instanceof IMarker && (project = marker.getResource().getProject()) != null) {
                        projects.add(project);
                    }
                }
            }
            ++n2;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public static IProject[] findSelectedProjects(IWorkbenchWindow window) {
        IEditorPart editor;
        IFile file;
        if (window == null) {
            return new IProject[0];
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return new IProject[0];
        }
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            return new IProject[0];
        }
        ISelection selection = window.getSelectionService().getSelection(activePart.getSite().getId());
        IProject[] selected = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            selected = BuildUtilities.extractProjects(((IStructuredSelection)selection).toArray());
        } else if (activePart instanceof IEditorPart && (file = ResourceUtil.getFile((editor = (IEditorPart)activePart).getEditorInput())) != null) {
            selected = new IProject[]{file.getProject()};
        }
        if (selected == null) {
            selected = new IProject[]{};
        }
        return selected;
    }

    public static boolean isEnabled(IProject[] projects, int trigger) {
        if (trigger == 10 && ResourcesPlugin.getWorkspace().isAutoBuilding() && !BuildUtilities.matchingTrigger(projects, 9, false)) {
            return false;
        }
        return BuildUtilities.matchingTrigger(projects, trigger, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean matchingTrigger(IProject[] projects, int trigger, boolean value) {
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                try {
                    IProjectDescription description = projects[i].getDescription();
                    ICommand[] iCommandArray = description.getBuildSpec();
                    int n = iCommandArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICommand buildSpec = iCommandArray[n2];
                        if (buildSpec.isBuilding(trigger) == value) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return false;
    }

    public static void saveEditors(Collection projects) {
        IWorkbenchWindow[] windows;
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                if (projects == null) {
                    page.saveAllEditors(false);
                } else {
                    IEditorPart[] iEditorPartArray = page.getDirtyEditors();
                    int n5 = iEditorPartArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IEditorPart editor = iEditorPartArray[n6];
                        IFile inputFile = ResourceUtil.getFile(editor.getEditorInput());
                        if (inputFile != null && projects.contains(inputFile.getProject())) {
                            page.saveEditor(editor, false);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private BuildUtilities() {
    }
}

