/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.internal.views.markers.Markers;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class MarkerCategory
extends MarkerSupportItem {
    boolean refreshing;
    int start;
    int end;
    MarkerEntry[] children;
    private String name;
    private int severity = -1;
    private Markers markers;

    MarkerCategory(Markers markers, int startIndex, int endIndex, String categoryName) {
        this.markers = markers;
        this.start = startIndex;
        this.end = endIndex;
        this.refreshing = false;
        this.name = categoryName;
    }

    @Override
    MarkerSupportItem[] getChildren() {
        if (this.children == null) {
            MarkerEntry[] allMarkers = this.markers.getMarkerEntryArray();
            int totalSize = this.getChildrenCount();
            this.children = new MarkerEntry[totalSize];
            System.arraycopy(allMarkers, this.start, this.children, 0, totalSize);
            MarkerEntry[] markerEntryArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                MarkerEntry markerEntry = markerEntryArray[n2];
                markerEntry.setCategory(this);
                ++n2;
            }
        }
        return this.children;
    }

    @Override
    int getChildrenCount() {
        return this.end - this.start + 1;
    }

    @Override
    String getDescription() {
        int size = this.getChildrenCount();
        MarkerContentGenerator generator = this.markers.getBuilder().getGenerator();
        boolean limitsEnabled = generator.isMarkerLimitsEnabled();
        int limit = generator.getMarkerLimits();
        if (limitsEnabled && size > limit) {
            return NLS.bind((String)MarkerMessages.Category_Limit_Label, (Object[])new Object[]{this.name, String.valueOf(limit), String.valueOf(this.getChildrenCount())});
        }
        if (size == 1) {
            return NLS.bind((String)MarkerMessages.Category_One_Item_Label, (Object[])new Object[]{this.name});
        }
        return NLS.bind((String)MarkerMessages.Category_Label, (Object[])new Object[]{this.name, String.valueOf(size)});
    }

    int getHighestSeverity() {
        if (this.severity >= 0) {
            return this.severity;
        }
        this.severity = 0;
        MarkerSupportItem[] markerSupportItemArray = this.getChildren();
        int n = markerSupportItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerSupportItem supportItem = markerSupportItemArray[n2];
            if (supportItem.isConcrete()) {
                int elementSeverity = supportItem.getAttributeValue("severity", -1);
                if (elementSeverity > this.severity) {
                    this.severity = elementSeverity;
                }
                if (this.severity == 2) {
                    return this.severity;
                }
            }
            ++n2;
        }
        return this.severity;
    }

    String getName() {
        return this.name;
    }

    @Override
    MarkerSupportItem getParent() {
        return null;
    }

    @Override
    boolean isConcrete() {
        return false;
    }

    @Override
    void clearCache() {
        MarkerSupportItem[] markerSupportItemArray = this.getChildren();
        int n = markerSupportItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerSupportItem supportItem = markerSupportItemArray[n2];
            supportItem.clearCache();
            ++n2;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.markers == null ? 0 : this.markers.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarkerCategory other = (MarkerCategory)obj;
        if (this.markers == null ? other.markers != null : !this.markers.equals(other.markers)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

